/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.tools;

import java.util.List;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.gef.tools.ToolUtilities;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.DuplicateRequest;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Control;

public class DragEditPartsTrackerEx
extends DragEditPartsTracker {
    public DragEditPartsTrackerEx(EditPart sourceEditPart) {
        super(sourceEditPart);
    }

    protected Command getCommand() {
        CompoundCommand command;
        if (!this.isMove()) {
            command = new CompoundCommand();
            this.addSourceCommands(false, command);
            if (this.getTargetEditPart() != null) {
                command.add(this.getTargetEditPart().getCommand(this.getTargetRequest()));
                if (command.canExecute()) {
                    return command;
                }
            }
        }
        command = new CompoundCommand();
        this.addSourceCommands(true, command);
        return command;
    }

    protected void addSourceCommands(boolean isMove, CompoundCommand command) {
        Request request = this.getTargetRequest();
        if (this.isCloneActive()) {
            List editparts = ToolUtilities.getSelectionWithoutDependants((EditPartViewer)this.getCurrentViewer());
            DuplicateRequest duplicateRequest = new DuplicateRequest();
            duplicateRequest.setEditParts(editparts);
            duplicateRequest.setExtendedData(request.getExtendedData());
            if (request instanceof ChangeBoundsRequest) {
                Point delta = ((ChangeBoundsRequest)request).getMoveDelta();
                MapModeUtil.getMapMode((IFigure)((IGraphicalEditPart)this.getTargetEditPart()).getFigure()).DPtoLP((Translatable)delta);
                duplicateRequest.setOffset(delta);
            }
            command.add(this.getTargetEditPart().getCommand((Request)duplicateRequest));
        } else {
            request.setType((Object)(isMove ? "move" : "drag"));
            for (EditPart editPart : this.getOperationSet()) {
                command.add(editPart.getCommand(request));
            }
        }
        request.setType((Object)"drop");
    }

    protected String getCommandName() {
        if (!this.isMove()) {
            return "drop";
        }
        return super.getCommandName();
    }

    protected boolean isMove() {
        if (!this.getOperationSet().contains(this.getSourceEditPart())) {
            return false;
        }
        return super.isMove();
    }

    protected void executeCurrentCommand() {
        super.executeCurrentCommand();
        if (this.isActive() && this.getOperationSet().size() > 0 && this.getOperationSet().get(0) instanceof IGraphicalEditPart) {
            IGraphicalEditPart editpart = (IGraphicalEditPart)this.getOperationSet().get(0);
            if (editpart.getFigure() == null || editpart.getFigure().getParent() == null || editpart.getFigure().getParent().getLayoutManager() == null) {
                return;
            }
            editpart.getFigure().getParent().getLayoutManager().layout(editpart.getFigure().getParent());
            this.reveal((EditPart)editpart);
        }
    }

    protected void reveal(EditPart editpart) {
        editpart.getViewer().reveal(editpart);
    }

    protected boolean handleDragInProgress() {
        boolean returnValue = super.handleDragInProgress();
        if (this.isInState(4) || this.isInState(32)) {
            this.updateAutoexposeHelper();
        }
        return returnValue;
    }

    protected Cursor calculateCursor() {
        if (this.isInState(4) || this.isInState(32)) {
            if (this.getAutoexposeHelper() != null) {
                return SharedCursors.HAND;
            }
            Control control = this.getCurrentViewer().getControl();
            if (control instanceof FigureCanvas) {
                Viewport viewport = ((FigureCanvas)control).getViewport();
                Rectangle rect = Rectangle.SINGLETON;
                viewport.getClientArea(rect);
                viewport.translateToParent((Translatable)rect);
                viewport.translateToAbsolute((Translatable)rect);
                if (!rect.contains(this.getLocation())) {
                    return this.getDisabledCursor();
                }
            }
        }
        return super.calculateCursor();
    }
}

