/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.printing.internal.util;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.OffscreenEditPartFactory;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.PageBreakEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.figures.PageBreaksFigure;
import org.eclipse.gmf.runtime.diagram.ui.internal.pagesetup.PageInfoHelper;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.util.DiagramEditorUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PrintHelperUtil {
    private static int scaleFactor = 100;
    private static int scaleWidth = 1;
    private static int scaleHeight = 1;

    public static int getScale() {
        return scaleFactor;
    }

    public static void setScale(int scale) {
        scaleFactor = scale;
    }

    public static int getScaleToWidth() {
        return scaleWidth;
    }

    public static void setScaleToWidth(int width) {
        scaleWidth = width;
    }

    public static int getScaleToHeight() {
        return scaleHeight;
    }

    public static void setScaleToHeight(int height) {
        scaleHeight = height;
    }

    public static DiagramEditPart createDiagramEditPart(Diagram diagram, PreferencesHint preferencesHint) {
        DiagramEditPart diagramEditPart = OffscreenEditPartFactory.getInstance().createDiagramEditPart(diagram, new Shell(), preferencesHint);
        while (Display.getDefault().readAndDispatch()) {
        }
        return diagramEditPart;
    }

    public static DiagramEditPart createDiagramEditPart(Diagram diagram, PreferencesHint preferencesHint, Shell shell) {
        DiagramEditPart diagramEditPart = OffscreenEditPartFactory.getInstance().createDiagramEditPart(diagram, shell, preferencesHint);
        while (Display.getDefault().readAndDispatch()) {
        }
        return diagramEditPart;
    }

    public static boolean initializePreferences(DiagramEditPart diagramEditPart, PreferencesHint preferencesHint) {
        assert (diagramEditPart.getViewer() instanceof DiagramGraphicalViewer);
        DiagramGraphicalViewer viewer = (DiagramGraphicalViewer)diagramEditPart.getViewer();
        boolean loadedPreferences = true;
        IPreferenceStore fPreferences = PrintHelperUtil.getPreferenceStoreForDiagram(diagramEditPart);
        if (fPreferences == null) {
            loadedPreferences = false;
            PreferenceStore defaults = new PreferenceStore();
            DiagramEditor.addDefaultPreferences((PreferenceStore)defaults, (PreferencesHint)preferencesHint);
            fPreferences = PrintHelperUtil.getWorkspacePreferenceStore(preferencesHint);
        } else if (!fPreferences.getBoolean("print.useDiagramSettings")) {
            int x = fPreferences.getInt("pagebreak.x");
            int y = fPreferences.getInt("pagebreak.y");
            fPreferences = PrintHelperUtil.getWorkspacePreferenceStore(preferencesHint);
            fPreferences.setValue("pagebreak.x", x);
            fPreferences.setValue("pagebreak.y", y);
        }
        viewer.hookWorkspacePreferenceStore(fPreferences);
        diagramEditPart.refreshPageBreaks();
        return loadedPreferences;
    }

    private static IPreferenceStore getPreferenceStoreForDiagram(DiagramEditPart diagramEP) {
        String id = ViewUtil.getIdStr((View)diagramEP.getDiagramView());
        IPreferenceStore fPreferences = PrintHelperUtil.loadPreferencesFromOpenDiagram(id);
        if (fPreferences != null) {
            return fPreferences;
        }
        IPath path = DiagramUIPlugin.getInstance().getStateLocation();
        String fileName = String.valueOf(path.toString()) + "/" + id;
        File file = new File(fileName);
        fPreferences = new PreferenceStore(fileName);
        if (file.exists()) {
            try {
                ((PreferenceStore)fPreferences).load();
                return fPreferences;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    private static IPreferenceStore loadPreferencesFromOpenDiagram(String id) {
        DiagramEditor diagramEditor = DiagramEditorUtil.findOpenedDiagramEditorForID((String)id);
        if (diagramEditor != null) {
            IDiagramGraphicalViewer viewer = diagramEditor.getDiagramGraphicalViewer();
            if (diagramEditor.getDiagramEditPart().getRoot() instanceof DiagramRootEditPart) {
                PageBreakEditPart pageBreakEditPart = ((DiagramRootEditPart)diagramEditor.getDiagramEditPart().getRoot()).getPageBreakEditPart();
                pageBreakEditPart.resize(diagramEditor.getDiagramEditPart().getChildrenBounds());
                pageBreakEditPart.updatePreferenceStore();
            }
            if (viewer instanceof DiagramGraphicalViewer) {
                DiagramGraphicalViewer diagramGraphicalViewer = (DiagramGraphicalViewer)viewer;
                return diagramGraphicalViewer.getWorkspaceViewerPreferenceStore();
            }
        }
        return null;
    }

    private static IPreferenceStore getWorkspacePreferenceStore(PreferencesHint preferencesHint) {
        return (IPreferenceStore)preferencesHint.getPreferenceStore();
    }

    public static Rectangle getPageBreakBounds(DiagramEditPart dgrmEP, boolean loadedPreferences) {
        RootEditPart rootEditPart;
        Rectangle pageBreakBounds = null;
        assert (dgrmEP.getViewer() instanceof DiagramGraphicalViewer);
        IPreferenceStore fPreferences = ((DiagramGraphicalViewer)dgrmEP.getViewer()).getWorkspaceViewerPreferenceStore();
        if (fPreferences.getBoolean("print.useWorkspaceSettings") && dgrmEP.getDiagramPreferencesHint().getPreferenceStore() != null) {
            fPreferences = (IPreferenceStore)dgrmEP.getDiagramPreferencesHint().getPreferenceStore();
        }
        if ((rootEditPart = dgrmEP.getRoot()) instanceof DiagramRootEditPart) {
            DiagramRootEditPart diagramRootEditPart = (DiagramRootEditPart)rootEditPart;
            PageBreakEditPart pageBreakEditPart = diagramRootEditPart.getPageBreakEditPart();
            if (pageBreakEditPart != null) {
                pageBreakEditPart.resize(dgrmEP.getChildrenBounds());
                if (loadedPreferences) {
                    Point p = new Point(fPreferences.getInt("pagebreak.x"), fPreferences.getInt("pagebreak.y"));
                    pageBreakEditPart.set(p, PageInfoHelper.getChildrenBounds((DiagramEditPart)((DiagramEditPart)diagramRootEditPart.getContents()), PageBreaksFigure.class));
                }
                pageBreakBounds = pageBreakEditPart.getFigure().getBounds();
            } else {
                pageBreakBounds = dgrmEP.getFigure().getBounds();
            }
        }
        return pageBreakBounds;
    }
}

