/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui.services;

import java.util.HashSet;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProvider;
import org.eclipse.gmf.runtime.common.core.service.IProviderChangeListener;
import org.eclipse.gmf.runtime.common.core.service.IProviderPolicy;
import org.eclipse.gmf.runtime.common.core.service.ProviderPriority;
import org.eclipse.gmf.runtime.common.core.service.Service;
import org.eclipse.gmf.runtime.diagram.core.DiagramEditingDomainFactory;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.palette.PaletteToolEntry;
import org.eclipse.gmf.runtime.diagram.ui.providers.DefaultPaletteProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.gmf.runtime.diagram.ui.services.palette.PaletteService;
import org.eclipse.gmf.runtime.gef.ui.internal.palette.PaletteDrawer;
import org.eclipse.gmf.runtime.gef.ui.internal.palette.PaletteStack;
import org.eclipse.gmf.tests.runtime.common.core.internal.util.TestingConfigurationElement;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;

public class PaletteServiceTests
extends TestCase {
    private static boolean shouldStaticMethodDrawerBeShown = false;
    MyPaletteService paletteService;

    public static boolean shouldStaticMethodDrawerBeShown() {
        return shouldStaticMethodDrawerBeShown;
    }

    public PaletteServiceTests(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)PaletteServiceTests.suite());
    }

    public static Test suite() {
        return new TestSuite(PaletteServiceTests.class);
    }

    private static PaletteEntry findChildPaletteEntry(PaletteContainer container, String childId) {
        for (PaletteEntry entry : container.getChildren()) {
            if (!entry.getId().equals(childId)) continue;
            return entry;
        }
        return null;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.setPaletteService(new MyPaletteService());
    }

    public MyPaletteService getPaletteService() {
        return this.paletteService;
    }

    public void setPaletteService(MyPaletteService service) {
        this.paletteService = service;
    }

    public void testCapabilityFiltering() throws Exception {
        MyPaletteService.ProviderDescriptor descriptorA = new MyPaletteService.ProviderDescriptor((IProvider)new ProviderA());
        this.getPaletteService().addPaletteProvider(ProviderPriority.LOW, descriptorA);
        MyPaletteService.ProviderDescriptor descriptorB = new MyPaletteService.ProviderDescriptor((IProvider)new ProviderB());
        this.getPaletteService().addPaletteProvider(ProviderPriority.MEDIUM, descriptorB);
        MyPaletteService.ProviderDescriptor descriptorC = new MyPaletteService.ProviderDescriptor((IProvider)new ProviderC());
        this.getPaletteService().addPaletteProvider(ProviderPriority.HIGH, descriptorC);
        MyPaletteService.ProviderDescriptor descriptorD = new MyPaletteService.ProviderDescriptor((IProvider)new ProviderD());
        this.getPaletteService().addPaletteProvider(ProviderPriority.HIGHEST, descriptorD);
        PaletteServiceTestEditor editor = new PaletteServiceTestEditor();
        PaletteRoot paletteRoot = this.getPaletteService().createPalette((IEditorPart)editor, "DUMMY CONTENT");
        PaletteDrawer drawerA = (PaletteDrawer)paletteRoot.getChildren().get(1);
        PaletteEntry toolA = (PaletteEntry)drawerA.getChildren().get(0);
        PaletteStack stackA = (PaletteStack)drawerA.getChildren().get(1);
        PaletteEntry stackAToolA = (PaletteEntry)stackA.getChildren().get(0);
        PaletteEntry stackAToolC = (PaletteEntry)stackA.getChildren().get(2);
        this.validatePaletteEntries(paletteRoot, true, true);
        stackA.setActiveEntry(stackAToolC);
        descriptorB.setActivitiesEnabled(false);
        this.getPaletteService().updatePalette(paletteRoot, (IEditorPart)editor, "DUMMY CONTENT");
        this.validatePaletteEntries(paletteRoot, false, true);
        descriptorB.setActivitiesEnabled(true);
        descriptorD.setActivitiesEnabled(false);
        this.getPaletteService().updatePalette(paletteRoot, (IEditorPart)editor, "DUMMY CONTENT");
        this.validatePaletteEntries(paletteRoot, true, false);
        descriptorB.setActivitiesEnabled(false);
        descriptorD.setActivitiesEnabled(true);
        this.getPaletteService().updatePalette(paletteRoot, (IEditorPart)editor, "DUMMY CONTENT");
        this.validatePaletteEntries(paletteRoot, false, true);
        descriptorD.setActivitiesEnabled(false);
        this.getPaletteService().updatePalette(paletteRoot, (IEditorPart)editor, "DUMMY CONTENT");
        this.validatePaletteEntries(paletteRoot, false, false);
        PaletteServiceTests.assertEquals((Object)drawerA, paletteRoot.getChildren().get(1));
        PaletteServiceTests.assertEquals((Object)toolA, drawerA.getChildren().get(0));
        PaletteServiceTests.assertEquals((Object)stackA, drawerA.getChildren().get(1));
        PaletteServiceTests.assertEquals((Object)stackAToolA, stackA.getChildren().get(0));
        PaletteServiceTests.assertEquals((Object)stackAToolC, (Object)stackA.getActiveEntry());
    }

    public void testCapabilityFilteringOfSpecificEntries() throws Exception {
        this.toggleActivity("MyPaletteActivityProviderID", true);
        this.toggleActivity("MyPaletteActivityEntriesID", true);
        PaletteServiceTestEditor editor = new PaletteServiceTestEditor();
        PaletteRoot paletteRoot = PaletteService.getInstance().createPalette((IEditorPart)editor, (Object)"DUMMY CONTENT");
        this.validateSpecificEntries(paletteRoot, true, true);
        this.toggleActivity("MyPaletteActivityEntriesID", false);
        PaletteService.getInstance().updatePalette(paletteRoot, (IEditorPart)editor, (Object)"DUMMY CONTENT");
        this.validateSpecificEntries(paletteRoot, true, false);
        this.toggleActivity("MyPaletteActivityProviderID", false);
        PaletteService.getInstance().updatePalette(paletteRoot, (IEditorPart)editor, (Object)"DUMMY CONTENT");
        this.validateSpecificEntries(paletteRoot, false, false);
        this.toggleActivity("MyPaletteActivityEntriesID", true);
        PaletteService.getInstance().updatePalette(paletteRoot, (IEditorPart)editor, (Object)"DUMMY CONTENT");
        this.validateSpecificEntries(paletteRoot, false, true);
    }

    private void validateSpecificEntries(PaletteRoot paletteRoot, boolean activityProviderIDEnabled, boolean activityEntriesIDEnabled) {
        PaletteDrawer nonActivityDrawer = null;
        PaletteDrawer activityEnabledDrawer = null;
        for (Object paletteEntry : paletteRoot.getChildren()) {
            if (!(paletteEntry instanceof PaletteDrawer)) continue;
            PaletteDrawer drawer = (PaletteDrawer)paletteEntry;
            if (drawer.getId().equals("nonActivityDrawerID")) {
                nonActivityDrawer = drawer;
                continue;
            }
            if (!drawer.getId().equals("activityEnabledDrawerID")) continue;
            activityEnabledDrawer = drawer;
        }
        if (!activityProviderIDEnabled) {
            PaletteServiceTests.assertNull(nonActivityDrawer);
            PaletteServiceTests.assertNull(activityEnabledDrawer);
        } else {
            PaletteServiceTests.assertNotNull(nonActivityDrawer);
            PaletteEntry nonActivityTool = PaletteServiceTests.findChildPaletteEntry(nonActivityDrawer, "nonActivityToolID");
            PaletteContainer nonActivityStack = (PaletteContainer)PaletteServiceTests.findChildPaletteEntry(nonActivityDrawer, "nonActivityStackID");
            PaletteEntry nonActivitySeparator = PaletteServiceTests.findChildPaletteEntry(nonActivityDrawer, "nonActivitySeparatorID");
            PaletteEntry activityEnabledTool = PaletteServiceTests.findChildPaletteEntry(nonActivityStack, "activityEnabledToolID");
            PaletteContainer activityEnabledStack = (PaletteContainer)PaletteServiceTests.findChildPaletteEntry((PaletteContainer)nonActivityDrawer, "activityEnabledStackID");
            PaletteEntry activityEnabledSeparator = PaletteServiceTests.findChildPaletteEntry((PaletteContainer)nonActivityDrawer, "activityEnabledSeparatorID");
            if (activityEntriesIDEnabled) {
                PaletteServiceTests.assertNotNull((Object)activityEnabledDrawer);
                PaletteServiceTests.assertNotNull((Object)activityEnabledTool);
                PaletteServiceTests.assertNotNull((Object)activityEnabledStack);
                PaletteServiceTests.assertNotNull((Object)activityEnabledSeparator);
                PaletteServiceTests.assertNotNull((Object)nonActivityTool);
                PaletteServiceTests.assertNotNull((Object)nonActivityStack);
                PaletteServiceTests.assertNotNull((Object)nonActivitySeparator);
            } else {
                PaletteServiceTests.assertNull((Object)activityEnabledDrawer);
                PaletteServiceTests.assertNull((Object)activityEnabledTool);
                PaletteServiceTests.assertNull((Object)activityEnabledStack);
                PaletteServiceTests.assertNull((Object)activityEnabledSeparator);
            }
        }
    }

    private void validatePaletteEntries(PaletteRoot paletteRoot, boolean providerBEnabled, boolean providerDEnabled) {
        PaletteDrawer drawerA = null;
        PaletteDrawer drawerB = null;
        int index = 1;
        drawerA = (PaletteDrawer)paletteRoot.getChildren().get(index++);
        PaletteServiceTests.assertEquals((String)ProviderA.DRAWER_A, (String)drawerA.getId());
        if (providerBEnabled) {
            drawerB = (PaletteDrawer)paletteRoot.getChildren().get(index++);
            PaletteServiceTests.assertEquals((String)ProviderB.DRAWER_B, (String)drawerB.getId());
        }
        PaletteServiceTests.assertEquals((String)ProviderC.DRAWER_C, (String)((PaletteDrawer)paletteRoot.getChildren().get(index++)).getId());
        if (providerDEnabled) {
            PaletteServiceTests.assertEquals((String)ProviderD.DRAWER_D, (String)((PaletteDrawer)paletteRoot.getChildren().get(index++)).getId());
        }
        index = 0;
        PaletteServiceTests.assertEquals((String)ProviderA.TOOL_A, (String)((PaletteEntry)drawerA.getChildren().get(index++)).getId());
        PaletteStack stackA = (PaletteStack)drawerA.getChildren().get(index++);
        PaletteServiceTests.assertEquals((String)ProviderA.STACK_A, (String)stackA.getId());
        if (providerBEnabled) {
            PaletteServiceTests.assertEquals((String)ProviderB.TOOL_B, (String)((PaletteEntry)drawerA.getChildren().get(index++)).getId());
        }
        PaletteServiceTests.assertEquals((String)ProviderC.TOOL_C, (String)((PaletteEntry)drawerA.getChildren().get(index++)).getId());
        if (providerDEnabled) {
            PaletteServiceTests.assertEquals((String)ProviderD.TOOL_D, (String)((PaletteEntry)drawerA.getChildren().get(index++)).getId());
        }
        index = 0;
        PaletteServiceTests.assertEquals((String)ProviderA.TOOL_A, (String)((PaletteEntry)stackA.getChildren().get(index++)).getId());
        if (providerBEnabled) {
            PaletteServiceTests.assertEquals((String)ProviderB.TOOL_B, (String)((PaletteEntry)stackA.getChildren().get(index++)).getId());
        }
        PaletteServiceTests.assertEquals((String)ProviderC.TOOL_C, (String)((PaletteEntry)stackA.getChildren().get(index++)).getId());
        if (providerDEnabled) {
            PaletteServiceTests.assertEquals((String)ProviderD.TOOL_D, (String)((PaletteEntry)stackA.getChildren().get(index++)).getId());
        }
        if (providerBEnabled) {
            index = 0;
            PaletteServiceTests.assertEquals((String)ProviderB.TOOL_B, (String)((PaletteEntry)drawerB.getChildren().get(index++)).getId());
            if (providerDEnabled) {
                PaletteServiceTests.assertEquals((String)ProviderD.TOOL_D, (String)((PaletteEntry)drawerB.getChildren().get(index++)).getId());
            }
        }
    }

    public void testPredefineAndContributeEntries() throws Exception {
        PaletteServiceTestEditor editor = new PaletteServiceTestEditor();
        PaletteRoot paletteRoot = PaletteService.getInstance().createPalette((IEditorPart)editor, (Object)"DUMMY CONTENT");
        boolean ovalDrawerFound = false;
        boolean ovalAndCylinderDrawerFound = false;
        boolean ovalAndCylinderDrawerFoundDefinedOnly = false;
        boolean rectangleDrawerFound = false;
        for (Object paletteEntry : paletteRoot.getChildren()) {
            if (!(paletteEntry instanceof PaletteDrawer)) continue;
            PaletteDrawer drawer = (PaletteDrawer)paletteEntry;
            if (drawer.getId().equals("ovalDrawer")) {
                ovalDrawerFound = true;
                PaletteServiceTests.assertEquals((String)"oval", (String)((PaletteEntry)drawer.getChildren().get(0)).getId());
                PaletteServiceTests.assertEquals((int)1, (int)drawer.getChildren().size());
                continue;
            }
            if (drawer.getId().equals("ovalAndCylinderDrawer")) {
                ovalAndCylinderDrawerFound = true;
                PaletteServiceTests.assertEquals((String)"oval", (String)((PaletteEntry)drawer.getChildren().get(0)).getId());
                PaletteServiceTests.assertEquals((String)"cylinder", (String)((PaletteEntry)drawer.getChildren().get(1)).getId());
                PaletteServiceTests.assertTrue((boolean)drawer.isInitiallyOpen());
                continue;
            }
            if (drawer.getId().equals("ovalAndCylinderDrawerDefinedOnly")) {
                ovalAndCylinderDrawerFoundDefinedOnly = true;
                PaletteServiceTests.assertEquals((String)"oval", (String)((PaletteEntry)drawer.getChildren().get(0)).getId());
                PaletteServiceTests.assertEquals((String)"cylinder", (String)((PaletteEntry)drawer.getChildren().get(1)).getId());
                PaletteServiceTests.assertTrue((boolean)drawer.isInitiallyOpen());
                continue;
            }
            if (!drawer.getId().equals("rectangleDrawer")) continue;
            rectangleDrawerFound = true;
            PaletteServiceTests.assertEquals((String)"square", (String)((PaletteEntry)drawer.getChildren().get(0)).getId());
        }
        PaletteServiceTests.assertTrue((boolean)ovalDrawerFound);
        PaletteServiceTests.assertTrue((boolean)ovalAndCylinderDrawerFound);
        PaletteServiceTests.assertTrue((boolean)ovalAndCylinderDrawerFoundDefinedOnly);
        PaletteServiceTests.assertTrue((boolean)rectangleDrawerFound);
    }

    public void testStaticMethodInPaletteExtension() throws Exception {
        PaletteDrawer drawer;
        shouldStaticMethodDrawerBeShown = false;
        PaletteServiceTestEditor editor = new PaletteServiceTestEditor();
        PaletteRoot paletteRoot = PaletteService.getInstance().createPalette((IEditorPart)editor, (Object)"DUMMY CONTENT");
        boolean staticMethodDrawerFound = false;
        for (Object paletteEntry : paletteRoot.getChildren()) {
            if (!(paletteEntry instanceof PaletteDrawer) || !(drawer = (PaletteDrawer)paletteEntry).getId().equals("staticMethodDrawer")) continue;
            staticMethodDrawerFound = true;
        }
        PaletteServiceTests.assertFalse((boolean)staticMethodDrawerFound);
        shouldStaticMethodDrawerBeShown = true;
        editor = new PaletteServiceTestEditor();
        paletteRoot = PaletteService.getInstance().createPalette((IEditorPart)editor, (Object)"DUMMY CONTENT");
        staticMethodDrawerFound = false;
        for (Object paletteEntry : paletteRoot.getChildren()) {
            if (!(paletteEntry instanceof PaletteDrawer) || !(drawer = (PaletteDrawer)paletteEntry).getId().equals("staticMethodDrawer")) continue;
            staticMethodDrawerFound = true;
        }
        PaletteServiceTests.assertTrue((boolean)staticMethodDrawerFound);
        shouldStaticMethodDrawerBeShown = false;
        editor = new PaletteServiceTestEditor();
        paletteRoot = PaletteService.getInstance().createPalette((IEditorPart)editor, (Object)"DUMMY CONTENT");
        staticMethodDrawerFound = false;
        for (Object paletteEntry : paletteRoot.getChildren()) {
            if (!(paletteEntry instanceof PaletteDrawer) || !(drawer = (PaletteDrawer)paletteEntry).getId().equals("staticMethodDrawer")) continue;
            staticMethodDrawerFound = true;
        }
        PaletteServiceTests.assertFalse((boolean)staticMethodDrawerFound);
    }

    private void toggleActivity(String activityID, boolean enabled) {
        boolean changeMade;
        IWorkbenchActivitySupport workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
        HashSet<String> enabledActivityIds = new HashSet<String>(workbenchActivitySupport.getActivityManager().getEnabledActivityIds());
        boolean bl = changeMade = enabled ? enabledActivityIds.add(activityID) : enabledActivityIds.remove(activityID);
        if (changeMade) {
            workbenchActivitySupport.setEnabledActivityIds(enabledActivityIds);
        }
    }

    static class MyPaletteService
    extends PaletteService {
        protected MyPaletteService() {
        }

        public void addPaletteProvider(ProviderPriority priority, ProviderDescriptor provider) {
            super.addProvider(priority, (Service.ProviderDescriptor)provider);
        }

        public void removePaletteProvider(Service.ProviderDescriptor provider) {
            super.removeProvider(provider);
        }

        static class ProviderDescriptor
        extends PaletteService.ProviderDescriptor {
            public boolean areActivitiesEnabled = true;

            protected ProviderDescriptor(IProvider provider) {
                super((IConfigurationElement)new TestingConfigurationElement());
                this.provider = provider;
                provider.addProviderChangeListener((IProviderChangeListener)this);
            }

            public IProvider getProvider() {
                return this.provider;
            }

            protected IProviderPolicy getPolicy() {
                return null;
            }

            public boolean provides(IOperation operation) {
                return this.areActivitiesEnabled;
            }

            public void setActivitiesEnabled(boolean b) {
                this.areActivitiesEnabled = b;
            }
        }
    }

    public class PaletteServiceTestEditor
    extends DiagramDocumentEditor {
        final TransactionalEditingDomain editingDomain;

        public PaletteServiceTestEditor() {
            super(true);
            this.editingDomain = DiagramEditingDomainFactory.getInstance().createEditingDomain();
        }

        public TransactionalEditingDomain getEditingDomain() {
            return this.editingDomain;
        }
    }

    public static class ProviderA
    extends DefaultPaletteProvider {
        public static String DRAWER_A = "DRAWER_A";
        public static String TOOL_A = "TOOL_A";
        public static String STACK_A = "STACK_A";

        public void contributeToPalette(IEditorPart editor, Object content, PaletteRoot root, Map predefinedEntries) {
            PaletteDrawer drawerA = new PaletteDrawer(DRAWER_A, DRAWER_A);
            drawerA.add((PaletteEntry)new PaletteToolEntry(TOOL_A, TOOL_A, null));
            PaletteStack stackA = new PaletteStack(STACK_A, STACK_A, STACK_A, null);
            stackA.add((PaletteEntry)new PaletteToolEntry(TOOL_A, TOOL_A, null));
            drawerA.add((PaletteEntry)stackA);
            root.add((PaletteEntry)drawerA);
        }
    }

    public static class ProviderB
    extends DefaultPaletteProvider {
        public static String DRAWER_B = "DRAWER_B";
        public static String TOOL_B = "TOOL_B";

        public void contributeToPalette(IEditorPart editor, Object content, PaletteRoot root, Map predefinedEntries) {
            PaletteDrawer drawerB = new PaletteDrawer(DRAWER_B, DRAWER_B);
            drawerB.add((PaletteEntry)new PaletteToolEntry(TOOL_B, TOOL_B, null));
            root.add((PaletteEntry)drawerB);
            PaletteDrawer drawerA = (PaletteDrawer)PaletteServiceTests.findChildPaletteEntry((PaletteContainer)root, ProviderA.DRAWER_A);
            drawerA.add((PaletteEntry)new PaletteToolEntry(TOOL_B, TOOL_B, null));
            PaletteStack stackA = (PaletteStack)PaletteServiceTests.findChildPaletteEntry((PaletteContainer)drawerA, ProviderA.STACK_A);
            stackA.add((PaletteEntry)new PaletteToolEntry(TOOL_B, TOOL_B, null));
        }
    }

    public static class ProviderC
    extends DefaultPaletteProvider {
        public static String DRAWER_C = "DRAWER_C";
        public static String TOOL_C = "TOOL_C";

        public void contributeToPalette(IEditorPart editor, Object content, PaletteRoot root, Map predefinedEntries) {
            PaletteDrawer drawerC = new PaletteDrawer(DRAWER_C, DRAWER_C);
            drawerC.add((PaletteEntry)new PaletteToolEntry(TOOL_C, TOOL_C, null));
            root.add((PaletteEntry)drawerC);
            PaletteDrawer drawerA = (PaletteDrawer)PaletteServiceTests.findChildPaletteEntry((PaletteContainer)root, ProviderA.DRAWER_A);
            drawerA.add((PaletteEntry)new PaletteToolEntry(TOOL_C, TOOL_C, null));
            PaletteStack stackA = (PaletteStack)PaletteServiceTests.findChildPaletteEntry((PaletteContainer)drawerA, ProviderA.STACK_A);
            stackA.add((PaletteEntry)new PaletteToolEntry(TOOL_C, TOOL_C, null));
        }
    }

    public static class ProviderD
    extends DefaultPaletteProvider {
        public static String DRAWER_D = "DRAWER_D";
        public static String TOOL_D = "TOOL_D";

        public void contributeToPalette(IEditorPart editor, Object content, PaletteRoot root, Map predefinedEntries) {
            PaletteDrawer drawerD = new PaletteDrawer(DRAWER_D, DRAWER_D);
            drawerD.add((PaletteEntry)new PaletteToolEntry(TOOL_D, TOOL_D, null));
            root.add((PaletteEntry)drawerD);
            PaletteDrawer drawerA = (PaletteDrawer)PaletteServiceTests.findChildPaletteEntry((PaletteContainer)root, ProviderA.DRAWER_A);
            drawerA.add((PaletteEntry)new PaletteToolEntry(TOOL_D, TOOL_D, null));
            PaletteDrawer drawerB = (PaletteDrawer)PaletteServiceTests.findChildPaletteEntry((PaletteContainer)root, ProviderB.DRAWER_B);
            if (drawerB != null) {
                drawerB.add((PaletteEntry)new PaletteToolEntry(TOOL_D, TOOL_D, null));
            }
            PaletteStack stackA = (PaletteStack)PaletteServiceTests.findChildPaletteEntry((PaletteContainer)drawerA, ProviderA.STACK_A);
            stackA.add((PaletteEntry)new PaletteToolEntry(TOOL_D, TOOL_D, null));
        }
    }
}

