/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.graphdef.editor.edit.policies;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.graphdef.editor.edit.commands.ChildAccessCreateCommand;
import org.eclipse.gmf.graphdef.editor.edit.commands.ChildAccessReorientCommand;
import org.eclipse.gmf.graphdef.editor.edit.commands.PointCreateCommand;
import org.eclipse.gmf.graphdef.editor.edit.policies.GMFGraphBaseItemSemanticEditPolicy;
import org.eclipse.gmf.graphdef.editor.part.GMFGraphVisualIDRegistry;
import org.eclipse.gmf.graphdef.editor.providers.GMFGraphElementTypes;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.ICompositeCommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;

public class PolygonItemSemanticEditPolicy
extends GMFGraphBaseItemSemanticEditPolicy {
    public PolygonItemSemanticEditPolicy() {
        super(GMFGraphElementTypes.Polygon_3023);
    }

    protected Command getCreateCommand(CreateElementRequest req) {
        if (GMFGraphElementTypes.Point_3022 == req.getElementType()) {
            return this.getGEFWrapper((ICommand)new PointCreateCommand(req));
        }
        return super.getCreateCommand(req);
    }

    protected Command getDestroyElementCommand(DestroyElementRequest req) {
        View view = (View)this.getHost().getModel();
        CompositeTransactionalCommand cmd = new CompositeTransactionalCommand(this.getEditingDomain(), null);
        cmd.setTransactionNestingEnabled(false);
        for (Edge incomingLink : view.getTargetEdges()) {
            if (GMFGraphVisualIDRegistry.getVisualID((View)incomingLink) != 4002) continue;
            DestroyElementRequest r = new DestroyElementRequest(incomingLink.getElement(), false);
            cmd.add((IUndoableOperation)new DestroyElementCommand(r));
            cmd.add((IUndoableOperation)new DeleteCommand(this.getEditingDomain(), (View)incomingLink));
        }
        EAnnotation annotation = view.getEAnnotation("Shortcut");
        if (annotation == null) {
            this.addDestroyChildNodesCommand((ICompositeCommand)cmd);
            this.addDestroyShortcutsCommand((ICompositeCommand)cmd, view);
            cmd.add((IUndoableOperation)new DestroyElementCommand(req));
        } else {
            cmd.add((IUndoableOperation)new DeleteCommand(this.getEditingDomain(), view));
        }
        return this.getGEFWrapper(cmd.reduce());
    }

    private void addDestroyChildNodesCommand(ICompositeCommand cmd) {
        View view = (View)this.getHost().getModel();
        for (Node node : view.getChildren()) {
            switch (GMFGraphVisualIDRegistry.getVisualID((View)node)) {
                case 3022: {
                    cmd.add((IUndoableOperation)new DestroyElementCommand(new DestroyElementRequest(this.getEditingDomain(), node.getElement(), false)));
                }
            }
        }
    }

    protected Command getCreateRelationshipCommand(CreateRelationshipRequest req) {
        Command command = req.getTarget() == null ? this.getStartCreateRelationshipCommand(req) : this.getCompleteCreateRelationshipCommand(req);
        return command != null ? command : super.getCreateRelationshipCommand(req);
    }

    protected Command getStartCreateRelationshipCommand(CreateRelationshipRequest req) {
        if (GMFGraphElementTypes.ChildAccess_4002 == req.getElementType()) {
            return null;
        }
        return null;
    }

    protected Command getCompleteCreateRelationshipCommand(CreateRelationshipRequest req) {
        if (GMFGraphElementTypes.ChildAccess_4002 == req.getElementType()) {
            return this.getGEFWrapper((ICommand)new ChildAccessCreateCommand(req, req.getSource(), req.getTarget()));
        }
        return null;
    }

    protected Command getReorientRelationshipCommand(ReorientRelationshipRequest req) {
        switch (this.getVisualID((IEditCommandRequest)req)) {
            case 4002: {
                return this.getGEFWrapper((ICommand)new ChildAccessReorientCommand(req));
            }
        }
        return super.getReorientRelationshipCommand(req);
    }
}

