/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.editparts;

import java.lang.ref.WeakReference;
import java.util.Collection;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.OpenDiagramEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ViewComponentEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.NoteFigure;
import org.eclipse.gmf.runtime.diagram.ui.internal.editpolicies.DiagramLinkDragDropEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.internal.editpolicies.NonSemanticEditPolicy;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;

public class NoteEditPart
extends ShapeNodeEditPart {
    private ResourceListener listener = null;
    private boolean diagramLinkMode = false;

    public NoteEditPart(View view) {
        super(view);
    }

    protected NodeFigure createNodeFigure() {
        View notationView;
        IMapMode mm = this.getMapMode();
        int insetSize = mm.DPtoLP(5);
        Insets insets = new Insets(insetSize, insetSize, insetSize, insetSize);
        NoteFigure noteFigure = new NoteFigure(mm.DPtoLP(100), mm.DPtoLP(56), insets);
        Object model = this.getModel();
        if (model != null && model instanceof View && (notationView = (View)model) != null && (notationView.getEAnnotation("DiagramLink") != null || notationView.getType() == null || notationView.getType().length() == 0)) {
            this.diagramLinkMode = true;
            noteFigure.setDiagramLinkMode(true);
            noteFigure.setDefaultSize(insetSize, insetSize);
        }
        return noteFigure;
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.removeEditPolicy("SemanticPolicy");
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new NonSemanticEditPolicy());
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new DiagramLinkDragDropEditPolicy());
        this.installEditPolicy("OpenPolicy", (EditPolicy)new OpenDiagramEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ViewComponentEditPolicy());
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint("Description");
    }

    public Object getPreferredValue(EStructuralFeature feature) {
        Object preferenceStore = this.getDiagramPreferencesHint().getPreferenceStore();
        if (preferenceStore instanceof IPreferenceStore) {
            if (feature == NotationPackage.eINSTANCE.getLineStyle_LineColor()) {
                return FigureUtilities.RGBToInteger((RGB)PreferenceConverter.getColor((IPreferenceStore)((IPreferenceStore)preferenceStore), (String)"Appearance.noteLineColor"));
            }
            if (feature == NotationPackage.eINSTANCE.getFillStyle_FillColor()) {
                return FigureUtilities.RGBToInteger((RGB)PreferenceConverter.getColor((IPreferenceStore)((IPreferenceStore)preferenceStore), (String)"Appearance.noteFillColor"));
            }
        }
        return super.getPreferredValue(feature);
    }

    protected void addSemanticListeners() {
        if (this.diagramLinkMode) {
            if (this.listener == null) {
                this.listener = new ResourceListener(this.getNotationView().getElement().eResource(), this);
            }
            this.getEditingDomain().addResourceSetListener((ResourceSetListener)this.listener);
        }
        super.addSemanticListeners();
    }

    protected void removeSemanticListeners() {
        if (this.listener != null) {
            this.getEditingDomain().removeResourceSetListener((ResourceSetListener)this.listener);
            this.listener = null;
        }
        super.removeSemanticListeners();
    }

    protected void handleNotificationEvent(Notification notification) {
        Object feature = notification.getFeature();
        if (feature == NotationPackage.eINSTANCE.getView_Element() && notification.getEventType() == 9 && (EObject)notification.getNotifier() == this.getNotationView() && this.listener != null) {
            return;
        }
        if (NotationPackage.eINSTANCE.getLineStyle_LineWidth().equals(feature)) {
            this.refreshLineWidth();
        } else if (NotationPackage.eINSTANCE.getLineTypeStyle_LineType().equals(feature)) {
            this.refreshLineType();
        } else {
            super.handleNotificationEvent(notification);
        }
    }

    protected void setLineWidth(int width) {
        ((NoteFigure)this.getFigure()).setLineWidth(this.getMapMode().DPtoLP(width));
    }

    protected void setLineType(int lineType) {
        ((NoteFigure)this.getFigure()).setLineStyle(lineType);
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshLineType();
        this.refreshLineWidth();
    }

    private class ResourceListener
    extends ResourceSetListenerImpl {
        private WeakReference resourceRef = null;
        private NoteEditPart editPart = null;

        public ResourceListener(Resource resource, NoteEditPart editPart) {
            this.resourceRef = new WeakReference<Resource>(resource);
            this.editPart = editPart;
        }

        public void resourceSetChanged(ResourceSetChangeEvent event) {
            if (this.editPart == null || this.resourceRef.get() == null) {
                if (this.editPart != null && this.editPart.listener != null) {
                    NoteEditPart.this.getEditingDomain().removeResourceSetListener((ResourceSetListener)this.editPart.listener);
                    this.editPart.listener = null;
                }
                return;
            }
            boolean unloaded = this.isResourceUnloaded(event.getNotifications());
            if (unloaded && this.editPart.isActive()) {
                this.editPart.refresh();
                if (this.editPart.listener != null) {
                    NoteEditPart.this.getEditingDomain().removeResourceSetListener((ResourceSetListener)this.editPart.listener);
                    this.editPart.listener = null;
                }
            }
        }

        private boolean isResourceUnloaded(Collection notifications) {
            for (Notification next : notifications) {
                if (next.getNotifier() != this.resourceRef.get()) {
                    return false;
                }
                if (!NotificationFilter.RESOURCE_UNLOADED.matches(next)) continue;
                return true;
            }
            return false;
        }

        public boolean isPostcommitOnly() {
            return true;
        }
    }
}

