/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.services.palette;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gmf.runtime.common.core.service.ExecutionStrategy;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProvider;
import org.eclipse.gmf.runtime.common.core.service.Service;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.services.util.ActivityFilterProviderDescriptor;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.palette.ContributeToPaletteOperation;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.palette.PaletteProviderConfiguration;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.services.palette.IPaletteProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.palette.SelectionToolEx;
import org.eclipse.gmf.runtime.gef.ui.internal.palette.PaletteSeparator;
import org.eclipse.gmf.runtime.gef.ui.internal.palette.PaletteToolbar;
import org.eclipse.ui.IEditorPart;

public class PaletteService
extends Service
implements IPaletteProvider {
    private static final PaletteService instance = new PaletteService();
    public static final String GROUP_STANDARD = "standardGroup";
    public static final String SEPARATOR_STANDARD = "standardSeparator";
    public static final String TOOL_SELECTION = "selectionTool";

    static {
        instance.configureProviders(DiagramUIPlugin.getPluginId(), "paletteProviders");
    }

    public void setContributions(IConfigurationElement configElement) {
    }

    protected PaletteService() {
    }

    public static PaletteService getInstance() {
        return instance;
    }

    protected Service.ProviderDescriptor newProviderDescriptor(IConfigurationElement element) {
        return new ProviderDescriptor(element);
    }

    public void contributeToPalette(IEditorPart editor, Object content, PaletteRoot root, Map predefinedEntries) {
        PaletteToolbar standardGroup = new PaletteToolbar(GROUP_STANDARD, DiagramUIMessages.StandardGroup_Label);
        standardGroup.setDescription(DiagramUIMessages.StandardGroup_Description);
        root.add((PaletteEntry)standardGroup);
        PaletteSeparator standardSeparator = new PaletteSeparator(SEPARATOR_STANDARD);
        standardGroup.add((PaletteEntry)standardSeparator);
        SelectionToolEntry selectTool = new SelectionToolEntry();
        selectTool.setId(TOOL_SELECTION);
        selectTool.setToolClass(SelectionToolEx.class);
        standardGroup.add((PaletteEntry)selectTool);
        root.setDefaultEntry((ToolEntry)selectTool);
        this.execute(new ContributeToPaletteOperation(editor, content, root, predefinedEntries));
    }

    private List execute(IOperation operation) {
        return this.execute(ExecutionStrategy.REVERSE, operation);
    }

    public PaletteRoot createPalette(final IEditorPart editor, final Object content) {
        final PaletteRoot root = new PaletteRoot();
        try {
            EditingDomain domain;
            IEditingDomainProvider provider = (IEditingDomainProvider)editor.getAdapter(IEditingDomainProvider.class);
            if (provider != null && (domain = provider.getEditingDomain()) instanceof TransactionalEditingDomain) {
                ((TransactionalEditingDomain)domain).runExclusive(new Runnable(){

                    public void run() {
                        PaletteService.this.contributeToPalette(editor, content, root, new HashMap());
                    }
                });
            }
        }
        catch (Exception e) {
            Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, PaletteService.class, (String)"createPalette()", (Throwable)e);
        }
        return root;
    }

    public void updatePalette(PaletteRoot existingRoot, IEditorPart editor, Object content) {
        PaletteRoot newRoot = this.createPalette(editor, content);
        this.updatePaletteContainerEntries((PaletteContainer)existingRoot, (PaletteContainer)newRoot);
    }

    private void updatePaletteContainerEntries(PaletteContainer existingContainer, PaletteContainer newContainer) {
        HashMap<String, PaletteEntry> existingEntryIds = new HashMap<String, PaletteEntry>();
        for (PaletteEntry entry : existingContainer.getChildren()) {
            existingEntryIds.put(entry.getId(), entry);
        }
        int nextNewIndex = 0;
        for (PaletteEntry newEntry : newContainer.getChildren()) {
            PaletteEntry existingEntry = (PaletteEntry)existingEntryIds.get(newEntry.getId());
            if (existingEntry != null) {
                nextNewIndex = existingContainer.getChildren().indexOf(existingEntry) + 1;
                existingEntryIds.remove(existingEntry.getId());
                if (!(existingEntry instanceof PaletteContainer) || !(newEntry instanceof PaletteContainer)) continue;
                this.updatePaletteContainerEntries((PaletteContainer)existingEntry, (PaletteContainer)newEntry);
                continue;
            }
            existingContainer.add(nextNewIndex++, newEntry);
        }
        for (PaletteEntry entry : existingEntryIds.values()) {
            existingContainer.remove(entry);
        }
    }

    protected static class ProviderDescriptor
    extends ActivityFilterProviderDescriptor {
        private PaletteProviderConfiguration providerConfiguration;

        public ProviderDescriptor(IConfigurationElement element) {
            super(element);
            this.providerConfiguration = PaletteProviderConfiguration.parse(element);
            Assert.isNotNull((Object)((Object)this.providerConfiguration));
        }

        public boolean provides(IOperation operation) {
            if (!super.provides(operation)) {
                return false;
            }
            if (!this.policyInitialized) {
                this.policy = this.getPolicy();
                this.policyInitialized = true;
            }
            if (this.policy != null) {
                return this.policy.provides(operation);
            }
            if (operation instanceof ContributeToPaletteOperation) {
                ContributeToPaletteOperation o = (ContributeToPaletteOperation)operation;
                return this.providerConfiguration.supports(o.getEditor(), o.getContent());
            }
            return false;
        }

        public IProvider getProvider() {
            if (this.provider == null) {
                IProvider newProvider = super.getProvider();
                if (this.provider instanceof IPaletteProvider) {
                    IPaletteProvider defaultProvider = (IPaletteProvider)newProvider;
                    defaultProvider.setContributions(this.getElement());
                }
                return newProvider;
            }
            return super.getProvider();
        }
    }
}

