/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.common.core.internal.validation;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.modisco.infra.common.core.internal.CommonModiscoActivator;
import org.eclipse.modisco.infra.common.core.internal.Messages;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValidationJob
extends Job {
    public static final String EMF_PROBLEM_MARKER = "org.eclipse.emf.ecore.diagnostic";
    private static final long DELAY = 500L;
    private static ValidationJob instance;
    private final LinkedList<ValidationItem> queue = new LinkedList();

    private ValidationJob() {
        super(Messages.ValidationJob_validationJobName);
    }

    public static synchronized ValidationJob getInstance() {
        if (instance == null) {
            instance = new ValidationJob();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateAsync(Resource resource, IFile file, Callback callback) {
        LinkedList<ValidationItem> linkedList = this.queue;
        synchronized (linkedList) {
            ListIterator listIterator = this.queue.listIterator();
            while (listIterator.hasNext()) {
                ValidationItem item = (ValidationItem)listIterator.next();
                if (resource == null || !resource.equals(item.getResource())) continue;
                listIterator.remove();
            }
            this.queue.addLast(new ValidationItem(resource, file, callback));
        }
        this.cancel();
        this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        this.setPriority(50);
        this.schedule(500L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateSync(Resource resource, IFile file) {
        LinkedList<ValidationItem> linkedList = this.queue;
        synchronized (linkedList) {
            ListIterator listIterator = this.queue.listIterator();
            while (listIterator.hasNext()) {
                ValidationItem item = (ValidationItem)listIterator.next();
                if (resource == null || !resource.equals(item.getResource())) continue;
                listIterator.remove();
            }
        }
        return this.validateItem(new ValidationItem(resource, file, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        while (true) {
            ValidationItem validationItem;
            LinkedList<ValidationItem> linkedList = this.queue;
            synchronized (linkedList) {
                if (this.queue.isEmpty()) {
                    break;
                }
                validationItem = this.queue.removeFirst();
            }
            boolean result = this.validateItem(validationItem);
            Callback callback = validationItem.getCallback();
            if (callback == null) continue;
            callback.validated(result);
        }
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean validateItem(ValidationItem validationItem) {
        ArrayList contents;
        Resource resource;
        boolean result = true;
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        Resource resource2 = resource = validationItem.getResource();
        synchronized (resource2) {
            contents = new ArrayList(resource.getContents());
        }
        for (EObject eObject : contents) {
            Diagnostic diagnostic = Diagnostician.INSTANCE.validate(eObject);
            if (diagnostic.getSeverity() == 0) continue;
            diagnostics.add(diagnostic);
            result &= diagnostic.getSeverity() != 4;
        }
        if (validationItem.getFile() != null) {
            ValidationJob.printWSProblems(validationItem.getFile(), diagnostics);
        } else {
            ValidationJob.printPluginProblem(validationItem.getResource(), diagnostics);
        }
        return result;
    }

    private static void printPluginProblem(Resource resource, List<Diagnostic> diagnostics) {
        for (Diagnostic diagnostic : diagnostics) {
            ValidationJob.convertDiagnosticToLog(resource, diagnostic);
        }
    }

    private static void printWSProblems(final IResource file, final List<Diagnostic> diagnostics) {
        if (file == null) {
            throw new IllegalArgumentException("null file");
        }
        WorkspaceJob job = new WorkspaceJob(NLS.bind((String)Messages.ValidationJob_creatingValidationMarkersJobName, (Object)file.getFullPath())){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                if (file.exists()) {
                    try {
                        file.deleteMarkers(ValidationJob.EMF_PROBLEM_MARKER, true, 2);
                    }
                    catch (CoreException e) {
                        MoDiscoLogger.logError(e, "Failed to delete marker for: " + file.getFullPath(), CommonModiscoActivator.getDefault());
                    }
                    for (Diagnostic diagnostic : diagnostics) {
                        try {
                            ValidationJob.convertDiagnosticToMarker(file, diagnostic);
                        }
                        catch (CoreException e) {
                            MoDiscoLogger.logError(e, null);
                        }
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)file.getProject());
        job.schedule();
    }

    static void convertDiagnosticToLog(Resource resource, Diagnostic diagnostic) {
        if (diagnostic.getChildren().size() > 0) {
            for (Diagnostic subDiagnostic : diagnostic.getChildren()) {
                ValidationJob.convertDiagnosticToLog(resource, subDiagnostic);
            }
        } else {
            String diagnosticMessage = "The following problem has been found while validating " + resource.getURI().toString() + " : " + diagnostic.getMessage();
            if (diagnostic.getSeverity() == 4) {
                MoDiscoLogger.logError(diagnosticMessage, (Plugin)CommonModiscoActivator.getDefault());
            } else if (diagnostic.getSeverity() == 2) {
                MoDiscoLogger.logWarning(diagnosticMessage, (Plugin)CommonModiscoActivator.getDefault());
            } else if (diagnostic.getSeverity() == 1) {
                MoDiscoLogger.logInfo(diagnosticMessage, (Plugin)CommonModiscoActivator.getDefault());
            }
        }
    }

    static void convertDiagnosticToMarker(IResource file, Diagnostic diagnostic) throws CoreException {
        if (diagnostic.getChildren().size() > 0) {
            for (Diagnostic subDiagnostic : diagnostic.getChildren()) {
                ValidationJob.convertDiagnosticToMarker(file, subDiagnostic);
            }
        } else {
            Object object;
            IMarker marker = file.createMarker(EMF_PROBLEM_MARKER);
            marker.setAttribute("message", (Object)diagnostic.getMessage());
            if (diagnostic.getSeverity() == 4) {
                marker.setAttribute("severity", 2);
            } else if (diagnostic.getSeverity() == 2) {
                marker.setAttribute("severity", 1);
            } else if (diagnostic.getSeverity() == 1) {
                marker.setAttribute("severity", 0);
            }
            marker.setAttribute("location", (Object)diagnostic.getSource());
            List data = diagnostic.getData();
            if (data.size() > 0 && (object = data.get(0)) instanceof EObject) {
                EObject target = (EObject)object;
                marker.setAttribute("uri", (Object)EcoreUtil.getURI((EObject)target).toString());
            }
        }
    }

    public boolean belongsTo(Object family) {
        return family == ResourcesPlugin.FAMILY_MANUAL_BUILD || family == ResourcesPlugin.FAMILY_AUTO_BUILD || family == ResourcesPlugin.FAMILY_MANUAL_REFRESH;
    }

    public static interface Callback {
        public void validated(boolean var1);
    }

    private static class ValidationItem {
        private final Resource resource;
        private final IFile file;
        private final Callback callback;

        public ValidationItem(Resource resource, IFile file, Callback callback) {
            this.resource = resource;
            this.file = file;
            this.callback = callback;
        }

        public Resource getResource() {
            return this.resource;
        }

        public IResource getFile() {
            return this.file;
        }

        public Callback getCallback() {
            return this.callback;
        }

        public String toString() {
            if (this.file != null) {
                return this.file.toString();
            }
            return this.resource.toString();
        }
    }
}

