/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.core.internal.catalog;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.discovery.catalog.CatalogFactory;
import org.eclipse.modisco.infra.discovery.catalog.DiscovererCatalog;
import org.eclipse.modisco.infra.discovery.catalog.DiscovererDescription;
import org.eclipse.modisco.infra.discovery.core.IDiscoverer;
import org.eclipse.modisco.infra.discovery.core.internal.Activator;
import org.eclipse.modisco.infra.discovery.core.internal.catalog.DiscovererParameterUtils;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DiscovererRegistry {
    private Map<DiscovererDescription, IConfigurationElement> configurationElements;
    private final Map<DiscovererDescription, IDiscoverer<?>> discoverersCache = new HashMap();
    private DiscovererCatalog discovererCatalog;
    private ResourceSet resourceSet;
    private Resource resource;
    public static final String DISCOVERER_EXTENSION_POINT = "org.eclipse.modisco.infra.discovery.core.discoverer";
    private static final String CLASS_ATT = "class";
    private static final String ID_ATT = "id";
    public static final DiscovererRegistry INSTANCE = new DiscovererRegistry();

    private DiscovererRegistry() {
        this.initRegisteredDiscoverers();
    }

    public IDiscoverer<?> getCachedDiscoverer(DiscovererDescription discovererDescription) {
        return this.discoverersCache.get(discovererDescription);
    }

    public IDiscoverer<?> createDiscoverer(DiscovererDescription discovererDescription) {
        IConfigurationElement configurationElement = this.configurationElements.get(discovererDescription);
        if (configurationElement == null) {
            throw new IllegalArgumentException();
        }
        try {
            Object object = configurationElement.createExecutableExtension(CLASS_ATT);
            if (object instanceof IDiscoverer) {
                IDiscoverer discoverer = (IDiscoverer)object;
                return discoverer;
            }
            throw new IllegalStateException("Not an IDiscoverer.");
        }
        catch (CoreException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
            return null;
        }
    }

    public Collection<DiscovererDescription> getDiscovererDescriptions() {
        return Collections.unmodifiableCollection(this.discovererCatalog.getInstalledDiscoverers());
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    DiscovererCatalog getDiscovererCatalog() {
        return this.discovererCatalog;
    }

    private synchronized void initRegisteredDiscoverers() {
        this.resourceSet = new ResourceSetImpl();
        this.resource = this.resourceSet.createResource(DiscovererRegistry.getDiscoverersResourceURI());
        this.discovererCatalog = CatalogFactory.eINSTANCE.createDiscovererCatalog();
        this.resource.getContents().add((Object)this.discovererCatalog);
        this.configurationElements = new HashMap<DiscovererDescription, IConfigurationElement>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(DISCOVERER_EXTENSION_POINT);
        IExtension[] iExtensionArray = point.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            Bundle bundle = Platform.getBundle((String)extension.getContributor().getName());
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                String discovererClass = element.getAttribute(CLASS_ATT);
                if (discovererClass != null) {
                    try {
                        IDiscoverer discoverer = (IDiscoverer)element.createExecutableExtension(CLASS_ATT);
                        DiscovererDescription discoDesc = CatalogFactory.eINSTANCE.createDiscovererDescription();
                        this.configurationElements.put(discoDesc, element);
                        discoDesc.setImplementationType(discoverer.getClass());
                        discoDesc.setImplementationBundle(bundle);
                        String discovererId = element.getAttribute(ID_ATT);
                        if (discovererId == null) {
                            discoDesc.setId(discoverer.toString());
                        } else if (discovererId.indexOf(32) > 0 || discovererId.indexOf(35) > 0 || discovererId.indexOf(47) > 0) {
                            String alternateId = discovererId.replace(' ', '_');
                            alternateId = alternateId.replace('/', '_');
                            alternateId = alternateId.replace('#', '_');
                            MoDiscoLogger.logWarning((String)("A Discoverer ID contains invalid characters : '" + discovererId + "'. '" + alternateId + "' will be used instead."), (Plugin)Activator.getDefault());
                            discoDesc.setId(alternateId);
                        } else {
                            discoDesc.setId(discovererId);
                        }
                        DiscovererRegistry.computeSourceType(discoDesc);
                        DiscovererParameterUtils.getInstance().computeParameters(discoDesc);
                        this.discoverersCache.put(discoDesc, discoverer);
                        this.discovererCatalog.getInstalledEntries().add((Object)discoDesc);
                        this.discovererCatalog.eResource().getContents().add((Object)discoDesc);
                    }
                    catch (CoreException e) {
                        String message = "A problem occurred when instantiating discoverer configuration: " + element.getValue();
                        MoDiscoLogger.logWarning((Throwable)e, (String)message, (Plugin)Activator.getDefault());
                    }
                } else {
                    String message = "A problem occurred when retrieving discoverer configuration: " + element.getValue();
                    MoDiscoLogger.logWarning((String)message, (Plugin)Activator.getDefault());
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static URI getDiscoverersResourceURI() {
        URI uri = URI.createURI((String)("platform:/meta/" + Activator.getDefault().getBundle().getSymbolicName() + "/discoverersCatalog.xmi"));
        return uri;
    }

    private static void computeSourceType(DiscovererDescription discovererDescription) {
        Class<?> sourceType = null;
        try {
            Method[] methodArray = discovererDescription.getImplementationType().getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method aMethod = methodArray[n2];
                if (aMethod.getName().equals("isApplicableTo") && aMethod.getParameterTypes().length == 1) {
                    Class<?> parameterClass = aMethod.getParameterTypes()[0];
                    if (sourceType == null || parameterClass != Object.class) {
                        sourceType = parameterClass;
                    }
                }
                ++n2;
            }
        }
        catch (IllegalArgumentException e) {
            MoDiscoLogger.logWarning((Throwable)e, (Plugin)Activator.getDefault());
        }
        discovererDescription.setSourceType(sourceType);
    }
}

