/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.filter;

import java.util.Iterator;
import prefuse.Visualization;
import prefuse.action.GroupAction;
import prefuse.data.Graph;
import prefuse.data.Tree;
import prefuse.data.expression.Predicate;
import prefuse.util.PrefuseLib;
import prefuse.visual.EdgeItem;
import prefuse.visual.NodeItem;
import prefuse.visual.VisualItem;
import prefuse.visual.expression.InGroupPredicate;

public class FisheyeTreeFilter
extends GroupAction {
    private String m_sources;
    private Predicate m_groupP;
    private int m_threshold;
    private NodeItem m_root;
    private double m_divisor;

    public FisheyeTreeFilter(String group) {
        this(group, 1);
    }

    public FisheyeTreeFilter(String group, int distance) {
        this(group, Visualization.FOCUS_ITEMS, distance);
    }

    public FisheyeTreeFilter(String group, String sources, int distance) {
        super(group);
        this.m_sources = sources;
        this.m_threshold = -distance;
        this.m_groupP = new InGroupPredicate(PrefuseLib.getGroupName(group, Graph.NODES));
    }

    public int getDistance() {
        return -this.m_threshold;
    }

    public void setDistance(int distance) {
        this.m_threshold = -distance;
    }

    public String getSources() {
        return this.m_sources;
    }

    public void setSources(String sources) {
        this.m_sources = sources;
    }

    public void run(double frac) {
        Tree tree = ((Graph)this.m_vis.getGroup(this.m_group)).getSpanningTree();
        this.m_divisor = tree.getNodeCount();
        this.m_root = (NodeItem)tree.getRoot();
        Iterator items = this.m_vis.visibleItems(this.m_group);
        while (items.hasNext()) {
            VisualItem item = (VisualItem)items.next();
            item.setDOI(-1.7976931348623157E308);
            item.setExpanded(false);
        }
        Iterator iter = this.m_vis.items(this.m_sources, this.m_groupP);
        while (iter.hasNext()) {
            this.visitFocus((NodeItem)iter.next(), null);
        }
        this.visitFocus(this.m_root, null);
        items = this.m_vis.visibleItems(this.m_group);
        while (items.hasNext()) {
            VisualItem item = (VisualItem)items.next();
            if (item.getDOI() != -1.7976931348623157E308) continue;
            PrefuseLib.updateVisible(item, false);
        }
    }

    private void visitFocus(NodeItem n, NodeItem c) {
        if (n.getDOI() <= -1.0) {
            this.visit(n, c, 0, 0);
            if (this.m_threshold < 0) {
                this.visitDescendants(n, c);
            }
            this.visitAncestors(n);
        }
    }

    private void visit(NodeItem n, NodeItem c, int doi, int ldist) {
        PrefuseLib.updateVisible(n, true);
        double localDOI = (double)(-ldist) / Math.min(1000.0, this.m_divisor);
        n.setDOI((double)doi + localDOI);
        if (c != null) {
            EdgeItem e = (EdgeItem)c.getParentEdge();
            e.setDOI(c.getDOI());
            PrefuseLib.updateVisible(e, true);
        }
    }

    private void visitAncestors(NodeItem n) {
        if (n == this.m_root) {
            return;
        }
        this.visitFocus((NodeItem)n.getParent(), n);
    }

    private void visitDescendants(NodeItem p, NodeItem skip) {
        int lidx = skip == null ? 0 : p.getChildIndex(skip);
        Iterator children = p.children();
        p.setExpanded(children.hasNext());
        int i = 0;
        while (children.hasNext()) {
            NodeItem c = (NodeItem)children.next();
            if (c != skip) {
                int doi = (int)(p.getDOI() - 1.0);
                this.visit(c, c, doi, Math.abs(lidx - i));
                if (doi > this.m_threshold) {
                    this.visitDescendants(c, null);
                }
            }
            ++i;
        }
    }
}

