/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.xtext;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.xtext.tests.TestCaseAppender;
import org.eclipse.ocl.examples.xtext.tests.XtextTestCase;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.internal.values.BagImpl;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.pivot.values.Bag;
import org.eclipse.ocl.xtext.essentialocl.utilities.EssentialOCLCSResource;

public class ErrorTests
extends XtextTestCase {
    protected @NonNull OCLInternal createOCL() {
        return OCLInternal.newInstance((ProjectManager)OCL.NO_PROJECTS, null);
    }

    public void test_BadIterate() throws IOException {
        OCLInternal ocl = this.createOCL();
        String metamodelText = "package test : tst = 'http://test'\n{\n\tclass Test\n\t{\n\t\tinvariant set: Set{1, 2, 3}->size() = 3;\n\t\tinvariant loop: Test.allInstances()->iterate(w, h; acc : String = '' | true);\n\t}\n}\n";
        URIConverter.ReadableInputStream inputStream = new URIConverter.ReadableInputStream(metamodelText, "UTF-8");
        URI xtextURI = URI.createURI((String)"test.oclinecore");
        ResourceSet resourceSet = ocl.getResourceSet();
        EssentialOCLCSResource xtextResource = (EssentialOCLCSResource)ClassUtil.nonNullState((Object)((EssentialOCLCSResource)resourceSet.createResource(xtextURI, null)));
        ocl.getEnvironmentFactory().adapt((Notifier)xtextResource);
        xtextResource.load((InputStream)inputStream, null);
        ErrorTests.assertResourceErrors("Loading Xtext", (Resource)xtextResource, StringUtil.bind((String)PivotMessagesInternal.UnresolvedIterationCall_ERROR_, (Object[])new Object[]{"Set(test::Test)", "iterate", "w, h; acc : String = ''| true"}));
        ocl.dispose();
    }

    public void test_BadProperty() throws IOException {
        OCLInternal ocl = this.createOCL();
        String metamodelText = "package test : tst = 'http://test'\n{\n\tclass Test\n\t{\n\t\tinvariant loop: Test.allInstances->iterate(w, h; acc : String = '' | true);\n\t}\n}\n";
        URIConverter.ReadableInputStream inputStream = new URIConverter.ReadableInputStream(metamodelText, "UTF-8");
        URI xtextURI = URI.createURI((String)"test.oclinecore");
        ResourceSet resourceSet = ocl.getResourceSet();
        EssentialOCLCSResource xtextResource = (EssentialOCLCSResource)ClassUtil.nonNullState((Object)((EssentialOCLCSResource)resourceSet.createResource(xtextURI, null)));
        ocl.getEnvironmentFactory().adapt((Notifier)xtextResource);
        xtextResource.load((InputStream)inputStream, null);
        ErrorTests.assertResourceErrors("Loading Xtext", (Resource)xtextResource, StringUtil.bind((String)PivotMessagesInternal.UnresolvedStaticProperty_ERROR_, (Object[])new Object[]{"test::Test", "allInstances"}));
        ocl.dispose();
    }

    public void testBadEOF_419683() throws Exception {
        OCLInternal ocl = this.createOCL();
        TestCaseAppender.INSTANCE.uninstall();
        String testFile = "import 'platform:/plugin/org.eclipse.emf.ecore/model/Ecore.ecore'\npackage ecore\ncontext EPackage\ninv test:\n\tlet classifiers:Set(EClassifier) = self.eClassifiers in let filtered";
        BagImpl bag = new BagImpl();
        bag.add((Object)"mismatched input 'inv' expecting '('");
        bag.add((Object)"mismatched input '<EOF>' expecting 'endpackage'");
        this.doBadLoadFromString(ocl, "string.ocl", testFile, (Bag<String>)bag);
        ocl.dispose();
    }
}

