/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.eventmanager.framework;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.ocl.examples.eventmanager.EventManager;

public class EventAdapter
extends EContentAdapter {
    private final WeakReference<EventManager> eventManager;
    private final Map<Notifier, Integer> alreadyRegisteredOn;

    public EventAdapter(EventManager eventManager) {
        this.eventManager = new WeakReference<EventManager>(eventManager);
        this.alreadyRegisteredOn = new WeakHashMap<Notifier, Integer>();
    }

    protected void addAdapter(Notifier notifier) {
        if (!notifier.eAdapters().contains((Object)this)) {
            notifier.eAdapters().add((Object)this);
            this.alreadyRegisteredOn.put(notifier, 1);
        } else {
            this.alreadyRegisteredOn.put(notifier, this.alreadyRegisteredOn.get(notifier) + 1);
        }
    }

    protected void removeAdapter(Notifier notifier) {
        Integer count = this.alreadyRegisteredOn.get(notifier);
        if (count != null) {
            if (count > 1) {
                this.alreadyRegisteredOn.put(notifier, count - 1);
            } else {
                this.alreadyRegisteredOn.remove(notifier);
                super.removeAdapter(notifier);
            }
        }
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        EventManager m = (EventManager)this.eventManager.get();
        if (m != null) {
            m.handleEMFEvent(notification);
        }
    }
}

