/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.types.generator.ui.internal.wizards;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import org.eclipse.papyrus.uml.profile.types.generator.ui.internal.wizards.GeneratorWizardModel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.xtext.xbase.lib.StringExtensions;

class GeneratorParametersBlock {
    private static final String IDENTIFIER_PREFIX = "identifierPrefix";
    private final GeneratorWizardModel model;
    private Text idText;

    public GeneratorParametersBlock(GeneratorWizardModel model) {
        this.model = model;
    }

    public void createControl(Composite parent) {
        new Label(parent, 0).setText("Identifier:");
        this.idText = new Text(parent, 2052);
        this.idText.setLayoutData((Object)new GridData(768));
        this.idText.setText(this.getDefaultIdentifier());
        this.model.setIdentifier(this.getIdentifier());
        this.idText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneratorParametersBlock.this.model.setIdentifier(GeneratorParametersBlock.this.getIdentifier());
                GeneratorParametersBlock.this.model.validatePage();
            }
        });
    }

    private String getIdentifier() {
        return this.idText.getText().trim();
    }

    void save() {
        String suffix;
        String identifier = this.getIdentifier();
        if (!this.getDefaultIdentifier().equals(identifier) && identifier.endsWith(suffix = "." + this.getDefaultQualifier())) {
            this.model.getDialogSettings().put(IDENTIFIER_PREFIX, identifier.substring(0, identifier.length() - suffix.length()));
        }
    }

    private String getDefaultIdentifier() {
        return String.format("%s.%s", this.getDefaultIdentifierPrefix(), this.getDefaultQualifier());
    }

    private String getDefaultQualifier() {
        return Joiner.on((char)'.').join(Iterables.transform((Iterable)Splitter.on((String)"::").split((CharSequence)this.model.getProfile().getQualifiedName()), (Function)new Function<String, String>(){

            public String apply(String input) {
                return StringExtensions.toFirstLower((String)UML2Util.getValidJavaIdentifier((String)input));
            }
        }));
    }

    private String getDefaultIdentifierPrefix() {
        String basePackage;
        String result = this.model.getDialogSettings().get(IDENTIFIER_PREFIX);
        Profile profile = this.model.getProfile();
        Stereotype ePackage = profile.getApplicableStereotype(String.format("%s::%s", "Ecore", "EPackage"));
        if (ePackage != null && profile.isStereotypeApplied(ePackage) && !Strings.isNullOrEmpty((String)(basePackage = (String)profile.getValue(ePackage, "basePackage")))) {
            result = basePackage;
        }
        if (result == null) {
            result = "com.example";
        }
        return result;
    }
}

