/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.component.services;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.AbstractDiagramServices;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.EditableChecker;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.RepresentationQuerier;
import org.eclipse.papyrus.sirius.uml.diagram.common.services.CommonDiagramServices;
import org.eclipse.papyrus.sirius.uml.diagram.common.services.DomainBasedEdgeServices;
import org.eclipse.papyrus.sirius.uml.diagram.common.services.UMLLabelServices;
import org.eclipse.papyrus.uml.domain.services.IEditableChecker;
import org.eclipse.papyrus.uml.domain.services.IViewQuerier;
import org.eclipse.papyrus.uml.domain.services.UMLHelper;
import org.eclipse.papyrus.uml.domain.services.create.ElementDomainBasedEdgeCreationChecker;
import org.eclipse.papyrus.uml.domain.services.edges.IDomainBasedEdgeContainerProvider;
import org.eclipse.papyrus.uml.domain.services.edges.diagrams.ComponentDomainBasedEdgeContainerProvider;
import org.eclipse.papyrus.uml.domain.services.status.CheckStatus;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public class ComponentDiagramServices
extends AbstractDiagramServices {
    private static final String CONNECTOR = "uml::Connector";
    private static final String OWNED_ATTRIBUTE = "ownedAttribute";
    private static final String OWNED_CONNECTOR = "ownedConnector";

    public Collection<Component> getComponentCandidates(Element parent) {
        Collection<Object> result = Collections.emptyList();
        if (parent instanceof Package) {
            result = ((Package)parent).getPackagedElements().stream().filter(Component.class::isInstance).map(Component.class::cast).collect(Collectors.toList());
        } else if (parent instanceof Component) {
            result = ((Component)parent).getPackagedElements().stream().filter(Component.class::isInstance).map(Component.class::cast).collect(Collectors.toList());
        }
        return result;
    }

    public Collection<Port> getPortCandidates(Element parent) {
        Type parentType;
        List<Object> result = parent instanceof Classifier ? ((Classifier)parent).getAllAttributes().stream().filter(Port.class::isInstance).map(Port.class::cast).toList() : (parent instanceof TypedElement ? ((parentType = ((TypedElement)parent).getType()) instanceof Classifier ? ((Classifier)parentType).getAllAttributes().stream().filter(Port.class::isInstance).map(Port.class::cast).toList() : Collections.emptyList()) : Collections.emptyList());
        return result;
    }

    public boolean canCreateComponentCPD(Element parent) {
        boolean canCreate = false;
        if (parent instanceof Package) {
            canCreate = super.canCreate((EObject)parent, UMLPackage.eINSTANCE.getComponent(), (EStructuralFeature)UMLPackage.eINSTANCE.getPackage_PackagedElement());
        } else if (parent instanceof Component) {
            canCreate = super.canCreate((EObject)parent, UMLPackage.eINSTANCE.getComponent(), (EStructuralFeature)UMLPackage.eINSTANCE.getComponent_PackagedElement());
        }
        return canCreate;
    }

    public boolean canCreateConnectorCPD(EObject source, EObject target, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        boolean canCreate = true;
        RepresentationQuerier representationQuery = new RepresentationQuerier((Object)((DDiagramElement)sourceView).getParentDiagram());
        CheckStatus canCreateStatus = new ElementDomainBasedEdgeCreationChecker().canCreate(source, target, CONNECTOR, OWNED_CONNECTOR, (IViewQuerier)representationQuery, (Object)sourceView, (Object)targetView);
        canCreate = canCreateStatus.isValid();
        if (canCreate) {
            ComponentDomainBasedEdgeContainerProvider containerProvider = ComponentDomainBasedEdgeContainerProvider.buildDefault((IEditableChecker)new EditableChecker());
            EClass eClass = UMLHelper.toEClass((String)CONNECTOR);
            if (eClass != null) {
                EObject newInstance = UMLFactory.eINSTANCE.create(eClass);
                EObject container = containerProvider.getContainer(source, target, newInstance, (IViewQuerier)representationQuery, (Object)sourceView, (Object)targetView);
                canCreate = container != null;
            }
        }
        return canCreate;
    }

    public EObject createConnectorCPD(EObject source, EObject target, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        DomainBasedEdgeServices domainBasedEdgeServices = new DomainBasedEdgeServices();
        return domainBasedEdgeServices.createDomainBasedEdge(source, target, CONNECTOR, OWNED_CONNECTOR, sourceView, targetView, (IDomainBasedEdgeContainerProvider)ComponentDomainBasedEdgeContainerProvider.buildDefault((IEditableChecker)new EditableChecker()));
    }

    public EObject createComponentCPD(Element parent, DSemanticDecorator targetView) {
        EObject component = null;
        CommonDiagramServices commonDiagramServices = new CommonDiagramServices();
        if (parent instanceof Package) {
            component = commonDiagramServices.createElement(parent, UMLPackage.eINSTANCE.getComponent().getName(), UMLPackage.eINSTANCE.getPackage_PackagedElement().getName(), targetView);
        } else if (parent instanceof Component) {
            component = commonDiagramServices.createElement(parent, UMLPackage.eINSTANCE.getComponent().getName(), UMLPackage.eINSTANCE.getComponent_PackagedElement().getName(), targetView);
        }
        return component;
    }

    public String renderLabelCPD(Element element, DDiagram diagram, DSemanticDecorator view) {
        UMLLabelServices umlLabelServices = new UMLLabelServices();
        String label = view.eContainer() instanceof DNodeList ? umlLabelServices.renderLabelInline((EObject)element, diagram) : umlLabelServices.renderLabel((EObject)element, diagram);
        return label;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canCreatePropertyCPD(EObject parent, DSemanticDecorator parentView) {
        boolean canCreate = false;
        if (parent instanceof Property) {
            Property property = (Property)parent;
            if (!(parent instanceof Port)) {
                if (property.getType() == null) return false;
                if (!(property.getType() instanceof Classifier)) return false;
                return true;
            }
        }
        if (!(parent instanceof Interface)) return parent instanceof StructuredClassifier;
        if (!(parentView instanceof DNodeList)) return canCreate;
        DNodeList dNodeList = (DNodeList)parentView;
        return dNodeList.getActualMapping().getSubNodeMappings().stream().map(AbstractNodeMapping::getDomainClass).map(UMLHelper::toEClass).anyMatch(eClass -> eClass.equals(UMLPackage.eINSTANCE.getProperty()));
    }

    public EObject createPropertyCPD(EObject parent, DSemanticDecorator parentView) {
        CommonDiagramServices commonDiagramServices = new CommonDiagramServices();
        EObject result = null;
        if (parent instanceof Property) {
            Property property = (Property)parent;
            result = commonDiagramServices.createElement((Element)property.getType(), UMLPackage.eINSTANCE.getProperty().getName(), OWNED_ATTRIBUTE, parentView);
        } else if (parent instanceof Element) {
            result = commonDiagramServices.createElement((Element)parent, UMLPackage.eINSTANCE.getProperty().getName(), OWNED_ATTRIBUTE, parentView);
        }
        return result;
    }
}

