/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.editor.internal.runnables;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.architecture.ArchitectureDescriptionUtils;
import org.eclipse.papyrus.infra.core.architecture.RepresentationKind;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureViewpoint;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.sirius.editor.representation.SiriusDiagramPrototype;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelection;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelectionCallback;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class UpdateSiriusViewpointRunnable
implements Runnable {
    protected final Session session;
    protected final ModelSet modelSet;

    public UpdateSiriusViewpointRunnable(Session session, ModelSet modelSet) {
        this.session = session;
        this.modelSet = modelSet;
    }

    @Override
    public void run() {
        Collection<Viewpoint> toApply = this.collectSiriusViewpointInPapyrusArchitecture();
        Collection currentAppliedViewpoints = this.session.getSelectedViewpoints(false);
        ArrayList toUnapply = new ArrayList(currentAppliedViewpoints);
        ViewpointSelectionCallback callBack = new ViewpointSelectionCallback();
        for (Viewpoint vp : toApply) {
            Viewpoint matchingSelectedViewpoint = this.getMatchingSelectedViewpoint(currentAppliedViewpoints, vp);
            if (matchingSelectedViewpoint == null) {
                callBack.selectViewpoint(vp, this.session, (IProgressMonitor)new NullProgressMonitor());
                continue;
            }
            toUnapply.remove(matchingSelectedViewpoint);
        }
        for (Viewpoint previouslySelected : toUnapply) {
            callBack.deselectViewpoint(previouslySelected, this.session, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private Viewpoint getMatchingSelectedViewpoint(Collection<Viewpoint> currentAppliedViewpoints, Viewpoint vp) {
        for (Viewpoint cvp : currentAppliedViewpoints) {
            if (cvp.getName() == null || !cvp.getName().equals(vp.getName())) continue;
            return cvp;
        }
        return null;
    }

    private final Collection<Viewpoint> collectSiriusViewpointInPapyrusArchitecture() {
        if (this.session == null || this.session.getSemanticResources().size() <= 0) {
            return Collections.emptyList();
        }
        String fileExtension = ((Resource)this.session.getSemanticResources().iterator().next()).getURI().fileExtension();
        Set availableViewpoints = ViewpointSelection.getViewpoints((String)fileExtension);
        ArchitectureDescriptionUtils utils = new ArchitectureDescriptionUtils(this.modelSet);
        Collection vp = utils.getArchitectureContext().getViewpoints();
        HashSet<Viewpoint> siriusViewpoints = new HashSet<Viewpoint>();
        for (MergedArchitectureViewpoint tmp : vp) {
            for (RepresentationKind current : tmp.getRepresentationKinds()) {
                DiagramDescription desc;
                EObject currentV;
                if (!(current instanceof SiriusDiagramPrototype) || !((currentV = (desc = ((SiriusDiagramPrototype)current).getDiagramDescription()).eContainer()) instanceof Viewpoint)) continue;
                Viewpoint appliedViewpoint = availableViewpoints.stream().filter(v -> v.getName().equals(((Viewpoint)currentV).getName())).findFirst().orElse((Viewpoint)currentV);
                siriusViewpoints.add(appliedViewpoint);
            }
        }
        return siriusViewpoints;
    }
}

