/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.validate.expressions;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.papyrus.gmf.internal.validate.DebugOptions;
import org.eclipse.papyrus.gmf.internal.validate.GMFValidationPlugin;
import org.eclipse.papyrus.gmf.internal.validate.LabelProvider;
import org.eclipse.papyrus.gmf.internal.validate.Messages;
import org.eclipse.papyrus.gmf.internal.validate.StatusCodes;
import org.eclipse.papyrus.gmf.internal.validate.Trace;
import org.eclipse.papyrus.gmf.internal.validate.expressions.IEvaluationEnvironment;
import org.eclipse.papyrus.gmf.internal.validate.expressions.IModelExpression;
import org.eclipse.papyrus.gmf.internal.validate.expressions.IParseEnvironment;

public abstract class AbstractExpression
implements IModelExpression {
    private IStatus status;
    private String body;
    private EClassifier contextClassifier;
    private Map<String, EClassifier> extEnv;

    protected AbstractExpression(String body, EClassifier context, IParseEnvironment extendedEnv) {
        if (body == null || context == null) {
            throw new IllegalArgumentException("null body or context-class");
        }
        this.body = body;
        this.contextClassifier = context;
        this.status = Status.OK_STATUS;
        if (extendedEnv != null) {
            this.extEnv = new HashMap<String, EClassifier>(5);
            for (String nextVar : extendedEnv.getVariableNames()) {
                this.extEnv.put(nextVar, extendedEnv.getTypeOf(nextVar));
            }
        } else {
            this.extEnv = Collections.emptyMap();
        }
    }

    protected Map<String, EClassifier> getExtEnvironment() {
        return this.extEnv;
    }

    @Override
    public boolean isLooselyTyped() {
        return true;
    }

    protected void setStatus(IStatus status) {
        this.status = status;
    }

    protected abstract Object doEvaluate(Object var1);

    protected abstract Object doEvaluate(Object var1, IEvaluationEnvironment var2);

    @Override
    public EClassifier getResultType() {
        return EcorePackage.eINSTANCE.getEJavaObject();
    }

    @Override
    public abstract boolean isAssignableTo(EClassifier var1);

    @Override
    public abstract boolean isAssignableToElement(ETypedElement var1);

    @Override
    public abstract String getLanguage();

    @Override
    public final Object evaluate(Object context) {
        return this.evaluate(context, null);
    }

    @Override
    public final Object evaluate(Object contextInstance, IEvaluationEnvironment extendedEnv) {
        if (contextInstance == null || !this.hasCompatibleContext(contextInstance)) {
            throw new IllegalArgumentException("Invalid evaluation context:" + String.valueOf(contextInstance));
        }
        if (this.getStatus().isOK()) {
            try {
                if (extendedEnv != null) {
                    return this.doEvaluate(contextInstance, extendedEnv);
                }
                return this.doEvaluate(contextInstance);
            }
            catch (RuntimeException e) {
                IStatus status = GMFValidationPlugin.createStatus(4, StatusCodes.UNEXPECTED_EVALUATION_ERROR, Messages.unexpectedExprEvalError, e);
                GMFValidationPlugin.log(status);
                Trace.catching(DebugOptions.EXCEPTIONS_CATCHING, e);
            }
        }
        return null;
    }

    @Override
    public IStatus getStatus() {
        return this.status;
    }

    @Override
    public String getBody() {
        return this.body;
    }

    @Override
    public EClassifier getContext() {
        return this.contextClassifier;
    }

    public String toString() {
        return this.body + " in context:[" + LabelProvider.INSTANCE.getObjectLabel((EObject)this.contextClassifier) + "] ";
    }

    private boolean hasCompatibleContext(Object ctxInstance) {
        if (this.contextClassifier instanceof EClass) {
            EClass contextClass = (EClass)this.contextClassifier;
            return ctxInstance instanceof EObject ? contextClass.isSuperTypeOf(((EObject)ctxInstance).eClass()) : false;
        }
        return this.contextClassifier.isInstance(ctxInstance);
    }
}

