/**
 * Copyright (c) 2007, 2015 Borland Software Corporation, Christian W. Damus, and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Dmitry Stadnik (Borland) - initial API and implementation
 * Thibault Landre (Atos Origin) - add Papyrus dependencies to Papyrus GMF diagram
 * Vincent Lorenzo (CEA-LIST) vincent.lorenzo@cea.fr : add the dependencyorg.eclipse.papyrus.infra.services.edit
 * Christian W. Damus - bug 477384
 */
package aspects.xpt.plugin;

import com.google.common.base.Objects;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gmf.codegen.gmfgen.GenApplication;
import org.eclipse.gmf.codegen.gmfgen.GenNavigator;
import org.eclipse.gmf.codegen.gmfgen.GenPlugin;
import org.eclipse.gmf.codegen.gmfgen.GenPropertySheet;
import org.eclipse.papyrus.papyrusgmfgenextension.EditPartUsingDeleteService;
import org.eclipse.papyrus.papyrusgmfgenextension.EditPartUsingReorientService;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import xpt.Common;

@Singleton
@SuppressWarnings("all")
public class manifest extends xpt.plugin.manifest {
  @Inject
  @Extension
  private Common _common;
  
  @Override
  public CharSequence requireBundle(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("Require-Bundle: org.eclipse.core.runtime,");
    _builder.newLine();
    {
      GenApplication _application = it.getEditorGen().getApplication();
      boolean _equals = Objects.equal(_application, null);
      if (_equals) {
        _builder.append(" org.eclipse.core.resources,");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      if ((it.getEditorGen().getDiagram().generateShortcutIcon() || ((!Objects.equal(it.getEditorGen().getNavigator(), null)) && it.getEditorGen().getNavigator().isGenerateDomainModelNavigator()))) {
        _builder.append(" org.eclipse.core.expressions,");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append(" org.eclipse.jface,");
    _builder.newLineIfNotEmpty();
    {
      GenApplication _application_1 = it.getEditorGen().getApplication();
      boolean _equals_1 = Objects.equal(_application_1, null);
      if (_equals_1) {
        _builder.append(" org.eclipse.ui.ide,");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append(" org.eclipse.ui.views,");
    _builder.newLineIfNotEmpty();
    {
      GenNavigator _navigator = it.getEditorGen().getNavigator();
      boolean _notEquals = (!Objects.equal(_navigator, null));
      if (_notEquals) {
        _builder.append(" org.eclipse.ui.navigator,");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("org.eclipse.ui.navigator.resources,");
        _builder.newLine();
      }
    }
    _builder.append(" org.eclipse.emf.ecore,");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("org.eclipse.emf.ecore.xmi,");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("org.eclipse.emf.edit.ui,");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("org.eclipse.gmf.runtime.emf.core,");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("org.eclipse.gmf.runtime.emf.commands.core,");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("org.eclipse.gmf.runtime.emf.ui.properties,");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("org.eclipse.gmf.runtime.diagram.ui,");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("org.eclipse.papyrus.uml.diagram.common,");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("org.eclipse.papyrus.infra.gmfdiag.common,");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("org.eclipse.papyrus.uml.service.types,");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("org.eclipse.papyrus.infra.widgets,");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("org.eclipse.papyrus.infra.ui,");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("org.eclipse.papyrus.infra.core.sashwindows.di,");
    _builder.newLine();
    {
      boolean _isPrintingEnabled = it.isPrintingEnabled();
      if (_isPrintingEnabled) {
        _builder.append(" org.eclipse.gmf.runtime.diagram.ui.printing,");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("org.eclipse.gmf.runtime.diagram.ui.printing.render,");
        _builder.newLine();
      }
    }
    {
      GenPropertySheet _propertySheet = it.getEditorGen().getPropertySheet();
      boolean _notEquals_1 = (!Objects.equal(_propertySheet, null));
      if (_notEquals_1) {
        _builder.append(" org.eclipse.gmf.runtime.diagram.ui.properties,");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append(" org.eclipse.gmf.runtime.diagram.ui.providers,");
    _builder.newLineIfNotEmpty();
    {
      GenApplication _application_2 = it.getEditorGen().getApplication();
      boolean _equals_2 = Objects.equal(_application_2, null);
      if (_equals_2) {
        _builder.append(" org.eclipse.gmf.runtime.diagram.ui.providers.ide,");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append(" org.eclipse.gmf.runtime.diagram.ui.render,");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("org.eclipse.gmf.runtime.diagram.ui.resources.editor,");
    _builder.newLine();
    {
      GenApplication _application_3 = it.getEditorGen().getApplication();
      boolean _equals_3 = Objects.equal(_application_3, null);
      if (_equals_3) {
        _builder.append(" org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide,");
        _builder.newLineIfNotEmpty();
      }
    }
    EList<String> reqPlugins = it.getAllRequiredPlugins();
    _builder.newLineIfNotEmpty();
    {
      boolean _contains = reqPlugins.contains("org.eclipse.papyrus.infra.gmfdiag.tooling.runtime");
      boolean _not = (!_contains);
      if (_not) {
        boolean notUsetBooleanVar = reqPlugins.add("org.eclipse.papyrus.infra.gmfdiag.tooling.runtime");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      for(final String reqId : reqPlugins) {
        _builder.append(" ");
        _builder.append(reqId);
        _builder.append(";visibility:=reexport,");
        CharSequence _extraLineBreak = this._common.extraLineBreak();
        _builder.append(_extraLineBreak);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append(" org.eclipse.gef,");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("org.eclipse.papyrus.infra.gmfdiag.preferences,");
    _builder.newLine();
    {
      if (((IteratorExtensions.size(Iterators.<EditPartUsingDeleteService>filter(it.eResource().getAllContents(), EditPartUsingDeleteService.class)) != 0) || (IteratorExtensions.size(Iterators.<EditPartUsingReorientService>filter(it.eResource().getAllContents(), EditPartUsingReorientService.class)) != 0))) {
        _builder.append(" ");
        _builder.append("org.eclipse.papyrus.infra.gmfdiag.extensionpoints.editors,");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("org.eclipse.papyrus.infra.services.edit");
        _builder.newLine();
      } else {
        _builder.append(" ");
        _builder.append("org.eclipse.papyrus.extensionpoints.editors");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  @Override
  public CharSequence executionEnvironment(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("Bundle-RequiredExecutionEnvironment: JavaSE-1.8");
    _builder.newLine();
    return _builder;
  }
}
