/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.cwt.svg;

import org.eclipse.nebula.cwt.svg.SvgElement;
import org.eclipse.nebula.cwt.svg.SvgGradient;
import org.eclipse.nebula.cwt.svg.SvgGraphic;
import org.eclipse.nebula.cwt.svg.SvgShape;
import org.eclipse.swt.graphics.GC;

abstract class SvgPaint {
    SvgGraphic parent;
    GC gc;
    SvgGradient paintServer;
    PaintType type = null;
    String linkId = null;
    Integer color = null;
    Float opacity = null;

    SvgPaint(SvgGraphic parent) {
        this.parent = parent;
    }

    abstract void apply();

    public void create(GC gc) {
        if (this.parent instanceof SvgShape) {
            SvgElement def;
            this.gc = gc;
            if (this.linkId != null && (def = this.parent.getElement(this.linkId)) instanceof SvgGradient) {
                SvgGradient gradient = (SvgGradient)def;
                SvgShape shape = (SvgShape)this.parent;
                this.paintServer = gradient;
                this.paintServer.create(shape, gc);
            }
        } else {
            throw new UnsupportedOperationException("only shapes can be painted...");
        }
    }

    public boolean dispose() {
        if (this.paintServer != null) {
            this.paintServer.dispose();
            return true;
        }
        return false;
    }

    public boolean isPaintable() {
        return this.type != PaintType.None;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PaintType {
        None,
        Current,
        Color,
        Link;

    }
}

