/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.emf.providers;

import com.google.common.collect.MapMaker;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.papyrus.infra.ui.emf.providers.EMFLabelProvider;
import org.eclipse.papyrus.infra.ui.emf.providers.ForwardingEMFLabelProvider;

public class DependentEMFLabelProvider
extends EMFLabelProvider {
    private SubscriptionListener subscriptionListener;
    private final CopyOnWriteArrayList<ILabelProviderListener> listeners = new CopyOnWriteArrayList();

    public DependentEMFLabelProvider() {
        super((ILabelProvider)new ForwardingEMFLabelProvider());
    }

    @Override
    public void dispose() {
        if (this.subscriptionListener != null) {
            this.subscriptionListener.dispose();
        }
        super.dispose();
    }

    protected void subscribe(EObject object, EObject dependent) {
        if (this.baseEMFLabelProvider instanceof ForwardingEMFLabelProvider) {
            SubscriptionListener subs = this.getSubscriptionListener();
            subs.add(object, dependent);
        }
    }

    protected void unsubscribe(EObject object, EObject dependent) {
        if (this.subscriptionListener != null) {
            this.subscriptionListener.remove(object, dependent);
        }
    }

    private SubscriptionListener getSubscriptionListener() {
        if (this.subscriptionListener == null) {
            this.subscriptionListener = new SubscriptionListener();
            ((ForwardingEMFLabelProvider)this.baseEMFLabelProvider).addListener(this.subscriptionListener);
        }
        return this.subscriptionListener;
    }

    @Override
    public void addListener(ILabelProviderListener listener) {
        super.addListener(listener);
        this.listeners.addIfAbsent(listener);
    }

    @Override
    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove(listener);
        super.removeListener(listener);
    }

    protected void fireLabelProviderChange(Object object) {
        if (!this.listeners.isEmpty()) {
            LabelProviderChangedEvent event = new LabelProviderChangedEvent((IBaseLabelProvider)this, object);
            this.listeners.forEach(l -> l.labelProviderChanged(event));
        }
    }

    private class SubscriptionListener
    implements ILabelProviderListener {
        private final Map<EObject, Set<EObject>> subscriptions = new MapMaker().weakKeys().makeMap();

        private SubscriptionListener() {
        }

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            Set<EObject> dependents = this.subscriptions.get(event.getElement());
            if (dependents != null) {
                dependents.forEach(DependentEMFLabelProvider.this::fireLabelProviderChange);
            }
        }

        void add(EObject subscription, EObject dependent) {
            this.subscriptions.computeIfAbsent(subscription, x -> Sets.newSetFromMap(new WeakHashMap())).add(dependent);
        }

        void remove(EObject subscription, EObject dependent) {
            Set<EObject> dependents = this.subscriptions.get(subscription);
            if (dependents != null) {
                dependents.remove(dependent);
                if (dependents.isEmpty()) {
                    this.subscriptions.remove(subscription);
                }
                if (this.subscriptions.isEmpty()) {
                    this.dispose();
                }
            }
        }

        void dispose() {
            if (DependentEMFLabelProvider.this.baseEMFLabelProvider instanceof ForwardingEMFLabelProvider) {
                ((ForwardingEMFLabelProvider)DependentEMFLabelProvider.this.baseEMFLabelProvider).removeListener(this);
            }
            this.subscriptions.clear();
            if (DependentEMFLabelProvider.this.subscriptionListener == this) {
                DependentEMFLabelProvider.this.subscriptionListener = null;
            }
        }
    }
}

