/*****************************************************************************
 * Copyright (c) 2013 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   CEA LIST - Initial API and implementation
 *****************************************************************************/
package org.eclipse.papyrus.views.validation.internal.providers;

import org.eclipse.papyrus.infra.services.markerlistener.IPapyrusMarker;

/**
 * This is the DescriptionLabelProvider type. Enjoy.
 */
public class DescriptionLabelProvider
		extends ProblemLabelProvider {

	public DescriptionLabelProvider() {
		super();
	}

	@Override
	public String getText(Object element) {
		String result = null;

		if (element instanceof IPapyrusMarker) {
			IPapyrusMarker marker = (IPapyrusMarker) element;
			return marker.getAttribute(IPapyrusMarker.MESSAGE, "");
		}

		return result;
	}
}
