/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.query.java.metamodel.v0_2_0.javaquery.internal;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.papyrus.emf.facet.query.java.metamodel.v0_2_0.javaquery.JavaQuery;
import org.eclipse.papyrus.emf.facet.query.java.metamodel.v0_2_0.javaquery.JavaQueryPackage;
import org.eclipse.papyrus.infra.tools.util.ClassLoaderHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaQueryValidator
extends EObjectValidator {
    public static JavaQueryValidator eInstance = new JavaQueryValidator();

    protected EPackage getEPackage() {
        return JavaQueryPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateJavaQuery((JavaQuery)value, diagnostics, context);
            }
        }
        return super.validate(classifierID, value, diagnostics, context);
    }

    public boolean validateJavaQuery(JavaQuery javaquery, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean valid = true;
        if (diagnostics != null && javaquery.getImplementationClassName() != null && !"".equals(javaquery.getImplementationClassName().trim())) {
            IProject[] projects;
            String classNameToFind = javaquery.getImplementationClassName();
            IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                try {
                    IJavaProject javaProject;
                    IType foundSource;
                    if (project.getNature("org.eclipse.pde.PluginNature") != null && (foundSource = (javaProject = JavaCore.create((IProject)project)).findType(classNameToFind)) != null) {
                        return true;
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
            Class loadedClass = ClassLoaderHelper.loadClass((String)classNameToFind);
            if (loadedClass == null) {
                valid = false;
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.emf.ecore", 1, "The java query '" + javaquery.getImplementationClassName() + "' references a class that does not exist ", new Object[]{javaquery}));
            }
        }
        return valid;
    }

    private boolean validatefacetSet_validate(FacetSet facetSet, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean valid = true;
        if (diagnostics != null && (facetSet.getNsPrefix() == null || facetSet.getNsPrefix().equals(""))) {
            return true;
        }
        return valid;
    }
}

