/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.util;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.papyrus.infra.widgets.Activator;

public class FileUtil {
    public static String getPath(IFile file, boolean absolute) {
        if (absolute) {
            return file.getLocation().toString();
        }
        return file.getFullPath().toString();
    }

    public static IFile getIFile(String location) {
        IWorkspaceRoot workspace = ResourcesPlugin.getWorkspace().getRoot();
        Path path = new Path(location);
        IFile currentFile = null;
        try {
            currentFile = workspace.getFile((IPath)path);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (currentFile == null || !currentFile.exists()) {
            currentFile = workspace.getFileForLocation((IPath)path);
        }
        return currentFile;
    }

    public static File getFile(String location) {
        IFile iFile = FileUtil.getIFile(location);
        if (iFile == null || !iFile.exists()) {
            return new File(location);
        }
        return new File(iFile.getLocationURI());
    }

    public static File getWorkspaceFile(String location) {
        IWorkspaceRoot workspace = ResourcesPlugin.getWorkspace().getRoot();
        Path path = new Path(location);
        IFile currentFile = null;
        try {
            currentFile = workspace.getFile((IPath)path);
        }
        catch (IllegalArgumentException ex) {
            Activator.log.error((Throwable)ex);
            return null;
        }
        return currentFile.getLocation().toFile();
    }

    public static File getFolder(String location) {
        IFolder iFolder = FileUtil.getIFolder(location);
        if (iFolder == null || !iFolder.exists()) {
            return new File(location);
        }
        return new File(iFolder.getLocationURI());
    }

    public static IFolder getIFolder(String location) {
        IWorkspaceRoot workspace = ResourcesPlugin.getWorkspace().getRoot();
        Path path = new Path(location);
        IFolder currentFolder = null;
        try {
            currentFolder = workspace.getFolder((IPath)path);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (currentFolder == null || !currentFolder.exists()) {
            currentFolder = (IFolder)workspace.getContainerForLocation((IPath)path);
        }
        return currentFolder;
    }
}

