/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.architecture.merged;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.papyrus.infra.core.architecture.ADElement;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDescriptionLanguage;
import org.eclipse.papyrus.infra.core.architecture.RepresentationKind;
import org.eclipse.papyrus.infra.core.architecture.TreeViewerConfiguration;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureDomain;

public class MergedArchitectureDescriptionLanguage
extends MergedArchitectureContext {
    public MergedArchitectureDescriptionLanguage(MergedArchitectureDomain domain) {
        super(domain);
    }

    public EPackage getMetamodel() {
        for (ADElement element : this.elements) {
            ArchitectureDescriptionLanguage language = (ArchitectureDescriptionLanguage)element;
            if (language.getMetamodel() == null) continue;
            return language.getMetamodel();
        }
        return null;
    }

    public Collection<EPackage> getProfiles() {
        LinkedHashSet profiles = new LinkedHashSet();
        for (ADElement element : this.elements) {
            ArchitectureDescriptionLanguage language = (ArchitectureDescriptionLanguage)element;
            profiles.addAll(language.getProfiles());
        }
        return Collections.unmodifiableCollection(profiles);
    }

    public Collection<RepresentationKind> getRepresentationKinds() {
        LinkedHashSet kinds = new LinkedHashSet();
        for (ADElement element : this.elements) {
            ArchitectureDescriptionLanguage language = (ArchitectureDescriptionLanguage)element;
            kinds.addAll(language.getRepresentationKinds());
        }
        return Collections.unmodifiableCollection(kinds);
    }

    public Collection<TreeViewerConfiguration> getTreeViewerConfigurations() {
        LinkedHashSet kinds = new LinkedHashSet();
        for (ADElement element : this.elements) {
            ArchitectureDescriptionLanguage language = (ArchitectureDescriptionLanguage)element;
            kinds.addAll(language.getTreeViewerConfigurations());
        }
        return Collections.unmodifiableCollection(kinds);
    }
}

