/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.dnd.policy;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.editpolicy.CreateEditPoliciesOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.editpolicy.IEditPolicyProvider;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.gmfdiag.common.service.ProviderServiceUtil;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.ServiceUtilsForEditPart;
import org.eclipse.papyrus.infra.gmfdiag.dnd.policy.CustomizableDropEditPolicy;

public class CustomizableDropEditPolicyProvider
extends AbstractProvider
implements IEditPolicyProvider {
    public boolean provides(IOperation operation) {
        CreateEditPoliciesOperation epOperation = (CreateEditPoliciesOperation)operation;
        if (!ProviderServiceUtil.isEnabled((IEditPolicyProvider)this, (EditPart)epOperation.getEditPart())) {
            return false;
        }
        try {
            ServicesRegistry registry = ServiceUtilsForEditPart.getInstance().getServiceRegistry(epOperation.getEditPart());
            return registry != null;
        }
        catch (ServiceException e) {
            return false;
        }
    }

    public void createEditPolicies(EditPart editPart) {
        EditPolicy defaultDropEditPolicy = editPart.getEditPolicy((Object)"DragDropPolicy");
        EditPolicy defaultCreationEditPolicy = editPart.getEditPolicy((Object)"CreationPolicy");
        CustomizableDropEditPolicy dropEditPolicy = new CustomizableDropEditPolicy(defaultDropEditPolicy, defaultCreationEditPolicy);
        editPart.installEditPolicy((Object)"DragDropPolicy", null);
        editPart.installEditPolicy((Object)"CreationPolicy", (EditPolicy)dropEditPolicy);
    }
}

