/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.composite.custom.helper.advice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.GetEditContextCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.util.CrossReferencerUtil;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

public class PropertyHelperAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getBeforeSetCommand(SetRequest request) {
        Type oldType = null;
        Type newType = null;
        EObject elementToEdit = request.getElementToEdit();
        HashSet<View> viewsToDelete = new HashSet<View>();
        if (elementToEdit instanceof Property && request.getFeature() == UMLPackage.eINSTANCE.getTypedElement_Type() && (request.getValue() == null || request.getValue() instanceof Type)) {
            Property propertyToEdit = (Property)elementToEdit;
            oldType = propertyToEdit.getType();
            newType = (Type)request.getValue();
            if (oldType != null && oldType instanceof Classifier && (request.getValue() == null || newType instanceof Classifier)) {
                BasicEList newTypeMembers = newType != null ? ((Classifier)newType).getMembers() : new BasicEList();
                EList oldTypeMembers = ((Classifier)oldType).getMembers();
                ArrayList possiblyInconsistentMembers = new ArrayList();
                possiblyInconsistentMembers.addAll(oldTypeMembers);
                possiblyInconsistentMembers.removeAll((Collection<?>)newTypeMembers);
                if (!possiblyInconsistentMembers.isEmpty()) {
                    Set propertyToEditViews = null;
                    for (NamedElement possiblyInconsistentMember : possiblyInconsistentMembers) {
                        Iterator viewIt = CrossReferencerUtil.getCrossReferencingViews((EObject)possiblyInconsistentMember, (String)"CompositeStructure").iterator();
                        while (viewIt.hasNext()) {
                            View possiblyInconsistentMemberView;
                            if (propertyToEditViews == null) {
                                propertyToEditViews = CrossReferencerUtil.getCrossReferencingViews((EObject)propertyToEdit, (String)"CompositeStructure");
                            }
                            if (!this.isConcerned(possiblyInconsistentMemberView = (View)viewIt.next(), propertyToEditViews)) continue;
                            viewsToDelete.add(possiblyInconsistentMemberView);
                        }
                    }
                }
            }
        }
        if (viewsToDelete != null && !viewsToDelete.isEmpty()) {
            DestroyDependentsRequest req = new DestroyDependentsRequest(request.getEditingDomain(), elementToEdit, false);
            req.setClientContext(request.getClientContext());
            req.addParameters(request.getParameters());
            return req.getDestroyDependentsCommand(viewsToDelete);
        }
        return null;
    }

    protected ICommand getBeforeEditContextCommand(GetEditContextRequest request) {
        if (request.getEditCommandRequest() instanceof CreateElementRequest) {
            CreateElementRequest createElementRequest = (CreateElementRequest)request.getEditCommandRequest();
            IElementType type = createElementRequest.getElementType();
            ArrayList<IElementType> types = new ArrayList<IElementType>(Arrays.asList(type.getAllSuperTypes()));
            types.add(type);
            if (types.contains(UMLElementTypes.PROPERTY) && !UMLPackage.eINSTANCE.getProperty_Qualifier().equals(createElementRequest.getContainmentFeature())) {
                GetEditContextCommand command = new GetEditContextCommand(request);
                if (request.getEditContext() instanceof Property) {
                    createElementRequest.setContainmentFeature(UMLPackage.eINSTANCE.getStructuredClassifier_OwnedAttribute());
                    Property p = (Property)request.getEditContext();
                    if (p.getType() != null) {
                        command.setEditContext((Object)p.getType());
                        return command;
                    }
                }
            }
        }
        return super.getBeforeEditContextCommand(request);
    }

    protected boolean isConcerned(View view, Set<View> propertyViews) {
        EObject parentView = view.eContainer();
        if (parentView instanceof DecorationNode) {
            parentView = parentView.eContainer();
        }
        return propertyViews.contains(parentView);
    }
}

