/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.bundles.tests;

import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.bundles.tests.BundleTestsUtils;
import org.eclipse.papyrus.internal.bundles.tests.PapyrusBundleDescription;
import org.eclipse.papyrus.internal.bundles.tests.PapyrusBundleDescriptionRegistry;
import org.eclipse.papyrus.junit.framework.classification.InvalidTest;
import org.eclipse.papyrus.junit.framework.classification.NotImplemented;
import org.eclipse.papyrus.junit.framework.classification.rules.Condition;
import org.eclipse.papyrus.junit.framework.classification.tests.AbstractPapyrusTest;
import org.eclipse.papyrus.junit.utils.JUnitUtils;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class BundlesTests
extends AbstractPapyrusTest {
    private static final String INCUBATION_KEYWORD = "(Incubation)";
    private static final String BATIK_VERSION = "\"[1.6.0,1.7.0)\"";
    private static final String NATTABLE_VERSION = "1.5.0";
    private static final String GLAZED_LIST_VERSION = "1.9.0";
    private static final String UML2_UML_VERSION_RANGE = "bundle-version=\"[5.3.0,6.0.0)\"";
    @Condition
    public final boolean isAutomatedBuild = JUnitUtils.isAutomatedBuildExecution();
    public static final String REGEX_PACKAGE_WORD = "\\w(?:\\w|\\d)*";
    public static final String REGEX_PLUGIN = "(?:\\.\\w(?:\\w|\\d)*)*";
    public static final String REGEX_BUNDLE = "(?:;bundle-version=\"([^\"]*)\")?";
    public static final String REGEX_REEXPORT = "(?:;\\w*:=\\w*;\\w*-\\w*=\"([^\"]*)\")|";

    @InvalidTest(value="Some Papyrus bundles are still incubating (Extra...)")
    @Test
    public void incubationTest() {
        BaseMatcher<String> matcher = new BaseMatcher<String>(){

            public boolean matches(Object item) {
                return item instanceof String && !((String)item).contains(BundlesTests.INCUBATION_KEYWORD);
            }

            public void describeTo(Description description) {
                description.appendText("Does not contain ");
                description.appendText(BundlesTests.INCUBATION_KEYWORD);
            }
        };
        this.testManifestProperty("Bundle-Name", (Matcher<String>)matcher, false, false);
    }

    @Test
    public void vendorTest() {
        this.testManifestProperty("Bundle-Vendor", "Eclipse Modeling Project", false, false);
    }

    @Test
    public void aboutTest() {
        this.fileTest("/about.html");
    }

    @Test
    public void javaVersionTest() {
        this.testManifestProperty("Bundle-RequiredExecutionEnvironment", BundleTestsUtils.JAVA_VERSION_REGEX, false, true);
    }

    @NotImplemented(value="Usage of importPackage is discouraged")
    @Test
    public void importPackage() {
        this.testManifestProperty("Import-Package", "", true, false);
    }

    private void testManifestProperty(String property, final String regex, boolean mustBeNull, boolean onlyOnJavaProject) {
        BaseMatcher<String> regexMatcher = new BaseMatcher<String>(){

            public boolean matches(Object item) {
                return item instanceof String && ((String)item).matches(regex);
            }

            public void describeTo(Description description) {
                description.appendText("Matching regex(");
                description.appendValue((Object)regex);
                description.appendText(")");
            }
        };
        this.testManifestProperty(property, (Matcher<String>)regexMatcher, mustBeNull, onlyOnJavaProject);
    }

    private void testManifestProperty(String property, Matcher<String> matcher, boolean mustBeNull, boolean onlyOnJavaProject) {
        String message = null;
        int nb = 0;
        for (Bundle current : BundleTestsUtils.getPapyrusBundles()) {
            if (onlyOnJavaProject && !BundleTestsUtils.isJavaProject(current)) continue;
            String value = (String)current.getHeaders().get(property);
            boolean result = false;
            if (mustBeNull) {
                result = value == null;
            } else if (value != null) {
                result = matcher.matches((Object)value);
            }
            if (result) continue;
            if (message == null) {
                message = "Wrong " + property + " for :";
            }
            message = String.valueOf(message) + "\n ";
            message = String.valueOf(message) + current.getSymbolicName();
            ++nb;
        }
        Assert.assertNull((String)(String.valueOf(nb) + " problems!"), message);
    }

    private void fileTest(String filepath) {
        StringBuffer buffer = new StringBuffer();
        int nb = 0;
        for (Bundle current : BundleTestsUtils.getPapyrusBundles()) {
            URL url = current.getEntry(filepath);
            if (url != null) continue;
            if (buffer.length() == 0) {
                buffer.append(NLS.bind((String)"The following bundles don't have the file {0}.", (Object)filepath));
            }
            buffer.append("\n");
            buffer.append(current.getSymbolicName());
            ++nb;
        }
        StringBuffer errorMessage = new StringBuffer();
        errorMessage.append(nb);
        errorMessage.append(" problems!\n");
        errorMessage.append(buffer.toString());
        Assert.assertTrue((String)errorMessage.toString(), (boolean)buffer.toString().isEmpty());
    }

    @Test
    public void batikDependencyVersionTest() {
        this.testPapyrusDependencies2("org.apache.batik", BATIK_VERSION);
    }

    @Test
    public void natTableDependencyVersionTest() {
        this.testPapyrusDependencies("org.eclipse.nebula.widgets.nattable", NATTABLE_VERSION, Collections.singletonList("org.eclipse.nebula.widgets.nattable.extension.nebula"));
    }

    @Test
    public void glazedListDependencyVersionTest() {
        this.testPapyrusDependencies2("ca.odell.glazedlists", GLAZED_LIST_VERSION);
    }

    @Test
    public void guavaDependencyVersionTest() {
        this.testPapyrusDependencies2("com.google.guava", "30.1.0");
    }

    @Test
    public void uml2umlDependencyVersionTest() {
        this.testPapyrusDependencies("org.eclipse.uml2.uml", UML2_UML_VERSION_RANGE, new ArrayList<String>(Arrays.asList("org.eclipse.uml2.uml.profile.standard", "org.eclipse.uml2.uml.validation", "org.eclipse.uml2.uml.editor")));
    }

    @Deprecated
    protected void testPapyrusDependencies2(String partialDependencyName, String wantedVersion) {
        this.testPapyrusDependencies(partialDependencyName, wantedVersion, Collections.emptyList());
    }

    protected void testPapyrusDependencies(String partialDependencyName, String wantedVersion, List<String> exceptions) {
        StringBuilder builder = new StringBuilder();
        int nb = 0;
        Version wanted = new Version(wantedVersion);
        for (Bundle current : BundleTestsUtils.getPapyrusBundles()) {
            String value = (String)current.getHeaders().get("Require-Bundle");
            if (value == null) continue;
            Pattern pattern = Pattern.compile("(" + partialDependencyName + REGEX_PLUGIN + ")" + "(" + REGEX_REEXPORT + REGEX_BUNDLE + ")");
            java.util.regex.Matcher matcher = pattern.matcher(value);
            StringBuilder localBuilder = new StringBuilder();
            while (matcher.find()) {
                String pluginName = matcher.group(1);
                if (exceptions.contains(pluginName)) continue;
                String versionString = null;
                if (matcher.groupCount() > 1) {
                    versionString = matcher.group(2);
                }
                if (versionString == null) {
                    if (localBuilder.length() == 0) {
                        localBuilder.append(NLS.bind((String)"Incorrect version for {0}, got {1} and not {2} \n", (Object[])new String[]{pluginName, current.getSymbolicName(), wantedVersion}));
                    }
                    localBuilder.append(NLS.bind((String)"No Version number for {0}\n", (Object)pluginName));
                    ++nb;
                    continue;
                }
                Version version = new Version(versionString);
                if (version.inIncludedIn(wanted)) continue;
                if (localBuilder.length() == 0) {
                    localBuilder.append(NLS.bind((String)"{0} incorrect required bundle-version:\n", (Object)current.getSymbolicName()));
                }
                localBuilder.append(NLS.bind((String)"Bad version for {0}, got {1} and not {2} \n", (Object[])new String[]{pluginName, versionString, wantedVersion}));
                ++nb;
            }
            if (localBuilder.length() == 0) continue;
            builder.append(localBuilder.toString());
            builder.append("\n");
        }
        if (builder.length() != 0) {
            builder.insert(0, NLS.bind((String)"{0} problems. We want this version : {1} for the plugin {2}\n", (Object[])new String[]{Integer.toString(nb), wantedVersion, partialDependencyName}));
        }
        Assert.assertTrue((String)builder.toString(), (builder.length() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void pluginIDTest() {
        StringBuffer errorMessage = new StringBuffer();
        StringBuffer warningMessage = new StringBuffer();
        ArrayList<String> possibleIds = new ArrayList<String>();
        possibleIds.add("ID");
        possibleIds.add("PLUGIN_ID");
        int nbError = 0;
        int nbWarning = 0;
        for (Bundle current : BundleTestsUtils.getPapyrusBundles()) {
            String activator;
            if (!BundleTestsUtils.isJavaProject(current) || (activator = (String)current.getHeaders().get("Bundle-Activator")) == null) continue;
            try {
                Class activatorClass = current.loadClass(activator);
                Field plugin_id_field = null;
                Field[] fieldArray = activatorClass.getFields();
                int n = fieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Field currentField = fieldArray[n2];
                    String fieldName = currentField.getName();
                    if (possibleIds.contains(fieldName)) {
                        plugin_id_field = currentField;
                        break;
                    }
                    ++n2;
                }
                if (plugin_id_field != null) {
                    String plugin_id = (String)plugin_id_field.get(activatorClass);
                    if (plugin_id.equals(current.getSymbolicName())) continue;
                    ++nbError;
                    errorMessage.append(NLS.bind((String)"The field PLUGIN_ID of the plugin {0} is not equals to the plugin name.\n", (Object)current.getSymbolicName()));
                    continue;
                }
                ++nbWarning;
                warningMessage.append(NLS.bind((String)"The activator of {0} has no field named PLUGIN_ID.\n", (Object)current.getSymbolicName()));
            }
            catch (Exception e) {
                errorMessage.append(NLS.bind((String)"Exception occured with the plugin {0} \n {1} \n", (Object[])new Object[]{current.getSymbolicName(), e}));
            }
        }
        StringBuffer finalErrorMessage = new StringBuffer();
        finalErrorMessage.append(nbError);
        finalErrorMessage.append(" problems! ");
        finalErrorMessage.append(errorMessage);
        Assert.assertTrue((String)finalErrorMessage.toString(), (nbError == 0 ? 1 : 0) != 0);
    }

    @Test
    public void checkPapyrusEMFPluginDependency() {
        Version undefinedVersion = new Version(null);
        String bundleIDToCheck = "org.eclipse.papyrus.emf";
        HashMap<String, Version> dependencies = new HashMap<String, Version>();
        dependencies.put("org.eclipse.core.resources", undefinedVersion);
        dependencies.put("org.eclipse.core.runtime", undefinedVersion);
        dependencies.put("org.eclipse.emf.ecore.xmi", undefinedVersion);
        this.strictCheckOfDependenciesList("org.eclipse.papyrus.emf", dependencies, Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
    }

    @Test
    public void checkPapyrusEMFUIPluginDependency() {
        Version undefinedVersion = new Version(null);
        String bundleIDToCheck = "org.eclipse.papyrus.emf.ui";
        HashMap<String, Version> dependencies = new HashMap<String, Version>();
        dependencies.put("org.eclipse.core.runtime", undefinedVersion);
        dependencies.put("org.eclipse.emf.edit.ui", undefinedVersion);
        dependencies.put("org.eclipse.ui.views.properties.tabbed", undefinedVersion);
        this.strictCheckOfDependenciesList("org.eclipse.papyrus.emf.ui", dependencies, Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
    }

    private void strictCheckOfDependenciesList(String bundleSymbolicNameToCheck, Map<String, Version> bundleDependenciesWithVersion, Set<String> reexportedDependencies, Set<String> greedyDependencies, Set<String> optionalDependencies) {
        Assert.assertNotNull((Object)bundleSymbolicNameToCheck);
        Assert.assertNotNull(bundleDependenciesWithVersion);
        Assert.assertNotNull(reexportedDependencies);
        Assert.assertNotNull(greedyDependencies);
        Assert.assertNotNull(optionalDependencies);
        PapyrusBundleDescription bundleToCheck = PapyrusBundleDescriptionRegistry.INSTANCE.getPapyrusBundleDescription(bundleSymbolicNameToCheck);
        Assert.assertNotNull((String)NLS.bind((String)"The bundle {0} has not been found.", (Object)bundleSymbolicNameToCheck), (Object)bundleToCheck);
        Set<String> expectedDependencies = bundleDependenciesWithVersion.keySet();
        Assert.assertEquals((String)"The current dependencies are not the expected ones.", expectedDependencies, PapyrusBundleDescription.asSymbolicNameSet(bundleToCheck.getDependencies()));
        Assert.assertEquals((String)"The current reexported dependencies are not the expected ones.", reexportedDependencies, PapyrusBundleDescription.asSymbolicNameSet(bundleToCheck.getReexportedDependencies()));
        Assert.assertEquals((String)"The current greedy dependencies are not the expected ones.", greedyDependencies, PapyrusBundleDescription.asSymbolicNameSet(bundleToCheck.getGreedyDependencies()));
        Assert.assertEquals((String)"The current optional dependencies are not the expected ones.", optionalDependencies, PapyrusBundleDescription.asSymbolicNameSet(bundleToCheck.getOptionalDependencies()));
        for (Map.Entry<String, Version> current : bundleDependenciesWithVersion.entrySet()) {
            Assert.assertTrue((String)NLS.bind((String)"The dependency {0} is not registered with compatible version range", (Object)current.getKey()), (boolean)bundleToCheck.getRegisteredDependencyVersion(current.getKey()).inIncludedIn(current.getValue()));
        }
    }

    public static class Version {
        private boolean minIncluding = true;
        private boolean maxIncluding = true;
        private int[] min = null;
        private int[] max = null;

        public Version(String versionAsString) {
            if (versionAsString != null) {
                this.minIncluding = !versionAsString.startsWith("(");
                this.maxIncluding = !versionAsString.endsWith(")");
                Pattern versionNumber = Pattern.compile("\\d+(\\.\\d+)*");
                java.util.regex.Matcher matcher = versionNumber.matcher(versionAsString);
                while (matcher.find()) {
                    String grp = matcher.group();
                    String[] versions = grp.split("\\.");
                    int[] vers = new int[versions.length];
                    int i = 0;
                    while (i < versions.length) {
                        vers[i] = Integer.parseInt(versions[i]);
                        ++i;
                    }
                    if (this.min == null) {
                        this.min = vers;
                        continue;
                    }
                    this.max = vers;
                }
            }
            if (this.min == null) {
                this.min = new int[3];
            }
            if (this.max == null) {
                this.max = new int[]{99, 99, 99};
            }
        }

        public boolean inIncludedIn(Version version) {
            if (this.compare(this.max, version.min) < 0) {
                return false;
            }
            if (this.compare(version.max, this.min) < 0) {
                return false;
            }
            if (!(this.compare(this.max, version.min) != 0 || this.maxIncluding && version.minIncluding)) {
                return false;
            }
            if (!(this.compare(version.max, this.min) != 0 || version.maxIncluding && this.minIncluding)) {
                return false;
            }
            if (this.compare(this.min, version.min) < 0) {
                return false;
            }
            if (this.compare(this.min, version.min) == 0 && this.minIncluding != version.minIncluding) {
                return false;
            }
            if (this.compare(this.max, version.max) > 0) {
                return false;
            }
            return this.compare(this.max, version.max) != 0 || this.maxIncluding == version.maxIncluding;
        }

        protected int compare(int[] first, int[] second) {
            int min = Math.min(first.length, second.length);
            int i = 0;
            while (i < min) {
                if (first[i] < second[i]) {
                    return -1;
                }
                if (first[i] > second[i]) {
                    return 1;
                }
                ++i;
            }
            if (first.length == second.length) {
                return 0;
            }
            if (first.length > second.length) {
                return 1;
            }
            return -1;
        }
    }
}

