/**
 * Copyright (c) 2016 CEA LIST and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Florian Noyrit - Initial API and implementation
 */
package aspects.xpt.editor;

import aspects.xpt.Common;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenContainerBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
@SuppressWarnings("all")
public class DiagramContentInitializer extends xpt.editor.DiagramContentInitializer {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  private VisualIDRegistry xptVisualIDRegistry;
  
  @Override
  public CharSequence getCompartment(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private org.eclipse.gmf.runtime.notation.Node getCompartment(org.eclipse.gmf.runtime.notation.View node, String visualID) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("String type = ");
    CharSequence _typeMethodCall = this.xptVisualIDRegistry.typeMethodCall(it, "visualID");
    _builder.append(_typeMethodCall, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("for (java.util.Iterator it = node.getChildren().iterator(); it.hasNext();) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gmf.runtime.notation.View nextView = (org.eclipse.gmf.runtime.notation.View) it.next();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (nextView instanceof org.eclipse.gmf.runtime.notation.Node && type.equals(nextView.getType())) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return (org.eclipse.gmf.runtime.notation.Node) nextView;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence createChildrenMethodName(final GenContainerBase it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("create");
    String _stringUniqueIdentifier = this._common.stringUniqueIdentifier(it);
    _builder.append(_stringUniqueIdentifier);
    _builder.append("_Children");
    return _builder;
  }
}
