/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.bridge.naming;

import org.eclipse.papyrus.gmf.codegen.gmfgen.FigureViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.InnerClassViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ParentAssignedViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.Viewmap;
import org.eclipse.papyrus.gmf.internal.bridge.naming.AbstractGenNamingStrategy;
import org.eclipse.papyrus.gmf.internal.bridge.naming.GenNamingStrategy;
import org.eclipse.papyrus.gmf.internal.common.NamesDispenser;

public class DesignGenNamingStrategy
extends AbstractGenNamingStrategy {
    public DesignGenNamingStrategy(String suffix, NamesDispenser namesDispenser, GenNamingStrategy chainedNamingStrategy, GenNamingStrategy prefixNamingStrategy) {
        super(suffix, namesDispenser, chainedNamingStrategy, prefixNamingStrategy);
    }

    @Override
    public String get(GenDiagram element) {
        String name = this.getDesignName(element.getViewmap());
        if (name != null) {
            return this.createClassName(name);
        }
        return super.get(element);
    }

    @Override
    public String get(GenNode element) {
        String name = this.getDesignName(element.getViewmap());
        if (name != null) {
            return this.createClassName(name);
        }
        return super.get(element);
    }

    @Override
    public String get(GenCompartment element) {
        String name = this.getDesignName(element.getViewmap());
        if (name != null) {
            return this.createClassName(String.valueOf(this.getCompartmentHostPrefix(element)) + name);
        }
        return super.get(element);
    }

    @Override
    public String get(GenLink element) {
        String name = this.getDesignName(element.getViewmap());
        if (name != null) {
            return this.createClassName(name);
        }
        return super.get(element);
    }

    @Override
    public String get(GenLabel element) {
        String name = this.getDesignName(element.getViewmap());
        if (name != null) {
            return this.createClassName(name);
        }
        return super.get(element);
    }

    protected String getDesignName(Viewmap viewmap) {
        if (viewmap == null) {
            return null;
        }
        String name = null;
        if (viewmap instanceof FigureViewmap) {
            name = ((FigureViewmap)viewmap).getFigureQualifiedClassName();
        } else if (viewmap instanceof InnerClassViewmap) {
            name = ((InnerClassViewmap)viewmap).getClassName();
        } else if (viewmap instanceof ParentAssignedViewmap) {
            name = ((ParentAssignedViewmap)viewmap).getFigureQualifiedClassName();
        }
        if (name == null || name.length() == 0) {
            return null;
        }
        if ((name = name.substring(name.lastIndexOf(46) + 1)).endsWith("Figure") && name.length() > "Figure".length()) {
            name = name.substring(0, name.length() - "Figure".length());
        }
        if (name.length() == 0) {
            return null;
        }
        if (name.length() < 2) {
            return name.toUpperCase();
        }
        return String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1);
    }
}

