/**
 * Copyright (c) 2006, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Artem Tikhomirov (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package gmfgraph;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import gmfgraph.attr.CustomAttributeOwner;
import gmfgraph.attr.Figure;
import java.util.Arrays;
import org.eclipse.papyrus.gmf.gmfgraph.BorderRef;
import org.eclipse.papyrus.gmf.gmfgraph.Color;
import org.eclipse.papyrus.gmf.gmfgraph.CompoundBorder;
import org.eclipse.papyrus.gmf.gmfgraph.CustomBorder;
import org.eclipse.papyrus.gmf.gmfgraph.LineBorder;
import org.eclipse.papyrus.gmf.gmfgraph.MarginBorder;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import xpt.Common;
import xpt.Common_qvto;

@Singleton
@SuppressWarnings("all")
public class Border {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private Common_qvto _common_qvto;
  
  @Inject
  @Extension
  private Utils_Statefull_qvto _utils_Statefull_qvto;
  
  @Inject
  private MapMode xptMapMode;
  
  @Inject
  private Figure xptFigure;
  
  @Inject
  private CustomAttributeOwner xptCustomAttributeOwner;
  
  @Inject
  private gmfgraph.Runtime xptRuntime;
  
  public CharSequence Init(final org.eclipse.papyrus.gmf.gmfgraph.Border border, final String figureVarName) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _notEquals = (!Objects.equal(border, null));
      if (_notEquals) {
        _builder.append(figureVarName);
        _builder.append(".setBorder(");
        CharSequence _border = this.border(border, figureVarName);
        _builder.append(_border);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public CharSequence InitMethods(final org.eclipse.papyrus.gmf.gmfgraph.Figure it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      Iterable<CustomBorder> _bordersInUse = this._utils_Statefull_qvto.getBordersInUse();
      for(final CustomBorder b : _bordersInUse) {
        CharSequence _initMethod = this.initMethod(b, Integer.valueOf(IterableExtensions.<CustomBorder>toList(this._utils_Statefull_qvto.getBordersInUse()).indexOf(b)));
        _builder.append(_initMethod);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public CharSequence initMethod(final CustomBorder it, final Integer c) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private org.eclipse.draw2d.Border createBorder");
    _builder.append(c);
    _builder.append("() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _newInstance = this.xptRuntime.newInstance(it, "result");
    _builder.append(_newInstance, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _extraLineBreak = this._common.extraLineBreak();
    _builder.append(_extraLineBreak, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _Init = this.xptCustomAttributeOwner.Init(it, "result");
    _builder.append(_Init, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _extraLineBreak_1 = this._common.extraLineBreak();
    _builder.append(_extraLineBreak_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return result;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _border(final Border it, final String figureVarName) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR(
      ("This is an abstract definition border(String, Border) invoked for " + it));
    return _builder;
  }
  
  protected CharSequence _border(final LineBorder it, final String figureVarName) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("new org.eclipse.draw2d.LineBorder(");
    {
      Color _color = it.getColor();
      boolean _equals = Objects.equal(null, _color);
      if (_equals) {
        _builder.append("null");
      } else {
        Color _color_1 = it.getColor();
        String _upperCase = figureVarName.toUpperCase();
        String _plus = (_upperCase + "_BORDER");
        CharSequence _color_2 = this.xptFigure.color(_color_1, _plus);
        _builder.append(_color_2);
      }
    }
    _builder.append(", ");
    CharSequence _mapMode = this.xptMapMode.mapMode(Integer.valueOf(it.getWidth()));
    _builder.append(_mapMode);
    _builder.append(")");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _border(final MarginBorder it, final String figureVarName) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("new org.eclipse.draw2d.MarginBorder(");
    CharSequence _mapMode = this.xptMapMode.mapMode(it.getInsets());
    _builder.append(_mapMode);
    _builder.append(")");
    return _builder;
  }
  
  protected CharSequence _border(final CompoundBorder it, final String figureVarName) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("new org.eclipse.draw2d.CompoundBorder(");
    {
      org.eclipse.papyrus.gmf.gmfgraph.Border _outer = it.getOuter();
      boolean _equals = Objects.equal(_outer, null);
      if (_equals) {
        _builder.append("null");
      } else {
        CharSequence _border = this.border(it.getOuter(), figureVarName);
        _builder.append(_border);
      }
    }
    _builder.append(", ");
    {
      org.eclipse.papyrus.gmf.gmfgraph.Border _inner = it.getInner();
      boolean _equals_1 = Objects.equal(_inner, 
        null);
      if (_equals_1) {
        _builder.append("null");
      } else {
        CharSequence _border_1 = this.border(it.getInner(), figureVarName);
        _builder.append(_border_1);
      }
    }
    _builder.append(")");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _border(final CustomBorder it, final String figureVarName) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("createBorder");
    int _size = IterableExtensions.size(this._utils_Statefull_qvto.getBordersInUse());
    _builder.append(_size);
    _builder.append("()");
    this._utils_Statefull_qvto.addBorder(it);
    return _builder;
  }
  
  protected CharSequence _border(final BorderRef it, final String figureVarName) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _border = this.border(it.getActual(), figureVarName);
    _builder.append(_border);
    return _builder;
  }
  
  public CharSequence border(final Object it, final String figureVarName) {
    if (it instanceof CustomBorder) {
      return _border((CustomBorder)it, figureVarName);
    } else if (it instanceof BorderRef) {
      return _border((BorderRef)it, figureVarName);
    } else if (it instanceof CompoundBorder) {
      return _border((CompoundBorder)it, figureVarName);
    } else if (it instanceof LineBorder) {
      return _border((LineBorder)it, figureVarName);
    } else if (it instanceof MarginBorder) {
      return _border((MarginBorder)it, figureVarName);
    } else if (it instanceof Border) {
      return _border((Border)it, figureVarName);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, figureVarName).toString());
    }
  }
}
