/**
 * Copyright (c) 2006, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Artem Tikhomirov (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package gmfgraph.top;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import gmfgraph.Attrs;
import gmfgraph.Border;
import gmfgraph.Children;
import gmfgraph.Decoration;
import gmfgraph.Extras;
import gmfgraph.Layout;
import gmfgraph.Utils_Statefull_qvto;
import java.util.Arrays;
import java.util.List;
import org.eclipse.papyrus.gmf.gmfgraph.DecorationFigure;
import org.eclipse.papyrus.gmf.gmfgraph.FigureRef;
import org.eclipse.papyrus.gmf.gmfgraph.PolylineConnection;
import org.eclipse.papyrus.gmf.gmfgraph.RealFigure;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import xpt.Common;
import xpt.Common_qvto;

@Singleton
@SuppressWarnings("all")
public class Figure {
  @Inject
  @Extension
  private Common_qvto _common_qvto;
  
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private Utils_Statefull_qvto _utils_Statefull_qvto;
  
  @Inject
  private Layout xptLayout;
  
  @Inject
  private Attrs xptAttrs;
  
  @Inject
  private Children xptChildren;
  
  @Inject
  private Border xptBorder;
  
  @Inject
  private Extras xptExtras;
  
  @Inject
  private Decoration xptDecoration;
  
  protected CharSequence _ClassBody(final org.eclipse.papyrus.gmf.gmfgraph.Figure it, final String cuName) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR("abstract ClassBody(Figure)");
    return _builder;
  }
  
  protected CharSequence _ClassBody(final FigureRef it, final String cuName) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _ClassBody = this.ClassBody(it.getFigure(), cuName, it);
    _builder.append(_ClassBody);
    return _builder;
  }
  
  protected CharSequence _ClassBody(final RealFigure it, final String cuName) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _ClassBody = this.ClassBody(it, cuName, null);
    _builder.append(_ClassBody);
    return _builder;
  }
  
  protected CharSequence _ClassBody(final RealFigure it, final String cuName, final FigureRef figureRef) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public ");
    _builder.append(cuName);
    _builder.append("() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    this._utils_Statefull_qvto.clearState();
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _Init = this.xptLayout.Init(it.getLayout(), "this");
    _builder.append(_Init, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _Init_1 = this.xptAttrs.Init(it, "this");
    _builder.append(_Init_1, "\t");
    _builder.newLineIfNotEmpty();
    {
      boolean _notEquals = (!Objects.equal(figureRef, null));
      if (_notEquals) {
        _builder.append("// ");
        String _name = figureRef.getFigure().getName();
        _builder.append(_name);
        _builder.append(" ");
        _builder.newLineIfNotEmpty();
        _builder.append("// Process FigureRef details");
        _builder.newLine();
        CharSequence _Init_2 = this.xptLayout.Init(figureRef.getLayout(), "this");
        _builder.append(_Init_2);
        _builder.newLineIfNotEmpty();
        CharSequence _Init_3 = this.xptAttrs.Init(figureRef, "this");
        _builder.append(_Init_3);
        _builder.newLineIfNotEmpty();
      }
    }
    {
      boolean _isEmpty = IterableExtensions.isEmpty(Iterables.<org.eclipse.papyrus.gmf.gmfgraph.Figure>filter(it.getChildren(), org.eclipse.papyrus.gmf.gmfgraph.Figure.class));
      boolean _not = (!_isEmpty);
      if (_not) {
        _builder.append("\t");
        _builder.append("createContents();");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        CharSequence _CreateChildren = this.xptChildren.CreateChildren(it);
        _builder.append(_CreateChildren);
        _builder.newLineIfNotEmpty();
      } else {
        _builder.append("}");
        _builder.newLine();
      }
    }
    CharSequence _InitMethods = this.xptBorder.InitMethods(it);
    _builder.append(_InitMethods);
    _builder.newLineIfNotEmpty();
    CharSequence _extraLineBreak = this._common.extraLineBreak();
    _builder.append(_extraLineBreak);
    _builder.newLineIfNotEmpty();
    CharSequence _extraMethods = this.xptExtras.extraMethods(it);
    _builder.append(_extraMethods);
    _builder.newLineIfNotEmpty();
    CharSequence _additions = this.additions(it);
    _builder.append(_additions);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public Iterable<org.eclipse.papyrus.gmf.gmfgraph.Figure> safeExcluding(final List<org.eclipse.papyrus.gmf.gmfgraph.Figure> children, final DecorationFigure... d) {
    return this.safeExcluding(children, Arrays.<DecorationFigure>asList(d));
  }
  
  public Iterable<org.eclipse.papyrus.gmf.gmfgraph.Figure> safeExcluding(final List<org.eclipse.papyrus.gmf.gmfgraph.Figure> children, final List<DecorationFigure> d) {
    final Function1<org.eclipse.papyrus.gmf.gmfgraph.Figure, Boolean> _function = new Function1<org.eclipse.papyrus.gmf.gmfgraph.Figure, Boolean>() {
      @Override
      public Boolean apply(final org.eclipse.papyrus.gmf.gmfgraph.Figure f) {
        boolean _contains = d.contains(f);
        return Boolean.valueOf((!_contains));
      }
    };
    return IterableExtensions.<org.eclipse.papyrus.gmf.gmfgraph.Figure>filter(children, _function);
  }
  
  protected CharSequence _ClassBody(final PolylineConnection it, final String cuName, final FigureRef figureRef) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t");
    final Iterable<org.eclipse.papyrus.gmf.gmfgraph.Figure> childrenWithoutDecorators = this.safeExcluding(it.getChildren(), it.getSourceDecoration(), it.getTargetDecoration());
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public ");
    _builder.append(cuName, "\t");
    _builder.append("() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    this._utils_Statefull_qvto.clearState();
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    CharSequence _Init = this.xptAttrs.Init(it, "this");
    _builder.append(_Init, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    CharSequence _extraLineBreak = this._common.extraLineBreak();
    _builder.append(_extraLineBreak, "\t\t");
    _builder.newLineIfNotEmpty();
    {
      boolean _isEmpty = IterableExtensions.isEmpty(childrenWithoutDecorators);
      boolean _not = (!_isEmpty);
      if (_not) {
        _builder.append("\t\t");
        _builder.append("createContents();");
        _builder.newLine();
      }
    }
    {
      DecorationFigure _sourceDecoration = it.getSourceDecoration();
      boolean _notEquals = (!Objects.equal(_sourceDecoration, null));
      if (_notEquals) {
        _builder.append("\t\t");
        _builder.append("setSourceDecoration(createSourceDecoration());");
        _builder.newLine();
      }
    }
    {
      DecorationFigure _targetDecoration = it.getTargetDecoration();
      boolean _notEquals_1 = (!Objects.equal(_targetDecoration, null));
      if (_notEquals_1) {
        _builder.append("\t\t");
        _builder.append("setTargetDecoration(createTargetDecoration());");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    {
      boolean _isEmpty_1 = IterableExtensions.isEmpty(childrenWithoutDecorators);
      boolean _not_1 = (!_isEmpty_1);
      if (_not_1) {
        _builder.append("\t");
        CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private void createContents(){");
        _builder.newLine();
        {
          for(final org.eclipse.papyrus.gmf.gmfgraph.Figure l : childrenWithoutDecorators) {
            _builder.append("\t");
            _builder.append("\t");
            CharSequence _instantiate = this.xptChildren.instantiate(l, 0, it, "this");
            _builder.append(_instantiate, "\t\t");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t");
        _builder.append("\t");
        CharSequence _extraLineBreak_1 = this._common.extraLineBreak();
        _builder.append(_extraLineBreak_1, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    {
      DecorationFigure _sourceDecoration_1 = it.getSourceDecoration();
      boolean _notEquals_2 = (!Objects.equal(_sourceDecoration_1, null));
      if (_notEquals_2) {
        _builder.append("\t");
        CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_2, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private org.eclipse.draw2d.RotatableDecoration createSourceDecoration() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        CharSequence _Instantiate = this.xptDecoration.Instantiate(it.getSourceDecoration(), "df");
        _builder.append(_Instantiate, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("return df;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    {
      DecorationFigure _targetDecoration_1 = it.getTargetDecoration();
      boolean _notEquals_3 = (!Objects.equal(_targetDecoration_1, null));
      if (_notEquals_3) {
        _builder.append("\t");
        CharSequence _generatedMemberComment_3 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_3, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private org.eclipse.draw2d.RotatableDecoration createTargetDecoration() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        CharSequence _Instantiate_1 = this.xptDecoration.Instantiate(it.getTargetDecoration(), "df");
        _builder.append(_Instantiate_1, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("return df;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    CharSequence _additions = this.additions(it);
    _builder.append(_additions, "\t");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence additions(final org.eclipse.papyrus.gmf.gmfgraph.Figure it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  public CharSequence ClassBody(final org.eclipse.papyrus.gmf.gmfgraph.Figure it, final String cuName) {
    if (it instanceof FigureRef) {
      return _ClassBody((FigureRef)it, cuName);
    } else if (it instanceof RealFigure) {
      return _ClassBody((RealFigure)it, cuName);
    } else if (it != null) {
      return _ClassBody(it, cuName);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, cuName).toString());
    }
  }
  
  public CharSequence ClassBody(final RealFigure it, final String cuName, final FigureRef figureRef) {
    if (it instanceof PolylineConnection) {
      return _ClassBody((PolylineConnection)it, cuName, figureRef);
    } else if (it != null) {
      return _ClassBody(it, cuName, figureRef);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, cuName, figureRef).toString());
    }
  }
}
