/**
 * Copyright (c) 2006-2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 * 	  Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt.diagram.edithelpers;

import com.google.inject.Inject;
import org.eclipse.papyrus.gmf.codegen.gmfgen.SpecializationType;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.Common;

@SuppressWarnings("all")
public class EditHelperAdvice {
  @Inject
  @Extension
  private Common _common;
  
  public CharSequence className(final SpecializationType it) {
    StringConcatenation _builder = new StringConcatenation();
    String _editHelperAdviceClassName = it.getEditHelperAdviceClassName();
    _builder.append(_editHelperAdviceClassName);
    return _builder;
  }
  
  public CharSequence packageName(final SpecializationType it) {
    StringConcatenation _builder = new StringConcatenation();
    String _editHelpersPackageName = it.getDiagramElement().getDiagram().getEditHelpersPackageName();
    _builder.append(_editHelpersPackageName);
    return _builder;
  }
  
  public CharSequence qualifiedClassName(final SpecializationType it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence fullPath(final SpecializationType it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence EditHelperAdvice(final SpecializationType it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getDiagramElement().getDiagram().getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" ");
    CharSequence _extendsClause = this.extendsClause(it);
    _builder.append(_extendsClause);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _additions = this.additions(it);
    _builder.append(_additions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence additions(final SpecializationType it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  public CharSequence extendsClause(final SpecializationType it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("extends ");
    CharSequence _superClass = this.superClass(it);
    _builder.append(_superClass);
    return _builder;
  }
  
  public CharSequence superClass(final SpecializationType it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice");
    return _builder;
  }
}
