/**
 * Copyright (c) 2007, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Alexander Shatalin (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt.diagram.editpolicies;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import metamodel.MetaModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ElementType;
import org.eclipse.papyrus.gmf.codegen.gmfgen.FeatureLinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenConstraint;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenExpressionInterpreter;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenExpressionProviderBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenJavaExpressionProvider;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.LinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.TypeLinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ValueExpression;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.MetaDef;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import plugin.Activator;
import xpt.Common;
import xpt.Common_qvto;
import xpt.OclMigrationProblems_qvto;
import xpt.QualifiedClassNameProvider;
import xpt.diagram.Utils_qvto;
import xpt.diagram.edithelpers.BaseEditHelper;
import xpt.editor.VisualIDRegistry;
import xpt.expressions.getExpression;
import xpt.providers.ElementTypes;

@Singleton
@SuppressWarnings("all")
public class BaseItemSemanticEditPolicy {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private Common_qvto _common_qvto;
  
  @Inject
  @Extension
  private Utils_qvto _utils_qvto;
  
  @Inject
  @Extension
  private OclMigrationProblems_qvto _oclMigrationProblems_qvto;
  
  @Inject
  @Extension
  private xpt.diagram.editpolicies.Utils_qvto _utils_qvto_1;
  
  @Inject
  @Extension
  private QualifiedClassNameProvider _qualifiedClassNameProvider;
  
  @Inject
  private BaseEditHelper xptBaseEditHelper;
  
  @Inject
  private Activator xptPluginActivator;
  
  @Inject
  private MetaModel xptMetaModel;
  
  @Inject
  private getExpression xptGetExpression;
  
  @Inject
  private VisualIDRegistry xptVisualIDRegistry;
  
  @Inject
  private ElementTypes xptElementTypes;
  
  public CharSequence className(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    String _baseItemSemanticEditPolicyClassName = it.getBaseItemSemanticEditPolicyClassName();
    _builder.append(_baseItemSemanticEditPolicyClassName);
    return _builder;
  }
  
  public CharSequence packageName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    String _editPoliciesPackageName = it.getDiagram().getEditPoliciesPackageName();
    _builder.append(_editPoliciesPackageName);
    return _builder;
  }
  
  public CharSequence qualifiedClassName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence fullPath(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence BaseItemSemanticEditPolicy(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" extends org.eclipse.gmf.runtime.diagram.ui.editpolicies.SemanticEditPolicy {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _attributes = this.attributes(it);
    _builder.append(_attributes, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _constructor = this.constructor(it);
    _builder.append(_constructor, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment(
      (((("Extended request data key to hold editpart visual id.\n" + 
        "Add visual id of edited editpart to extended data of the request\n") + 
        "so command switch can decide what kind of diagram element is being edited.\n") + 
        "It is done in those cases when it\'s not possible to deduce diagram\n") + 
        "element kind from domain element.\n"));
    _builder.append(_generatedMemberComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public org.eclipse.gef.commands.Command getCommand(org.eclipse.gef.Request request) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (request instanceof org.eclipse.gef.requests.ReconnectRequest) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("Object view = ((org.eclipse.gef.requests.ReconnectRequest) request).getConnectionEditPart().getModel();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (view instanceof org.eclipse.gmf.runtime.notation.View) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("Integer id = new Integer(");
    CharSequence _visualIDMethodCall = this.xptVisualIDRegistry.getVisualIDMethodCall(it);
    _builder.append(_visualIDMethodCall, "\t\t\t\t");
    _builder.append("((org.eclipse.gmf.runtime.notation.View) view));");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("request.getExtendedData().put(VISUAL_ID_KEY, id);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return super.getCommand(request);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment("Returns visual id from request parameters.");
    _builder.append(_generatedMemberComment_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("protected int getVisualID(org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest request) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("Object id = request.getParameter(VISUAL_ID_KEY);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return id instanceof Integer ? ((Integer) id).intValue() : -1;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _semanticPart = this.semanticPart(it);
    _builder.append(_semanticPart, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment("Returns editing domain from the host edit part.");
    _builder.append(_generatedMemberComment_2, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("protected org.eclipse.emf.transaction.TransactionalEditingDomain getEditingDomain() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return ((org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart) getHost()).getEditingDomain();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _addDestroyShortcutsCommand = this.addDestroyShortcutsCommand(it);
    _builder.append(_addDestroyShortcutsCommand, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    {
      final Function1<GenLink, Boolean> _function = new Function1<GenLink, Boolean>() {
        @Override
        public Boolean apply(final GenLink link) {
          boolean _isSansDomain = link.isSansDomain();
          return Boolean.valueOf((!_isSansDomain));
        }
      };
      boolean _exists = IterableExtensions.<GenLink>exists(it.getLinks(), _function);
      if (_exists) {
        CharSequence _linkConstraints = this.linkConstraints(it);
        _builder.append(_linkConstraints);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("\t");
    CharSequence _additions = this.additions(it);
    _builder.append(_additions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence attributes(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment("Extended request data key to hold editpart visual id.");
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static final String VISUAL_ID_KEY = \"visual_id\"; ");
    CharSequence _nonNLS = this._common.nonNLS();
    _builder.append(_nonNLS);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1);
    _builder.newLineIfNotEmpty();
    _builder.append("private final org.eclipse.gmf.runtime.emf.type.core.IElementType myElementType;");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence constructor(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append("(org.eclipse.gmf.runtime.emf.type.core.IElementType elementType) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("myElementType = elementType;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence addDestroyShortcutsCommand(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment("Clean all shortcuts to the host element from the same diagram");
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void addDestroyShortcutsCommand(org.eclipse.gmf.runtime.common.core.command.ICompositeCommand cmd, org.eclipse.gmf.runtime.notation.View view) {");
    _builder.newLine();
    _builder.append("\t");
    CharSequence __assert = this._common._assert("view.getEAnnotation(\"Shortcut\") == null");
    _builder.append(__assert, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("for (java.util.Iterator it = view.getDiagram().getChildren().iterator(); it.hasNext();) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gmf.runtime.notation.View nextView = (org.eclipse.gmf.runtime.notation.View) it.next();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (nextView.getEAnnotation(\"Shortcut\") == null || !nextView.isSetElement() || nextView.getElement() != view.getElement()) { ");
    CharSequence _nonNLS = this._common.nonNLS();
    _builder.append(_nonNLS, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("continue;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("cmd.add(new org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand(getEditingDomain(), nextView));");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence semanticPart(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _semanticCommand = this.getSemanticCommand(it);
    _builder.append(_semanticCommand);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _addDeleteViewCommand = this.addDeleteViewCommand(it);
    _builder.append(_addDeleteViewCommand);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _editHelperCommand = this.getEditHelperCommand(it);
    _builder.append(_editHelperCommand);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _contextElementType = this.getContextElementType(it);
    _builder.append(_contextElementType);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _semanticCommandSwitch = this.getSemanticCommandSwitch(it);
    _builder.append(_semanticCommandSwitch);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _configureCommand = this.getConfigureCommand(it);
    _builder.append(_configureCommand);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _createRelationshipCommand = this.getCreateRelationshipCommand(it);
    _builder.append(_createRelationshipCommand);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _createCommand = this.getCreateCommand(it);
    _builder.append(_createCommand);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _setCommand = this.getSetCommand(it);
    _builder.append(_setCommand);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _editContextCommand = this.getEditContextCommand(it);
    _builder.append(_editContextCommand);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _destroyElementCommand = this.getDestroyElementCommand(it);
    _builder.append(_destroyElementCommand);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _destroyReferenceCommand = this.getDestroyReferenceCommand(it);
    _builder.append(_destroyReferenceCommand);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _duplicateCommand = this.getDuplicateCommand(it);
    _builder.append(_duplicateCommand);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _moveCommand = this.getMoveCommand(it);
    _builder.append(_moveCommand);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _reorientReferenceRelationshipCommand = this.getReorientReferenceRelationshipCommand(it);
    _builder.append(_reorientReferenceRelationshipCommand);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _reorientRelationshipCommand = this.getReorientRelationshipCommand(it);
    _builder.append(_reorientRelationshipCommand);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _gEFWrapper = this.getGEFWrapper(it);
    _builder.append(_gEFWrapper);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence getEditHelperCommand(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private org.eclipse.gef.commands.Command getEditHelperCommand(org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest request, org.eclipse.gef.commands.Command editPolicyCommand) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (editPolicyCommand != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gmf.runtime.common.core.command.ICommand command = editPolicyCommand instanceof org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy ? ((org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy) editPolicyCommand).getICommand() : new org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy(editPolicyCommand);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("request.setParameter(");
    CharSequence _editPolicyCommandConstant = this.xptBaseEditHelper.editPolicyCommandConstant(it);
    _builder.append(_editPolicyCommandConstant, "\t\t");
    _builder.append(", command);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.emf.type.core.IElementType requestContextElementType = getContextElementType(request);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("request.setParameter(");
    CharSequence _contextElementTypeConstant = this.xptBaseEditHelper.contextElementTypeConstant(it);
    _builder.append(_contextElementTypeConstant, "\t");
    _builder.append(", requestContextElementType);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.common.core.command.ICommand command = requestContextElementType.getEditCommand(request);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("request.setParameter(");
    CharSequence _editPolicyCommandConstant_1 = this.xptBaseEditHelper.editPolicyCommandConstant(it);
    _builder.append(_editPolicyCommandConstant_1, "\t");
    _builder.append(", null);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("request.setParameter(");
    CharSequence _contextElementTypeConstant_1 = this.xptBaseEditHelper.contextElementTypeConstant(it);
    _builder.append(_contextElementTypeConstant_1, "\t");
    _builder.append(", null);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("if (command != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (!(command instanceof org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand)) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("command = new org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand(getEditingDomain(), command.getLabel()).compose(command);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return new org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy(command);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return editPolicyCommand;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getContextElementType(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private org.eclipse.gmf.runtime.emf.type.core.IElementType getContextElementType(org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest request) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.emf.type.core.IElementType requestContextElementType = ");
    CharSequence _qualifiedClassName = this.xptElementTypes.qualifiedClassName(it);
    _builder.append(_qualifiedClassName, "\t");
    _builder.append(".getElementType(getVisualID(request));");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return requestContextElementType != null ? requestContextElementType : myElementType;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getSemanticCommand(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gef.commands.Command getSemanticCommand(org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest request) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest completedRequest = completeRequest(request);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gef.commands.Command semanticCommand = getSemanticCommandSwitch(completedRequest);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("semanticCommand = getEditHelperCommand(completedRequest, semanticCommand);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (completedRequest instanceof org.eclipse.gmf.runtime.emf.type.core.requests.DestroyRequest) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gmf.runtime.emf.type.core.requests.DestroyRequest destroyRequest = (org.eclipse.gmf.runtime.emf.type.core.requests.DestroyRequest) completedRequest;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return shouldProceed(destroyRequest) ? addDeleteViewCommand(semanticCommand, destroyRequest) : null;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return semanticCommand;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence addDeleteViewCommand(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gef.commands.Command addDeleteViewCommand(org.eclipse.gef.commands.Command mainCommand, org.eclipse.gmf.runtime.emf.type.core.requests.DestroyRequest completedRequest){");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gef.commands.Command deleteViewCommand = getGEFWrapper(new org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand(getEditingDomain(), (org.eclipse.gmf.runtime.notation.View) getHost().getModel()));");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return mainCommand == null ? deleteViewCommand : mainCommand.chain(deleteViewCommand);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getSemanticCommandSwitch(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gef.commands.Command getSemanticCommandSwitch(org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest req) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (req instanceof org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return getCreateRelationshipCommand((org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest) req);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} else if (req instanceof org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return getCreateCommand((org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest) req);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} else if (req instanceof org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return getConfigureCommand((org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest) req);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} else if (req instanceof org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return getDestroyElementCommand((org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest) req);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} else if (req instanceof org.eclipse.gmf.runtime.emf.type.core.requests.DestroyReferenceRequest) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return getDestroyReferenceCommand((org.eclipse.gmf.runtime.emf.type.core.requests.DestroyReferenceRequest) req);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} else if (req instanceof org.eclipse.gmf.runtime.emf.type.core.requests.DuplicateElementsRequest) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return getDuplicateCommand((org.eclipse.gmf.runtime.emf.type.core.requests.DuplicateElementsRequest) req);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} else if (req instanceof org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return getEditContextCommand((org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest) req);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} else if (req instanceof org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return getMoveCommand((org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest) req);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} else if (req instanceof org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return getReorientReferenceRelationshipCommand((org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest) req);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} else if (req instanceof org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return getReorientRelationshipCommand((org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest) req);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} else if (req instanceof org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return getSetCommand((org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest) req);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getConfigureCommand(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gef.commands.Command getConfigureCommand(org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest req) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getCreateRelationshipCommand(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gef.commands.Command getCreateRelationshipCommand(org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest req) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getCreateCommand(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gef.commands.Command getCreateCommand(org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest req) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getSetCommand(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gef.commands.Command getSetCommand(org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest req) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getEditContextCommand(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gef.commands.Command getEditContextCommand(org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest req) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getDestroyElementCommand(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gef.commands.Command getDestroyElementCommand(org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest req) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getDestroyReferenceCommand(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gef.commands.Command getDestroyReferenceCommand(org.eclipse.gmf.runtime.emf.type.core.requests.DestroyReferenceRequest req) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getDuplicateCommand(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gef.commands.Command getDuplicateCommand(org.eclipse.gmf.runtime.emf.type.core.requests.DuplicateElementsRequest req) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getMoveCommand(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gef.commands.Command getMoveCommand(org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest req) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getReorientReferenceRelationshipCommand(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gef.commands.Command getReorientReferenceRelationshipCommand(org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest req) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getReorientRelationshipCommand(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gef.commands.Command getReorientRelationshipCommand(org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest req) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getGEFWrapper(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected final org.eclipse.gef.commands.Command getGEFWrapper(org.eclipse.gmf.runtime.common.core.command.ICommand cmd) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return new org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy(cmd);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  /**
   * FIXME need to check constraint's provider to ensure we don't generate a field
   * 		for e.g. Java (or Literal, which is unlikely, though) expressions
   */
  public CharSequence linkConstraints(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public static ");
    String _linkCreationConstraintsClassName = it.getLinkCreationConstraintsClassName();
    _builder.append(_linkCreationConstraintsClassName, "\t");
    _builder.append(" getLinkConstraints() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    String _linkCreationConstraintsClassName_1 = it.getLinkCreationConstraintsClassName();
    _builder.append(_linkCreationConstraintsClassName_1, "\t\t");
    _builder.append(" cached = ");
    CharSequence _instanceAccess = this.xptPluginActivator.instanceAccess(it.getEditorGen());
    _builder.append(_instanceAccess, "\t\t");
    _builder.append(".getLinkConstraints();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("if (cached == null) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    CharSequence _instanceAccess_1 = this.xptPluginActivator.instanceAccess(it.getEditorGen());
    _builder.append(_instanceAccess_1, "\t\t\t");
    _builder.append(".setLinkConstraints(cached = new ");
    String _linkCreationConstraintsClassName_2 = it.getLinkCreationConstraintsClassName();
    _builder.append(_linkCreationConstraintsClassName_2, "\t\t\t");
    _builder.append("());");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return cached;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static class ");
    String _linkCreationConstraintsClassName_3 = it.getLinkCreationConstraintsClassName();
    _builder.append(_linkCreationConstraintsClassName_3);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    String _linkCreationConstraintsClassName_4 = it.getLinkCreationConstraintsClassName();
    _builder.append(_linkCreationConstraintsClassName_4, "\t");
    _builder.append("() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("// use static method #getLinkConstraints() to access instance");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    {
      EList<GenLink> _links = it.getLinks();
      for(final GenLink nextLink : _links) {
        _builder.append("\t");
        CharSequence _canCreate = this.canCreate(nextLink);
        _builder.append(_canCreate, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    {
      EList<GenLink> _links_1 = it.getLinks();
      for(final GenLink nextLink_1 : _links_1) {
        _builder.append("\t");
        CharSequence _canExist = this.canExist(nextLink_1);
        _builder.append(_canExist, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence canCreate(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public boolean canCreate");
    String _uniqueIdentifier = it.getUniqueIdentifier();
    _builder.append(_uniqueIdentifier);
    _builder.append("(");
    CharSequence _canCreateParameters = this.canCreateParameters(it.getModelFacet());
    _builder.append(_canCreateParameters);
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _checkEMFConstraints = this.checkEMFConstraints(it.getModelFacet());
    _builder.append(_checkEMFConstraints, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return canExist");
    String _uniqueIdentifier_1 = it.getUniqueIdentifier();
    _builder.append(_uniqueIdentifier_1, "\t");
    _builder.append("(");
    CharSequence _canCreateValues = this.canCreateValues(it.getModelFacet());
    _builder.append(_canCreateValues, "\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    return _builder;
  }
  
  /**
   * XXX for now, both constraints are injected into single method
   * 			which may not be suitable for modification especially when mixing
   * 			java and ocl constraints (former requires manual code).
   * 		Better approach would be:
   * 			if either is non-null and providers are not the same - introduce two methods,
   * 			to check source and target separately. Otherwize, do it inplace.
   */
  public CharSequence canExist(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public boolean canExist");
    String _uniqueIdentifier = it.getUniqueIdentifier();
    _builder.append(_uniqueIdentifier);
    _builder.append("(");
    CharSequence _canExistParameters = this.canExistParameters(it.getModelFacet());
    _builder.append(_canExistParameters);
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    {
      if ((((!Objects.equal(it.getCreationConstraints(), null)) && it.getCreationConstraints().isValid()) && (!Objects.equal(it.getDiagram().getEditorGen().getExpressionProviders(), null)))) {
        _builder.append("\t");
        _builder.append("try {");
        _builder.newLine();
        {
          GenConstraint _sourceEnd = it.getCreationConstraints().getSourceEnd();
          boolean _notEquals = (!Objects.equal(_sourceEnd, null));
          if (_notEquals) {
            CharSequence _checkAdditionalConstraint = this.checkAdditionalConstraint(it.getCreationConstraints().getSourceEnd().getProvider(), it.getCreationConstraints().getSourceEnd(), "source", "target", it.getCreationConstraints().getSourceEndContextClass(), it.getCreationConstraints().getTargetEndContextClass());
            _builder.append(_checkAdditionalConstraint);
            _builder.newLineIfNotEmpty();
          }
        }
        {
          GenConstraint _targetEnd = it.getCreationConstraints().getTargetEnd();
          boolean _notEquals_1 = (!Objects.equal(_targetEnd, null));
          if (_notEquals_1) {
            CharSequence _checkAdditionalConstraint_1 = this.checkAdditionalConstraint(it.getCreationConstraints().getTargetEnd().getProvider(), it.getCreationConstraints().getTargetEnd(), "target", "source", it.getCreationConstraints().getTargetEndContextClass(), it.getCreationConstraints().getSourceEndContextClass());
            _builder.append(_checkAdditionalConstraint_1);
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t\t");
        _builder.append("return true;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("} catch(Exception e) {\t");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _instanceAccess = this.xptPluginActivator.instanceAccess(it.getDiagram().getEditorGen());
        _builder.append(_instanceAccess, "\t\t");
        _builder.append(".logError(\"Link constraint evaluation error\", e); ");
        CharSequence _nonNLS = this._common.nonNLS();
        _builder.append(_nonNLS, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      } else {
        _builder.append("return true;");
        _builder.newLine();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  /**
   * FIXME XXX mark as private (_) and move to impl::<find proper place>::LinkConstraints.xpt
   */
  protected CharSequence _canCreateParameters(final LinkModelFacet it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _sourceTargetParameters = this.sourceTargetParameters(it);
    _builder.append(_sourceTargetParameters);
    return _builder;
  }
  
  protected CharSequence _canCreateParameters(final TypeLinkModelFacet it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _hasContainerOtherThanSource = this._utils_qvto.hasContainerOtherThanSource(it);
      if (_hasContainerOtherThanSource) {
        CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName(it.getContainmentMetaFeature().getGenClass());
        _builder.append(_QualifiedClassName);
        _builder.append(" container, ");
      }
    }
    CharSequence _sourceTargetParameters = this.sourceTargetParameters(it);
    _builder.append(_sourceTargetParameters);
    return _builder;
  }
  
  protected CharSequence _canExistParameters(final LinkModelFacet it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _sourceTargetParameters = this.sourceTargetParameters(it);
    _builder.append(_sourceTargetParameters);
    return _builder;
  }
  
  protected CharSequence _canExistParameters(final TypeLinkModelFacet it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _hasContainerOtherThanSource = this._utils_qvto.hasContainerOtherThanSource(it);
      if (_hasContainerOtherThanSource) {
        CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName(it.getContainmentMetaFeature().getGenClass());
        _builder.append(_QualifiedClassName);
        _builder.append(" container, ");
      }
    }
    CharSequence _QualifiedClassName_1 = this.xptMetaModel.QualifiedClassName(it.getMetaClass());
    _builder.append(_QualifiedClassName_1);
    _builder.append(" linkInstance, ");
    CharSequence _sourceTargetParameters = this.sourceTargetParameters(it);
    _builder.append(_sourceTargetParameters);
    return _builder;
  }
  
  public CharSequence sourceTargetParameters(final LinkModelFacet it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName(it.getSourceType());
    _builder.append(_QualifiedClassName);
    _builder.append(" source, ");
    CharSequence _QualifiedClassName_1 = this.xptMetaModel.QualifiedClassName(it.getTargetType());
    _builder.append(_QualifiedClassName_1);
    _builder.append(" target");
    return _builder;
  }
  
  protected CharSequence _canCreateValues(final LinkModelFacet it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("source, target");
    return _builder;
  }
  
  protected CharSequence _canCreateValues(final TypeLinkModelFacet it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _hasContainerOtherThanSource = this._utils_qvto.hasContainerOtherThanSource(it);
      if (_hasContainerOtherThanSource) {
        _builder.append("container, ");
      }
    }
    _builder.append("null, source, target");
    return _builder;
  }
  
  protected CharSequence _checkEMFConstraints(final LinkModelFacet it) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR(("Unrecognized link model facet in checkEMFConstraints: " + it));
    return _builder;
  }
  
  /**
   * [MG] extracted from LET statement, @see checkEMFConstraints(TypeLinkModelFacet)
   */
  private boolean checkChildFeatureBounds(final TypeLinkModelFacet it) {
    return ((!Objects.equal(it.getChildMetaFeature(), it.getContainmentMetaFeature())) && (!this._oclMigrationProblems_qvto.isUnbounded(it.getChildMetaFeature().getEcoreFeature())));
  }
  
  protected CharSequence _checkEMFConstraints(final TypeLinkModelFacet it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if (((!this._oclMigrationProblems_qvto.isUnbounded(it.getContainmentMetaFeature().getEcoreFeature())) || this.checkChildFeatureBounds(it))) {
        _builder.append("if (");
        String _containerVariable = this._utils_qvto_1.getContainerVariable(it);
        _builder.append(_containerVariable);
        _builder.append(" != null) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        CharSequence _checkEMFConstraints = this.checkEMFConstraints(it.getContainmentMetaFeature(), it);
        _builder.append(_checkEMFConstraints, "\t\t");
        _builder.newLineIfNotEmpty();
        {
          boolean _checkChildFeatureBounds = this.checkChildFeatureBounds(it);
          if (_checkChildFeatureBounds) {
            _builder.append("\t\t");
            CharSequence _checkEMFConstraints_1 = this.checkEMFConstraints(it.getChildMetaFeature(), it);
            _builder.append(_checkEMFConstraints_1, "\t\t");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  public CharSequence checkEMFConstraints(final GenFeature it, final TypeLinkModelFacet modelFacet) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isUnbounded = this._oclMigrationProblems_qvto.isUnbounded(it.getEcoreFeature());
      boolean _not = (!_isUnbounded);
      if (_not) {
        _builder.append("if (");
        CharSequence _featureBoundComparator = this.featureBoundComparator(it, this._utils_qvto_1.getContainerVariable(modelFacet), modelFacet.getSourceType());
        _builder.append(_featureBoundComparator);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  protected CharSequence _checkEMFConstraints(final FeatureLinkModelFacet it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("if (source != null) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (");
    CharSequence _featureBoundsConditionClause = this.featureBoundsConditionClause(it.getMetaFeature(), "source", it.getSourceType());
    _builder.append(_featureBoundsConditionClause, "\t");
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    {
      boolean _isContains = it.getMetaFeature().isContains();
      if (_isContains) {
        _builder.append("\t");
        _builder.append("if (source == target) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("}");
    _builder.newLine();
    {
      GenFeature _reverse = it.getMetaFeature().getReverse();
      boolean _notEquals = (!Objects.equal(_reverse, null));
      if (_notEquals) {
        _builder.append("if (target != null && (");
        CharSequence _featureBoundsConditionClause_1 = this.featureBoundsConditionClause(it.getMetaFeature().getReverse(), "target", it.getTargetType());
        _builder.append(_featureBoundsConditionClause_1);
        _builder.append(")) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    CharSequence _extraLineBreak = this._common.extraLineBreak();
    _builder.append(_extraLineBreak);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence featureBoundsConditionClause(final GenFeature it, final String targetVar, final GenClass targetType) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isUnbounded = this._oclMigrationProblems_qvto.isUnbounded(it.getEcoreFeature());
      boolean _not = (!_isUnbounded);
      if (_not) {
        CharSequence _featureBoundComparator = this.featureBoundComparator(it, targetVar, targetType);
        _builder.append(_featureBoundComparator);
      }
    }
    _builder.newLineIfNotEmpty();
    {
      if (((!this._oclMigrationProblems_qvto.isSingleValued(it.getEcoreFeature())) && (!this._oclMigrationProblems_qvto.isUnbounded(it.getEcoreFeature())))) {
        _builder.append(" || ");
      }
    }
    _builder.newLineIfNotEmpty();
    {
      boolean _isSingleValued = this._oclMigrationProblems_qvto.isSingleValued(it.getEcoreFeature());
      boolean _not_1 = (!_isSingleValued);
      if (_not_1) {
        CharSequence _featureUniquenessComparator = this.featureUniquenessComparator(it, targetVar, targetType);
        _builder.append(_featureUniquenessComparator);
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence featureBoundComparator(final GenFeature it, final String featureVar, final GenClass featureVarGenClass) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _featureValue = this.xptMetaModel.getFeatureValue(it, featureVar, featureVarGenClass);
    _builder.append(_featureValue);
    {
      boolean _isSingleValued = this._oclMigrationProblems_qvto.isSingleValued(it.getEcoreFeature());
      if (_isSingleValued) {
        _builder.append(" != null");
      } else {
        _builder.append(".size() >= ");
        int _upperBound = it.getEcoreFeature().getUpperBound();
        _builder.append(_upperBound);
      }
    }
    return _builder;
  }
  
  public CharSequence featureUniquenessComparator(final GenFeature it, final String featureVar, final GenClass featureVarGenClass) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _featureValue = this.xptMetaModel.getFeatureValue(it, featureVar, featureVarGenClass);
    _builder.append(_featureValue);
    _builder.append(".contains(target)");
    return _builder;
  }
  
  protected CharSequence _checkAdditionalConstraint(final GenExpressionProviderBase it, final ValueExpression valueExpr, final String sourceEndVar, final String targetEndVar, final GenClass context, final GenClass oppositeEndContext) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR(("Have no idea what extra constraints to check for " + it));
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _checkAdditionalConstraint(final GenExpressionInterpreter it, final ValueExpression valueExpr, final String sourceEndVar, final String targetEndVar, final GenClass context, final GenClass oppositeEndContext) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("if (");
    _builder.append(sourceEndVar);
    _builder.append(" == null) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return true;");
    _builder.newLine();
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("java.util.Map<String, org.eclipse.emf.ecore.EClassifier> env = java.util.Collections.<String, org.eclipse.emf.ecore.EClassifier>singletonMap(");
    CharSequence _oppositeEndVariableNameValue = this.oppositeEndVariableNameValue(it);
    _builder.append(_oppositeEndVariableNameValue, "\t");
    _builder.append(", ");
    CharSequence _MetaClass = this.xptMetaModel.MetaClass(oppositeEndContext);
    _builder.append(_MetaClass, "\t");
    _builder.append("); ");
    CharSequence _nonNLS = this._common.nonNLS();
    _builder.append(_nonNLS, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("Object ");
    _builder.append(sourceEndVar, "\t");
    _builder.append("Val = ");
    CharSequence _expression = this.xptGetExpression.getExpression(it, valueExpr, context, "env");
    _builder.append(_expression, "\t");
    _builder.append(".evaluate(");
    _builder.append(sourceEndVar, "\t");
    _builder.append(", java.util.Collections.singletonMap(");
    CharSequence _oppositeEndVariableNameValue_1 = this.oppositeEndVariableNameValue(it);
    _builder.append(_oppositeEndVariableNameValue_1, "\t");
    _builder.append(", ");
    _builder.append(targetEndVar, "\t");
    _builder.append(")); ");
    CharSequence _nonNLS_1 = this._common.nonNLS();
    _builder.append(_nonNLS_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("if (false == ");
    _builder.append(sourceEndVar, "\t");
    _builder.append("Val instanceof Boolean || !((Boolean) ");
    _builder.append(sourceEndVar, "\t");
    _builder.append("Val).booleanValue()) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} // else fall-through");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _checkAdditionalConstraint(final GenJavaExpressionProvider it, final ValueExpression valueExpr, final String sourceEndVar, final String targetEndVar, final GenClass context, final GenClass oppositeEndContext) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if (((it.isInjectExpressionBody() && (!Objects.equal(valueExpr.getBody(), null))) && (!valueExpr.getBody().isEmpty()))) {
        String _body = valueExpr.getBody();
        _builder.append(_body);
        _builder.newLineIfNotEmpty();
      } else {
        if ((it.isThrowException() || (it.isInjectExpressionBody() && (Objects.equal(valueExpr.getBody(), null) || valueExpr.getBody().isEmpty())))) {
          _builder.append("// TODO: implement this method, using ");
          _builder.append(sourceEndVar);
          _builder.append(" and ");
          _builder.append(targetEndVar);
          _builder.append(" ");
          _builder.newLineIfNotEmpty();
          _builder.append("// to access link source and target, respectively");
          _builder.newLine();
          _builder.append("// Ensure that you remove @generated or mark it @generated NOT");
          _builder.newLine();
          _builder.append("if (Boolean.TRUE.booleanValue()) {");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("throw new java.lang.UnsupportedOperationException(\"No java implementation provided\"); ");
          CharSequence _nonNLS = this._common.nonNLS();
          _builder.append(_nonNLS, "\t");
          _builder.newLineIfNotEmpty();
          _builder.append("}");
          _builder.newLine();
        } else {
          _builder.append("if (Boolean.TRUE.booleanValue()) {");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("return false;");
          _builder.newLine();
          _builder.append("}");
          _builder.newLine();
        }
      }
    }
    return _builder;
  }
  
  @MetaDef
  public CharSequence canExistCall(final FeatureLinkModelFacet xptSelf, final GenLink link, final String sourceVar, final String targetVar) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence __accessLinkConstraints = this._accessLinkConstraints(link.getDiagram());
    _builder.append(__accessLinkConstraints);
    _builder.append(".canExist");
    String _uniqueIdentifier = link.getUniqueIdentifier();
    _builder.append(_uniqueIdentifier);
    _builder.append("(");
    _builder.append(sourceVar);
    _builder.append(", ");
    _builder.append(targetVar);
    _builder.append(")");
    return _builder;
  }
  
  /**
   * NOTE, containerVar will be used only when link has other container than its source. It's safe to pass variable/method name that doesn't exist
   */
  @MetaDef
  public CharSequence canExistCall(final TypeLinkModelFacet xptSelf, final GenLink link, final String containerVar, final String linkVar, final String sourceVar, final String targetVar) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence __accessLinkConstraints = this._accessLinkConstraints(link.getDiagram());
    _builder.append(__accessLinkConstraints);
    _builder.append(".canExist");
    String _uniqueIdentifier = link.getUniqueIdentifier();
    _builder.append(_uniqueIdentifier);
    _builder.append("(");
    {
      boolean _hasContainerOtherThanSource = this._utils_qvto.hasContainerOtherThanSource(xptSelf);
      if (_hasContainerOtherThanSource) {
        _builder.append(containerVar);
        _builder.append(", ");
      }
    }
    _builder.append(linkVar);
    _builder.append(", ");
    _builder.append(sourceVar);
    _builder.append(", ");
    _builder.append(targetVar);
    _builder.append(")");
    return _builder;
  }
  
  @MetaDef
  public CharSequence canCreateCall(final FeatureLinkModelFacet xptSelf, final GenLink link, final String sourceVar, final String targetVar) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence __accessLinkConstraints = this._accessLinkConstraints(link.getDiagram());
    _builder.append(__accessLinkConstraints);
    _builder.append(".canCreate");
    String _uniqueIdentifier = link.getUniqueIdentifier();
    _builder.append(_uniqueIdentifier);
    _builder.append("(");
    _builder.append(sourceVar);
    _builder.append(", ");
    _builder.append(targetVar);
    _builder.append(")");
    return _builder;
  }
  
  /**
   * NOTE, containerVar will be used only when link has other container than its source. It's safe to pass variable/method name that doesn't exist
   * Yes, this is sorta hack, but no idea of better approach right now. Perhaps, CreateLinkUtils may always define getContainer() for TypeLinkModelFacet, and use getSource() by default?
   */
  @MetaDef
  public CharSequence canCreateCall(final TypeLinkModelFacet xptSelf, final GenLink link, final String containerVar, final String sourceVar, final String targetVar) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence __accessLinkConstraints = this._accessLinkConstraints(link.getDiagram());
    _builder.append(__accessLinkConstraints);
    _builder.append(".canCreate");
    String _uniqueIdentifier = link.getUniqueIdentifier();
    _builder.append(_uniqueIdentifier);
    _builder.append("(");
    {
      boolean _hasContainerOtherThanSource = this._utils_qvto.hasContainerOtherThanSource(xptSelf);
      if (_hasContainerOtherThanSource) {
        _builder.append(containerVar);
        _builder.append(", ");
      }
    }
    _builder.append(sourceVar);
    _builder.append(", ");
    _builder.append(targetVar);
    _builder.append(")");
    return _builder;
  }
  
  @MetaDef
  private CharSequence _accessLinkConstraints(final GenDiagram xptSelf) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(xptSelf);
    _builder.append(_qualifiedClassName);
    _builder.append(".getLinkConstraints()");
    return _builder;
  }
  
  public CharSequence oppositeEndVariableNameValue(final Object any) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\"oppositeEnd\"");
    return _builder;
  }
  
  public CharSequence additions(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  public Object defaultConstructor(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public ");
    CharSequence _itemSemanticEditPolicyClassName = this._qualifiedClassNameProvider.getItemSemanticEditPolicyClassName(it);
    _builder.append(_itemSemanticEditPolicyClassName);
    _builder.append("() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _defaultConstructorBody = this.defaultConstructorBody(it);
    _builder.append(_defaultConstructorBody, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  /**
   * @param genCommon diagram, node or link, which MUST have an element type (genCommon.elementType != null)
   */
  public CharSequence defaultConstructorBody(final GenCommonBase genCommon) {
    StringConcatenation _builder = new StringConcatenation();
    {
      ElementType _elementType = genCommon.getElementType();
      boolean _equals = Objects.equal(_elementType, null);
      if (_equals) {
        this._common_qvto.ERROR(("No element type in the passed node. Only diagram, node or link are supported in this template: " + genCommon));
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("super(");
    CharSequence _accessElementType = this.xptElementTypes.accessElementType(genCommon);
    _builder.append(_accessElementType);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence canCreateParameters(final LinkModelFacet it) {
    if (it instanceof TypeLinkModelFacet) {
      return _canCreateParameters((TypeLinkModelFacet)it);
    } else if (it != null) {
      return _canCreateParameters(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
  
  public CharSequence canExistParameters(final LinkModelFacet it) {
    if (it instanceof TypeLinkModelFacet) {
      return _canExistParameters((TypeLinkModelFacet)it);
    } else if (it != null) {
      return _canExistParameters(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
  
  public CharSequence canCreateValues(final LinkModelFacet it) {
    if (it instanceof TypeLinkModelFacet) {
      return _canCreateValues((TypeLinkModelFacet)it);
    } else if (it != null) {
      return _canCreateValues(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
  
  public CharSequence checkEMFConstraints(final LinkModelFacet it) {
    if (it instanceof FeatureLinkModelFacet) {
      return _checkEMFConstraints((FeatureLinkModelFacet)it);
    } else if (it instanceof TypeLinkModelFacet) {
      return _checkEMFConstraints((TypeLinkModelFacet)it);
    } else if (it != null) {
      return _checkEMFConstraints(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
  
  public CharSequence checkAdditionalConstraint(final GenExpressionProviderBase it, final ValueExpression valueExpr, final String sourceEndVar, final String targetEndVar, final GenClass context, final GenClass oppositeEndContext) {
    if (it instanceof GenExpressionInterpreter) {
      return _checkAdditionalConstraint((GenExpressionInterpreter)it, valueExpr, sourceEndVar, targetEndVar, context, oppositeEndContext);
    } else if (it instanceof GenJavaExpressionProvider) {
      return _checkAdditionalConstraint((GenJavaExpressionProvider)it, valueExpr, sourceEndVar, targetEndVar, context, oppositeEndContext);
    } else if (it != null) {
      return _checkAdditionalConstraint(it, valueExpr, sourceEndVar, targetEndVar, context, oppositeEndContext);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, valueExpr, sourceEndVar, targetEndVar, context, oppositeEndContext).toString());
    }
  }
}
