/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.graphdef.codegen;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.papyrus.gmf.common.UnexpectedBehaviourException;
import org.eclipse.papyrus.gmf.gmfgraph.Figure;
import org.eclipse.papyrus.gmf.gmfgraph.FigureDescriptor;
import org.eclipse.papyrus.gmf.graphdef.codegen.MapModeCodeGenStrategy;
import org.eclipse.papyrus.gmf.internal.common.codegen.TextEmitter;
import org.eclipse.papyrus.gmf.internal.graphdef.codegen.Activator;
import org.eclipse.papyrus.gmf.internal.xpand.BufferOutput;
import org.eclipse.papyrus.gmf.internal.xpand.ResourceManager;
import org.eclipse.papyrus.gmf.internal.xpand.XpandFacade;
import org.eclipse.papyrus.gmf.internal.xpand.model.AmbiguousDefinitionException;
import org.eclipse.papyrus.gmf.internal.xpand.model.EvaluationException;
import org.eclipse.papyrus.gmf.internal.xpand.model.Output;
import org.eclipse.papyrus.gmf.internal.xpand.model.Scope;
import org.eclipse.papyrus.gmf.internal.xpand.model.Variable;

public class FigureGenerator
implements TextEmitter {
    private static final String VAR_MM_ACCESS = "mapModeAccessor";
    private static final String VAR_RT_TOKEN = "runtimeToken";
    private final ResourceManager resourceManager;
    private final StringBuilder result = new StringBuilder();
    private final ArrayList<Variable> globals = new ArrayList();
    private final boolean myIsInnerClassCode;
    private String packageStatement;

    public FigureGenerator(String runtimeToken, String packageStmt, boolean asInnerClass) {
        this(runtimeToken, packageStmt, MapModeCodeGenStrategy.DYNAMIC, "getMapMode().", asInnerClass);
    }

    public FigureGenerator(String runtimeToken, String packageStmt, MapModeCodeGenStrategy mapModeStrategy, String mapModeAccessor, boolean asInnerClass) {
        this(runtimeToken, packageStmt, mapModeStrategy, mapModeAccessor, asInnerClass, null);
    }

    public FigureGenerator(String runtimeToken, String packageStmt, MapModeCodeGenStrategy mapModeStrategy, String mapModeAccessor, boolean asInnerClass, URL[] dynamicTemplates) {
        this.myIsInnerClassCode = asInnerClass;
        this.packageStatement = packageStmt;
        if (mapModeStrategy == MapModeCodeGenStrategy.STATIC && mapModeAccessor != null && mapModeAccessor.trim().length() > 0) {
            throw new IllegalArgumentException("Can't use map mode accessor with identity map mode");
        }
        if (mapModeStrategy == MapModeCodeGenStrategy.DYNAMIC) {
            this.globals.add(new Variable(VAR_MM_ACCESS, (EClassifier)EcorePackage.eINSTANCE.getEString(), (Object)(mapModeAccessor == null ? "" : mapModeAccessor)));
        }
        if (runtimeToken != null) {
            this.globals.add(new Variable(VAR_RT_TOKEN, (EClassifier)EcorePackage.eINSTANCE.getEString(), (Object)runtimeToken));
        }
        this.resourceManager = Activator.createResourceEngine(mapModeStrategy, dynamicTemplates);
    }

    public String getPackageName() {
        return this.packageStatement;
    }

    public String fqnSwitch(Figure figure) {
        try {
            this.xpandFacade().evaluate("Runtime::fqn", (Object)figure, null);
        }
        catch (AmbiguousDefinitionException e) {
            throw new EvaluationException(e);
        }
        return this.result.toString();
    }

    public String go(FigureDescriptor figure) {
        try {
            if (this.myIsInnerClassCode) {
                this.xpandFacade().evaluate("top::Descriptor::Inner", (Object)figure, null);
            } else {
                this.xpandFacade().evaluate("top::Descriptor::Top", (Object)figure, new Object[]{this.packageStatement});
            }
        }
        catch (AmbiguousDefinitionException e) {
            throw new EvaluationException(e);
        }
        return this.result.toString();
    }

    private XpandFacade xpandFacade() {
        this.result.setLength(0);
        BufferOutput bufferOutput = new BufferOutput(this.result);
        return new XpandFacade(new Scope(this.resourceManager, this.globals, (Output)bufferOutput));
    }

    public String generate(IProgressMonitor monitor, Object[] arguments) throws InterruptedException, InvocationTargetException, UnexpectedBehaviourException {
        if (arguments == null || arguments.length != 1 || !(arguments[0] instanceof FigureDescriptor)) {
            throw new UnexpectedBehaviourException("(FigureDescriptor) expected as arguments, not " + arguments);
        }
        return this.go((FigureDescriptor)arguments[0]);
    }
}

