/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.xpand;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.TypeResolver;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.papyrus.gmf.internal.xpand.model.ExecutionContext;
import org.eclipse.papyrus.gmf.internal.xpand.model.XpandDefinitionWrap;
import org.eclipse.papyrus.gmf.internal.xpand.model.XpandIterator;

public class BuiltinMetaModel {
    public static final String SET = "Set";
    public static final String LIST = "List";
    private static EPackage XECORE = EcoreFactory.eINSTANCE.createEPackage();
    public static final EClass DEFINITION_TYPE;
    public static final EClass ITERATOR_TYPE;

    static {
        XECORE.setName("xecore");
        XECORE.setNsPrefix("xecore");
        XECORE.setNsURI("uri:org.eclipse.modeling/m2t/xpand/xecore/1.0");
        DEFINITION_TYPE = EcoreFactory.eINSTANCE.createEClass();
        DEFINITION_TYPE.setName("xpand2::Definition");
        DEFINITION_TYPE.getESuperTypes().add((Object)EcorePackage.eINSTANCE.getEClass());
        EOperation proceedOp = EcoreFactory.eINSTANCE.createEOperation();
        proceedOp.setName("proceed");
        proceedOp.setEType((EClassifier)EcorePackage.eINSTANCE.getEObject());
        DEFINITION_TYPE.setInstanceClass(XpandDefinitionWrap.class);
        DEFINITION_TYPE.getEOperations().add((Object)proceedOp);
        XECORE.getEClassifiers().add((Object)DEFINITION_TYPE);
        ITERATOR_TYPE = EcoreFactory.eINSTANCE.createEClass();
        ITERATOR_TYPE.setName("xpand2::Iterator");
        ITERATOR_TYPE.getESuperTypes().add((Object)EcorePackage.eINSTANCE.getEClass());
        EOperation isFirstIteration = EcoreFactory.eINSTANCE.createEOperation();
        isFirstIteration.setName("isFirstIteration");
        isFirstIteration.setEType((EClassifier)EcorePackage.eINSTANCE.getEBoolean());
        EOperation isLastIteration = EcoreFactory.eINSTANCE.createEOperation();
        isLastIteration.setName("isLastIteration");
        isLastIteration.setEType((EClassifier)EcorePackage.eINSTANCE.getEBoolean());
        EOperation counter = EcoreFactory.eINSTANCE.createEOperation();
        counter.setName("counter");
        counter.setEType((EClassifier)EcorePackage.eINSTANCE.getELong());
        EOperation elements = EcoreFactory.eINSTANCE.createEOperation();
        elements.setName("elements");
        elements.setEType((EClassifier)EcorePackage.eINSTANCE.getELong());
        EOperation counter1 = EcoreFactory.eINSTANCE.createEOperation();
        counter1.setName("counter1");
        counter1.setEType((EClassifier)EcorePackage.eINSTANCE.getELong());
        ITERATOR_TYPE.getEOperations().add((Object)isFirstIteration);
        ITERATOR_TYPE.getEOperations().add((Object)isLastIteration);
        ITERATOR_TYPE.getEOperations().add((Object)counter);
        ITERATOR_TYPE.getEOperations().add((Object)counter1);
        ITERATOR_TYPE.getEOperations().add((Object)elements);
        ITERATOR_TYPE.setInstanceClass(XpandIterator.class);
        XECORE.getEClassifiers().add((Object)ITERATOR_TYPE);
    }

    public static EClassifier getType(ExecutionContext ctx, Object obj) {
        return BuiltinMetaModel.getType(ctx.getOCLEnvironment(), obj);
    }

    public static EClassifier getType(EcoreEnvironment env, Object obj) {
        if (obj instanceof Collection) {
            EClassifier firstElementType = ((Collection)obj).isEmpty() ? null : BuiltinMetaModel.getType(env, ((Collection)obj).iterator().next());
            TypeResolver tr = env.getTypeResolver();
            OCLStandardLibrary stdLib = env.getOCLStandardLibrary();
            if (obj instanceof Set) {
                return (EClassifier)tr.resolveCollectionType(CollectionKind.SET_LITERAL, (Object)(firstElementType == null ? (EClassifier)stdLib.getOclVoid() : firstElementType));
            }
            if (obj instanceof List) {
                return (EClassifier)tr.resolveCollectionType(CollectionKind.SEQUENCE_LITERAL, (Object)(firstElementType == null ? (EClassifier)stdLib.getOclVoid() : firstElementType));
            }
            return (EClassifier)tr.resolveCollectionType(CollectionKind.COLLECTION_LITERAL, (Object)(firstElementType == null ? (EClassifier)stdLib.getOclVoid() : firstElementType));
        }
        if (obj instanceof Enumerator) {
            return EcorePackage.eINSTANCE.getEEnumerator();
        }
        if (obj == null) {
            return (EClassifier)env.getOCLStandardLibrary().getOclVoid();
        }
        if (obj == env.getOCLStandardLibrary().getInvalid()) {
            return (EClassifier)env.getOCLStandardLibrary().getOclInvalid();
        }
        return (EClassifier)EcoreEnvironmentFactory.INSTANCE.createEvaluationEnvironment().getType(obj);
    }

    public static boolean isAssignableFrom(ExecutionContext ctx, EClassifier t1, EClassifier t2) {
        return (3 & BuiltinMetaModel.getRelationship(ctx.getOCLEnvironment(), t1, t2)) != 0;
    }

    public static int getRelationship(EcoreEnvironment env, EClassifier t1, EClassifier t2) {
        if (t1 instanceof EEnum && t2 == EcorePackage.eINSTANCE.getEEnumerator()) {
            return 3;
        }
        return TypeUtil.getRelationship((Environment)env, (Object)t2, (Object)t1);
    }
}

