/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.profile.internal.checkers;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.IPluginChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.MarkersService;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.PluginValidationService;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.ProjectManagementService;
import org.eclipse.papyrus.toolsmiths.validation.profile.Activator;
import org.eclipse.papyrus.toolsmiths.validation.profile.internal.checkers.ProfileBuildChecker;
import org.eclipse.papyrus.toolsmiths.validation.profile.internal.checkers.ProfileDefinitionChecker;
import org.eclipse.papyrus.toolsmiths.validation.profile.internal.checkers.ProfileDependenciesChecker;
import org.eclipse.papyrus.toolsmiths.validation.profile.internal.checkers.ProfileExtensionsChecker;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Profile;

public class ProfilePluginChecker {
    public static void checkProfilePlugin(IProject project) {
        Shell shell = Display.getCurrent().getActiveShell();
        try {
            new ProgressMonitorDialog(shell).run(true, true, monitor -> {
                Collection profileFiles = ProjectManagementService.getFilesFromProject((IContainer)project, (String)"profile.uml", (boolean)true);
                monitor.beginTask("Validate Profile plug-in.", 1 + profileFiles.size() * 4);
                monitor.subTask("Prepare validation.");
                MarkersService.deleteMarkers((IResource)project, (String)"org.eclipse.papyrus.toolsmiths.validation.profile.diagnostic");
                monitor.worked(1);
                PluginValidationService pluginValidationService = new PluginValidationService();
                for (IFile profileFile : profileFiles) {
                    URI profileFileURI = URI.createPlatformResourceURI((String)profileFile.getFullPath().toOSString(), (boolean)true);
                    Collection<Profile> profiles = ProfilePluginChecker.loadProfiles(profileFileURI);
                    if (!profiles.isEmpty()) {
                        pluginValidationService.addPluginChecker((IPluginChecker)new ProfileExtensionsChecker(project, profileFile, profiles));
                        pluginValidationService.addPluginChecker((IPluginChecker)new ProfileDefinitionChecker(profileFile, profiles));
                        pluginValidationService.addPluginChecker((IPluginChecker)new ProfileDependenciesChecker(project, profileFile, profiles.iterator().next().eResource()));
                    }
                    pluginValidationService.addPluginChecker((IPluginChecker)new ProfileBuildChecker(project, profileFile));
                }
                monitor.worked(1);
                pluginValidationService.validate(monitor);
            });
        }
        catch (InvocationTargetException e) {
            Activator.log.error((Throwable)e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static Collection<Profile> loadProfiles(URI uri) {
        HashSet<Profile> profiles = new HashSet<Profile>();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        try {
            Resource resource = resourceSet.getResource(uri, true);
            if (resource != null && !resource.getContents().isEmpty()) {
                TreeIterator contentIt = resource.getAllContents();
                while (contentIt.hasNext()) {
                    EObject content = (EObject)contentIt.next();
                    if (!(content instanceof Profile)) continue;
                    profiles.add((Profile)content);
                }
            }
        }
        catch (Exception ex) {
            Activator.log.error("Cannot load file: " + uri.toString(), (Throwable)ex);
        }
        return profiles;
    }
}

