/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.comparator;

import java.text.Collator;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.sort.SortDirectionEnum;
import org.eclipse.papyrus.infra.nattable.comparator.AbstractAxisComparator;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.utils.LabelProviderCellContextElementWrapper;

public class RowComparator
extends AbstractAxisComparator {
    private LabelProviderCellContextElementWrapper wrapper1 = new LabelProviderCellContextElementWrapper();
    private LabelProviderCellContextElementWrapper wrapper2 = new LabelProviderCellContextElementWrapper();

    public RowComparator(Object selectedColumn, SortDirectionEnum direction, INattableModelManager tableManager) {
        super(selectedColumn, direction, tableManager);
        this.wrapper1.setConfigRegistry(this.configRegistry);
        this.wrapper2.setConfigRegistry(this.configRegistry);
    }

    @Override
    public int compare(Object o1, Object o2) {
        int index_01 = this.tableManager.getRowElementsList().indexOf(o1);
        int index_02 = this.tableManager.getRowElementsList().indexOf(o2);
        int columnIndex = this.tableManager.getColumnElementsList().indexOf(this.selectedColumn);
        if (columnIndex == -1) {
            return 0;
        }
        ILayerCell cell_O1 = this.stack.getSelectionLayer().getCellByPosition(columnIndex, index_01);
        ILayerCell cell_O2 = this.stack.getSelectionLayer().getCellByPosition(columnIndex, index_02);
        this.wrapper1.setCell(cell_O1);
        this.wrapper1.setObject(cell_O1.getDataValue());
        this.wrapper2.setCell(cell_O2);
        this.wrapper2.setObject(cell_O2.getDataValue());
        String txt1 = this.serv.getLabelProvider("org.eclipse.papyrus.infra.nattable.full.labelprovider").getText((Object)this.wrapper1);
        String txt2 = this.serv.getLabelProvider("org.eclipse.papyrus.infra.nattable.full.labelprovider").getText((Object)this.wrapper2);
        int res = this.direction == SortDirectionEnum.DESC ? Collator.getInstance().compare(txt2, txt1) : Collator.getInstance().compare(txt1, txt2);
        return res;
    }
}

