/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.oclconstraintevaluation;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.uml.oclconstraintevaluation.OCLEvaluationView;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Profile;

public class ComputeConstraintHandler
extends AbstractHandler {
    protected EObject getSelectedElement() {
        EObject eObject = null;
        Object selection = null;
        selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            selection = structuredSelection.getFirstElement();
        }
        if (selection != null) {
            if (selection instanceof IAdaptable) {
                selection = ((IAdaptable)selection).getAdapter(EObject.class);
            }
            if (selection instanceof EObject) {
                eObject = (EObject)selection;
            }
        }
        return eObject;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Constraint constraint;
        EObject selectedObject = this.getSelectedElement();
        if (selectedObject instanceof Constraint && (constraint = (Constraint)selectedObject).getSpecification() instanceof OpaqueExpression) {
            OpaqueExpression opaqueExpression = (OpaqueExpression)constraint.getSpecification();
            int indexOfOCLBody = -1;
            int i = 0;
            while (i < opaqueExpression.getLanguages().size() && indexOfOCLBody == -1) {
                if (((String)opaqueExpression.getLanguages().get(i)).equals("OCL")) {
                    indexOfOCLBody = i;
                }
                ++i;
            }
            if (indexOfOCLBody != -1) {
                try {
                    OCLEvaluationView view = (OCLEvaluationView)HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().showView(OCLEvaluationView.ID);
                    view.compute((EObject)constraint.getContext(), (String)opaqueExpression.getBodies().get(indexOfOCLBody));
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    protected org.eclipse.uml2.uml.Package getToPackage(Element elem) {
        org.eclipse.uml2.uml.Package tmp = elem.getNearestPackage();
        while (tmp.getOwner() != null && tmp.getOwner() instanceof Package) {
            tmp = (org.eclipse.uml2.uml.Package)tmp.getOwner();
        }
        return tmp;
    }

    public boolean isEnabled() {
        EObject eObject = this.getSelectedElement();
        return eObject instanceof Constraint && !(this.getToPackage((Element)eObject) instanceof Profile);
    }
}

