/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.bundles.tests;

import java.io.File;
import java.util.Calendar;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.papyrus.bundles.tests.apireport.API2HTML;
import org.eclipse.papyrus.bundles.tests.apireport.APIReportGenerator;
import org.eclipse.papyrus.bundles.tests.apireport.ReportFixture;
import org.eclipse.papyrus.junit.framework.classification.tests.AbstractPapyrusTest;
import org.eclipse.papyrus.junit.utils.PrintingProgressMonitor;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assume;
import org.junit.Test;

public class APIReports
extends AbstractPapyrusTest {
    public static final String APIREPORT_BASELINE_PROPERTY = "apireport.baseline";
    public static final String APIREPORT_OUTPUT_DIR_PROPERTY = "apireport.outputdir";
    public static final String APIREPORT_VERBOSE = "apireport.verbose";

    @Test
    public void apiDeltaReport() throws Exception {
        String baseline = System.getProperty(APIREPORT_BASELINE_PROPERTY, "");
        Assume.assumeThat((String)"No API baseline specified via -Dapireport.baseline", (Object)baseline, (Matcher)CoreMatchers.not((Object)""));
        File baselineLocation = new File(baseline);
        Path outputDir = new Path(System.getProperty(APIREPORT_OUTPUT_DIR_PROPERTY, System.getProperty("user.dir")));
        ReportFixture fixture = new ReportFixture((IPath)outputDir);
        PrintingProgressMonitor progress = new PrintingProgressMonitor();
        if (!Boolean.getBoolean(APIREPORT_VERBOSE)) {
            progress = progress.filter("^\\s+add");
        }
        new APIReportGenerator(baselineLocation, fixture.getXMLReportFile()).generate((IProgressMonitor)progress);
        Calendar today = Calendar.getInstance();
        String qualifier = String.format("v%04d%02d%02d-%02d%02d%02d", today.get(1), today.get(2) + 1, today.get(5), today.get(11), today.get(12), today.get(13));
        new API2HTML(fixture.getXMLReportFile(), qualifier).generate(fixture.getHTMLReportFile());
    }
}

