/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.tooldef.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.papyrus.gmf.tooldef.ActionKind;
import org.eclipse.papyrus.gmf.tooldef.AppearanceStyle;
import org.eclipse.papyrus.gmf.tooldef.BundleImage;
import org.eclipse.papyrus.gmf.tooldef.ContextMenu;
import org.eclipse.papyrus.gmf.tooldef.CreationTool;
import org.eclipse.papyrus.gmf.tooldef.DefaultImage;
import org.eclipse.papyrus.gmf.tooldef.GMFToolFactory;
import org.eclipse.papyrus.gmf.tooldef.GMFToolPackage;
import org.eclipse.papyrus.gmf.tooldef.GenericStyleSelector;
import org.eclipse.papyrus.gmf.tooldef.GenericTool;
import org.eclipse.papyrus.gmf.tooldef.ItemRef;
import org.eclipse.papyrus.gmf.tooldef.MainMenu;
import org.eclipse.papyrus.gmf.tooldef.MenuAction;
import org.eclipse.papyrus.gmf.tooldef.Palette;
import org.eclipse.papyrus.gmf.tooldef.PaletteSeparator;
import org.eclipse.papyrus.gmf.tooldef.PopupMenu;
import org.eclipse.papyrus.gmf.tooldef.PredefinedItem;
import org.eclipse.papyrus.gmf.tooldef.PredefinedMenu;
import org.eclipse.papyrus.gmf.tooldef.Separator;
import org.eclipse.papyrus.gmf.tooldef.StandardTool;
import org.eclipse.papyrus.gmf.tooldef.StandardToolKind;
import org.eclipse.papyrus.gmf.tooldef.ToolGroup;
import org.eclipse.papyrus.gmf.tooldef.ToolRegistry;
import org.eclipse.papyrus.gmf.tooldef.Toolbar;
import org.eclipse.papyrus.gmf.tooldef.impl.BundleImageImpl;
import org.eclipse.papyrus.gmf.tooldef.impl.ContextMenuImpl;
import org.eclipse.papyrus.gmf.tooldef.impl.CreationToolImpl;
import org.eclipse.papyrus.gmf.tooldef.impl.DefaultImageImpl;
import org.eclipse.papyrus.gmf.tooldef.impl.GenericStyleSelectorImpl;
import org.eclipse.papyrus.gmf.tooldef.impl.GenericToolImpl;
import org.eclipse.papyrus.gmf.tooldef.impl.ItemRefImpl;
import org.eclipse.papyrus.gmf.tooldef.impl.MainMenuImpl;
import org.eclipse.papyrus.gmf.tooldef.impl.MenuActionImpl;
import org.eclipse.papyrus.gmf.tooldef.impl.PaletteImpl;
import org.eclipse.papyrus.gmf.tooldef.impl.PaletteSeparatorImpl;
import org.eclipse.papyrus.gmf.tooldef.impl.PopupMenuImpl;
import org.eclipse.papyrus.gmf.tooldef.impl.PredefinedItemImpl;
import org.eclipse.papyrus.gmf.tooldef.impl.PredefinedMenuImpl;
import org.eclipse.papyrus.gmf.tooldef.impl.SeparatorImpl;
import org.eclipse.papyrus.gmf.tooldef.impl.StandardToolImpl;
import org.eclipse.papyrus.gmf.tooldef.impl.ToolGroupImpl;
import org.eclipse.papyrus.gmf.tooldef.impl.ToolRegistryImpl;
import org.eclipse.papyrus.gmf.tooldef.impl.ToolbarImpl;

public class GMFToolFactoryImpl
extends EFactoryImpl
implements GMFToolFactory {
    public static GMFToolFactory init() {
        try {
            GMFToolFactory theGMFToolFactory = (GMFToolFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/papyrus/gmf/2020/ToolDefinition");
            if (theGMFToolFactory != null) {
                return theGMFToolFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new GMFToolFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createToolRegistry();
            }
            case 3: {
                return this.createPaletteSeparator();
            }
            case 4: {
                return this.createToolGroup();
            }
            case 5: {
                return this.createPalette();
            }
            case 6: {
                return this.createStandardTool();
            }
            case 7: {
                return this.createCreationTool();
            }
            case 8: {
                return this.createGenericTool();
            }
            case 11: {
                return this.createSeparator();
            }
            case 12: {
                return this.createPredefinedItem();
            }
            case 13: {
                return this.createPredefinedMenu();
            }
            case 15: {
                return this.createMenuAction();
            }
            case 16: {
                return this.createItemRef();
            }
            case 17: {
                return this.createContextMenu();
            }
            case 18: {
                return this.createPopupMenu();
            }
            case 19: {
                return this.createMainMenu();
            }
            case 20: {
                return this.createToolbar();
            }
            case 22: {
                return this.createDefaultImage();
            }
            case 23: {
                return this.createBundleImage();
            }
            case 25: {
                return this.createGenericStyleSelector();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 26: {
                return this.createStandardToolKindFromString(eDataType, initialValue);
            }
            case 27: {
                return this.createActionKindFromString(eDataType, initialValue);
            }
            case 28: {
                return this.createAppearanceStyleFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 26: {
                return this.convertStandardToolKindToString(eDataType, instanceValue);
            }
            case 27: {
                return this.convertActionKindToString(eDataType, instanceValue);
            }
            case 28: {
                return this.convertAppearanceStyleToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public ToolRegistry createToolRegistry() {
        ToolRegistryImpl toolRegistry = new ToolRegistryImpl();
        return toolRegistry;
    }

    @Override
    public PaletteSeparator createPaletteSeparator() {
        PaletteSeparatorImpl paletteSeparator = new PaletteSeparatorImpl();
        return paletteSeparator;
    }

    @Override
    public ToolGroup createToolGroup() {
        ToolGroupImpl toolGroup = new ToolGroupImpl();
        return toolGroup;
    }

    @Override
    public Palette createPalette() {
        PaletteImpl palette = new PaletteImpl();
        return palette;
    }

    @Override
    public StandardTool createStandardTool() {
        StandardToolImpl standardTool = new StandardToolImpl();
        return standardTool;
    }

    @Override
    public CreationTool createCreationTool() {
        CreationToolImpl creationTool = new CreationToolImpl();
        return creationTool;
    }

    @Override
    public GenericTool createGenericTool() {
        GenericToolImpl genericTool = new GenericToolImpl();
        return genericTool;
    }

    @Override
    public Separator createSeparator() {
        SeparatorImpl separator = new SeparatorImpl();
        return separator;
    }

    @Override
    public PredefinedItem createPredefinedItem() {
        PredefinedItemImpl predefinedItem = new PredefinedItemImpl();
        return predefinedItem;
    }

    @Override
    public PredefinedMenu createPredefinedMenu() {
        PredefinedMenuImpl predefinedMenu = new PredefinedMenuImpl();
        return predefinedMenu;
    }

    @Override
    public MenuAction createMenuAction() {
        MenuActionImpl menuAction = new MenuActionImpl();
        return menuAction;
    }

    @Override
    public ItemRef createItemRef() {
        ItemRefImpl itemRef = new ItemRefImpl();
        return itemRef;
    }

    @Override
    public ContextMenu createContextMenu() {
        ContextMenuImpl contextMenu = new ContextMenuImpl();
        return contextMenu;
    }

    @Override
    public PopupMenu createPopupMenu() {
        PopupMenuImpl popupMenu = new PopupMenuImpl();
        return popupMenu;
    }

    @Override
    public MainMenu createMainMenu() {
        MainMenuImpl mainMenu = new MainMenuImpl();
        return mainMenu;
    }

    @Override
    public Toolbar createToolbar() {
        ToolbarImpl toolbar = new ToolbarImpl();
        return toolbar;
    }

    @Override
    public DefaultImage createDefaultImage() {
        DefaultImageImpl defaultImage = new DefaultImageImpl();
        return defaultImage;
    }

    @Override
    public BundleImage createBundleImage() {
        BundleImageImpl bundleImage = new BundleImageImpl();
        return bundleImage;
    }

    @Override
    public GenericStyleSelector createGenericStyleSelector() {
        GenericStyleSelectorImpl genericStyleSelector = new GenericStyleSelectorImpl();
        return genericStyleSelector;
    }

    public StandardToolKind createStandardToolKindFromString(EDataType eDataType, String initialValue) {
        StandardToolKind result = StandardToolKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertStandardToolKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public ActionKind createActionKindFromString(EDataType eDataType, String initialValue) {
        ActionKind result = ActionKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertActionKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public AppearanceStyle createAppearanceStyleFromString(EDataType eDataType, String initialValue) {
        AppearanceStyle result = AppearanceStyle.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertAppearanceStyleToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public GMFToolPackage getGMFToolPackage() {
        return (GMFToolPackage)this.getEPackage();
    }

    @Deprecated
    public static GMFToolPackage getPackage() {
        return GMFToolPackage.eINSTANCE;
    }
}

