/**
 * Copyright (c) 2015 CEA LIST and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   CEA LIST - Initial API and implementation
 * 
 */
package org.eclipse.papyrus.papyrusgmfgenextension;

import org.eclipse.emf.ecore.EFactory;

/**
 * <!-- begin-user-doc -->
 * The <b>Factory</b> for the model.
 * It provides a create method for each non-abstract class of the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.papyrus.papyrusgmfgenextension.PapyrusgmfgenextensionPackage
 * @generated
 */
public interface PapyrusgmfgenextensionFactory extends EFactory {
	/**
	 * The singleton instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	PapyrusgmfgenextensionFactory eINSTANCE = org.eclipse.papyrus.papyrusgmfgenextension.impl.PapyrusgmfgenextensionFactoryImpl.init();

	/**
	 * Returns a new object of class '<em>Extended Gen View</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Extended Gen View</em>'.
	 * @generated
	 */
	ExtendedGenView createExtendedGenView();

	/**
	 * Returns a new object of class '<em>Commented Element</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Commented Element</em>'.
	 * @generated
	 */
	CommentedElement createCommentedElement();

	/**
	 * Returns a new object of class '<em>Property Refresh Hook</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Property Refresh Hook</em>'.
	 * @generated
	 */
	PropertyRefreshHook createPropertyRefreshHook();

	/**
	 * Returns a new object of class '<em>External Hook</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>External Hook</em>'.
	 * @generated
	 */
	ExternalHook createExternalHook();

	/**
	 * Returns a new object of class '<em>Specific Locator</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Specific Locator</em>'.
	 * @generated
	 */
	SpecificLocator createSpecificLocator();

	/**
	 * Returns a new object of class '<em>Papyrus Extension Root Node</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Papyrus Extension Root Node</em>'.
	 * @generated
	 */
	PapyrusExtensionRootNode createPapyrusExtensionRootNode();

	/**
	 * Returns a new object of class '<em>Alternate Canvas</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Alternate Canvas</em>'.
	 * @generated
	 */
	AlternateCanvas createAlternateCanvas();

	/**
	 * Returns a new object of class '<em>Alternate Gen Top Level Node</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Alternate Gen Top Level Node</em>'.
	 * @generated
	 */
	AlternateGenTopLevelNode createAlternateGenTopLevelNode();

	/**
	 * Returns a new object of class '<em>Alternate Gen Link</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Alternate Gen Link</em>'.
	 * @generated
	 */
	AlternateGenLink createAlternateGenLink();

	/**
	 * Returns a new object of class '<em>Mutating Canvas</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Mutating Canvas</em>'.
	 * @generated
	 */
	MutatingCanvas createMutatingCanvas();

	/**
	 * Returns a new object of class '<em>Owned Editpart</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Owned Editpart</em>'.
	 * @generated
	 */
	OwnedEditpart createOwnedEditpart();

	/**
	 * Returns a new object of class '<em>Specific Diagram Updater</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Specific Diagram Updater</em>'.
	 * @generated
	 */
	SpecificDiagramUpdater createSpecificDiagramUpdater();

	/**
	 * Returns a new object of class '<em>Gen Node Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Gen Node Constraint</em>'.
	 * @generated
	 */
	GenNodeConstraint createGenNodeConstraint();

	/**
	 * Returns a new object of class '<em>Specific Locator External Label</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Specific Locator External Label</em>'.
	 * @generated
	 */
	SpecificLocatorExternalLabel createSpecificLocatorExternalLabel();

	/**
	 * Returns a new object of class '<em>Additional Edit Part Candies</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Additional Edit Part Candies</em>'.
	 * @generated
	 */
	AdditionalEditPartCandies createAdditionalEditPartCandies();

	/**
	 * Returns a new object of class '<em>Edit Part Using Delete Service</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Edit Part Using Delete Service</em>'.
	 * @generated
	 */
	EditPartUsingDeleteService createEditPartUsingDeleteService();

	/**
	 * Returns a new object of class '<em>Edit Part Using Reorient Service</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Edit Part Using Reorient Service</em>'.
	 * @generated
	 */
	EditPartUsingReorientService createEditPartUsingReorientService();

	/**
	 * Returns a new object of class '<em>Label Visibility Preference</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Label Visibility Preference</em>'.
	 * @generated
	 */
	LabelVisibilityPreference createLabelVisibilityPreference();

	/**
	 * Returns a new object of class '<em>Compartment Visibility Preference</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Compartment Visibility Preference</em>'.
	 * @generated
	 */
	CompartmentVisibilityPreference createCompartmentVisibilityPreference();

	/**
	 * Returns a new object of class '<em>Compartment Title Visibility Preference</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Compartment Title Visibility Preference</em>'.
	 * @generated
	 */
	CompartmentTitleVisibilityPreference createCompartmentTitleVisibilityPreference();

	/**
	 * Returns a new object of class '<em>Constrained By Reference Compartment Item Semantic Edit Policy</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Constrained By Reference Compartment Item Semantic Edit Policy</em>'.
	 * @generated
	 */
	ConstrainedByReferenceCompartmentItemSemanticEditPolicy createConstrainedByReferenceCompartmentItemSemanticEditPolicy();

	/**
	 * Returns a new object of class '<em>Generate Using Element Type Creation Command</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Generate Using Element Type Creation Command</em>'.
	 * @generated
	 */
	GenerateUsingElementTypeCreationCommand createGenerateUsingElementTypeCreationCommand();

	/**
	 * Returns a new object of class '<em>Custom Diagram Updater Singleton</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Custom Diagram Updater Singleton</em>'.
	 * @generated
	 */
	CustomDiagramUpdaterSingleton createCustomDiagramUpdaterSingleton();

	/**
	 * Returns a new object of class '<em>Specific Node Plate</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Specific Node Plate</em>'.
	 * @generated
	 */
	SpecificNodePlate createSpecificNodePlate();

	/**
	 * Returns a new object of class '<em>Gen Visual Type Provider</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Gen Visual Type Provider</em>'.
	 * @generated
	 */
	GenVisualTypeProvider createGenVisualTypeProvider();

	/**
	 * Returns a new object of class '<em>Visual ID Override</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Visual ID Override</em>'.
	 * @generated
	 */
	VisualIDOverride createVisualIDOverride();

	/**
	 * Returns the package supported by this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the package supported by this factory.
	 * @generated
	 */
	PapyrusgmfgenextensionPackage getPapyrusgmfgenextensionPackage();

} //PapyrusgmfgenextensionFactory
