/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.architecture.internal.checkers;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.core.architecture.ADElement;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDomain;
import org.eclipse.papyrus.infra.core.architecture.ArchitecturePackage;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureViewpoint;
import org.eclipse.papyrus.infra.core.architecture.Concern;
import org.eclipse.papyrus.infra.core.architecture.RepresentationKind;
import org.eclipse.papyrus.infra.core.architecture.Stakeholder;
import org.eclipse.papyrus.infra.core.architecture.util.ArchitectureSwitch;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.types.ElementTypeSetConfiguration;
import org.eclipse.papyrus.toolsmiths.validation.architecture.constants.ArchitecturePluginValidationConstants;
import org.eclipse.papyrus.toolsmiths.validation.architecture.internal.messages.Messages;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.CustomModelChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.IPluginChecker2;
import org.eclipse.papyrus.toolsmiths.validation.common.internal.utils.ArchitectureIndex;
import org.eclipse.papyrus.toolsmiths.validation.common.internal.utils.ProjectManagementUtils;

public class ArchitectureCustomValidator
extends CustomModelChecker.SwitchValidator {
    private static final String ELEM_ELEMENT_TYPE_SET = "elementTypeSet";
    private final ArchitectureSwitch<Boolean> explicitMergeTester = new ExplicitMergeTester();

    public ArchitectureCustomValidator(String nsURI) {
        super(nsURI);
    }

    public void validate(ADElement element, DiagnosticChain diagnostics, Map<Object, Object> context) {
        this.validateImplicitMerge(element, diagnostics, context);
    }

    public void validate(RepresentationKind representation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        this.validateRepresentationKindUsed(representation, diagnostics, context);
    }

    public void validate(ArchitectureContext architecture, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (architecture.getId() != null) {
            architecture.getElementTypes().forEach(typeSet -> this.validateElementTypesContextID(architecture, (ElementTypeSetConfiguration)typeSet, diagnostics, context));
        }
        if (!architecture.isExtension()) {
            this.validateContextHasRepresentationsAdvice(architecture, diagnostics, context);
        }
    }

    private void validateElementTypesContextID(ArchitectureContext architecture, ElementTypeSetConfiguration typeSet, DiagnosticChain diagnostics, Map<Object, Object> context) {
        List registrations;
        Collection collection = registrations = typeSet == null || typeSet.eIsProxy() ? List.of() : (Collection)ProjectManagementUtils.getExtensionElements((String)"org.eclipse.papyrus.infra.types.core.elementTypeSetConfiguration", (String)ELEM_ELEMENT_TYPE_SET, (String[])new String[0]).filter(ProjectManagementUtils.resourcePathIs((String)"path", (URI)typeSet.eResource().getURI())).collect(Collectors.toList());
        if (!registrations.isEmpty()) {
            if (registrations.stream().noneMatch(ProjectManagementUtils.hasAttribute((String)"clientContextID", architecture.getId()::equals))) {
                diagnostics.add(this.createDiagnostic(2, (EObject)architecture, this.format(Messages.ArchitectureCustomValidator_2, context, new Object[]{typeSet})));
            }
        }
    }

    private void validateRepresentationKindUsed(RepresentationKind representation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.findArchitectureContextReference(representation)) {
            diagnostics.add(this.createDiagnostic(2, (EObject)representation, this.format(Messages.ArchitectureCustomValidator_3, context, new Object[]{representation})));
        }
    }

    protected boolean findArchitectureContextReference(RepresentationKind representation) {
        boolean result;
        boolean bl = result = !this.requireCrossReferenceAdapter((EObject)representation).getInverseReferences((EObject)representation, ArchitecturePackage.Literals.ARCHITECTURE_VIEWPOINT__REPRESENTATION_KINDS, false).isEmpty();
        if (!result) {
            result = ArchitectureIndex.getInstance().isReferenced((EObject)representation, ArchitecturePackage.Literals.ARCHITECTURE_VIEWPOINT__REPRESENTATION_KINDS);
        }
        return result;
    }

    private ECrossReferenceAdapter requireCrossReferenceAdapter(EObject object) {
        ECrossReferenceAdapter result = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)object);
        if (result == null) {
            ResourceSet rset;
            result = new ECrossReferenceAdapter();
            Resource resource = object.eResource();
            ResourceSet resourceSet = rset = resource != null ? resource.getResourceSet() : null;
            if (rset != null) {
                rset.eAdapters().add((Object)result);
            } else if (resource != null) {
                resource.eAdapters().add((Object)result);
            } else {
                object.eAdapters().add((Object)result);
            }
        }
        return result;
    }

    private void validateImplicitMerge(ADElement element, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Collection all;
        String name = element.getQualifiedName();
        if (name != null && !this.isExplicitlyMerged(element) && (all = ArchitectureIndex.getInstance().getElementsByQualifiedName(element.eClass(), element.getQualifiedName())).size() > 1) {
            diagnostics.add(this.createDiagnostic(2, (EObject)element, this.format(Messages.ArchitectureCustomValidator_4, context, new Object[]{element})));
        }
    }

    private boolean isExplicitlyMerged(ADElement element) {
        return (Boolean)this.explicitMergeTester.doSwitch((EObject)element);
    }

    boolean hasSpecializations(ArchitectureContext context) {
        return ArchitectureIndex.getInstance().isReferenced((EObject)context, ArchitecturePackage.Literals.ARCHITECTURE_CONTEXT__GENERAL_CONTEXT);
    }

    boolean hasExtensions(ArchitectureContext context) {
        return ArchitectureIndex.getInstance().isReferenced((EObject)context, ArchitecturePackage.Literals.ARCHITECTURE_CONTEXT__EXTENDED_CONTEXTS);
    }

    void validateContextHasRepresentationsAdvice(ArchitectureContext architecture, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean hasAdvice = this.hasRepresentationsAdvice(architecture);
        if (!hasAdvice && architecture.getGeneralContext() != null) {
            hasAdvice = architecture.allGeneralContexts().stream().anyMatch(this::hasRepresentationsAdvice);
        }
        if (!hasAdvice && this.hasExtensions(architecture)) {
            hasAdvice = ArchitectureIndex.getInstance().getAllExtensions(architecture).stream().anyMatch(this::hasOrInheritsRepresentationsAdvice);
        }
        if (!hasAdvice) {
            diagnostics.add(this.createDiagnostic(2, (EObject)architecture, (EStructuralFeature)ArchitecturePackage.Literals.ARCHITECTURE_CONTEXT__ELEMENT_TYPES, this.format(Messages.ArchitectureCustomValidator_0, context, new Object[]{architecture}), IPluginChecker2.problem((int)16715841), new IPluginChecker2.MarkerAttribute[0]));
        }
    }

    private boolean hasOrInheritsRepresentationsAdvice(ArchitectureContext architecture) {
        boolean result = this.hasRepresentationsAdvice(architecture);
        if (!result && architecture.getGeneralContext() != null) {
            result = architecture.allGeneralContexts().stream().anyMatch(this::hasRepresentationsAdvice);
        }
        return result;
    }

    private boolean hasRepresentationsAdvice(ArchitectureContext architecture) {
        URIConverter converter = EMFHelper.getResourceSet((EObject)architecture).getURIConverter();
        URI normalized = converter.normalize(ArchitecturePluginValidationConstants.REPRESENTATIONS_ADVICE_URI);
        EList representations = (EList)architecture.eGet((EStructuralFeature)ArchitecturePackage.Literals.ARCHITECTURE_CONTEXT__ELEMENT_TYPES, false);
        return representations.stream().map(EcoreUtil::getURI).map(URI::trimFragment).map(arg_0 -> ((URIConverter)converter).normalize(arg_0)).anyMatch(normalized::equals);
    }

    private final class ExplicitMergeTester
    extends ArchitectureSwitch<Boolean> {
        private ExplicitMergeTester() {
        }

        public Boolean defaultCase(EObject object) {
            return false;
        }

        public Boolean caseArchitectureContext(ArchitectureContext object) {
            if (!(object.getGeneralContext() != null || object.isExtension() || ArchitectureCustomValidator.this.hasSpecializations(object) || ArchitectureCustomValidator.this.hasExtensions(object))) {
                return false;
            }
            return true;
        }

        public Boolean caseArchitectureDomain(ArchitectureDomain object) {
            return object.getContexts().stream().anyMatch(arg_0 -> ((ExplicitMergeTester)this).doSwitch(arg_0));
        }

        public Boolean caseConcern(Concern object) {
            if (object.getDomain() != null && ((Boolean)this.doSwitch((EObject)object.getDomain())).booleanValue()) {
                return true;
            }
            return false;
        }

        public Boolean caseStakeholder(Stakeholder object) {
            if (object.getDomain() != null && ((Boolean)this.doSwitch((EObject)object.getDomain())).booleanValue()) {
                return true;
            }
            return false;
        }

        public Boolean caseArchitectureViewpoint(ArchitectureViewpoint object) {
            if (object.getContext() != null && ((Boolean)this.doSwitch((EObject)object.getContext())).booleanValue()) {
                return true;
            }
            return false;
        }
    }
}

