/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.menu.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.commands.wrappers.GEFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.utils.TransactionHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.ServiceUtilsForEditPart;
import org.eclipse.papyrus.infra.ui.util.ServiceUtilsForHandlers;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractGraphicalCommandHandler
extends AbstractHandler {
    private List<?> selection = Collections.EMPTY_LIST;

    protected abstract Command getCommand();

    protected Command getCommand(ExecutionEvent event) {
        return this.getCommand();
    }

    protected List<IGraphicalEditPart> getSelectedElements() {
        LinkedList<IGraphicalEditPart> result = new LinkedList<IGraphicalEditPart>();
        for (Object element : this.getSelection()) {
            if (!(element instanceof IGraphicalEditPart)) continue;
            result.add((IGraphicalEditPart)element);
        }
        return result;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            this.selection = selection instanceof IStructuredSelection ? ((IStructuredSelection)selection).toList() : Collections.EMPTY_LIST;
            this.getEditingDomain(event).getCommandStack().execute(GEFtoEMFCommandWrapper.wrap((Command)this.getCommand(event)));
        }
        finally {
            this.selection = Collections.EMPTY_LIST;
        }
        return null;
    }

    protected TransactionalEditingDomain getEditingDomain(ExecutionEvent event) {
        try {
            return ServiceUtilsForHandlers.getInstance().getTransactionalEditingDomain((Object)event);
        }
        catch (ServiceException ex) {
            return null;
        }
    }

    protected TransactionalEditingDomain getEditingDomain() {
        TransactionalEditingDomain editingDomain = null;
        for (IGraphicalEditPart editPart : this.getSelectedElements()) {
            try {
                editingDomain = ServiceUtilsForEditPart.getInstance().getTransactionalEditingDomain((Object)editPart);
                if (editingDomain == null) continue;
                break;
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
        }
        return editingDomain;
    }

    public void setEnabled(Object evaluationContext) {
        if (evaluationContext instanceof IEvaluationContext) {
            Object selection = ((IEvaluationContext)evaluationContext).getVariable("selection");
            if (selection instanceof Collection) {
                this.selection = selection instanceof List ? (List)selection : new ArrayList((Collection)selection);
            } else if (selection instanceof IStructuredSelection) {
                this.selection = ((IStructuredSelection)selection).toList();
            }
            this.setBaseEnabled(this.computeEnabled());
            this.selection = Collections.EMPTY_LIST;
        }
        super.setEnabled(evaluationContext);
    }

    protected boolean computeEnabled() {
        Command command;
        boolean result = false;
        TransactionalEditingDomain domain = this.getEditingDomain();
        if (domain != null && !TransactionHelper.isDisposed((TransactionalEditingDomain)domain) && (command = this.getCommand(null)) != null) {
            result = command.canExecute();
            command.dispose();
        }
        return result;
    }

    protected List<?> getSelection() {
        return this.selection;
    }

    public boolean isVisible() {
        return this.isEnabled();
    }
}

