/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.viewpoints.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.architecture.ArchitectureDescriptionUtils;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainManager;
import org.eclipse.papyrus.infra.architecture.representation.ModelAutoCreate;
import org.eclipse.papyrus.infra.architecture.representation.ModelRule;
import org.eclipse.papyrus.infra.architecture.representation.OwningRule;
import org.eclipse.papyrus.infra.architecture.representation.PapyrusRepresentationKind;
import org.eclipse.papyrus.infra.core.architecture.RepresentationKind;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureViewpoint;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.representation.AssistantRule;
import org.eclipse.papyrus.infra.gmfdiag.representation.ChildRule;
import org.eclipse.papyrus.infra.gmfdiag.representation.PaletteRule;
import org.eclipse.papyrus.infra.gmfdiag.representation.PapyrusDiagram;
import org.eclipse.papyrus.infra.gmfdiag.representation.PathElement;
import org.eclipse.papyrus.infra.viewpoints.policy.IProfileHelper;
import org.eclipse.papyrus.infra.viewpoints.policy.ModelAddData;
import org.eclipse.papyrus.infra.viewpoints.policy.ProfileUtils;
import org.eclipse.papyrus.infra.viewpoints.policy.RuleConstraintManager;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;

public class PolicyChecker {
    private static final boolean DEFAULT_POLICY_UNKNOWN_CHILD = false;
    private static final boolean DEFAULT_POLICY_UNKNWON_PALETTE = true;
    private static final int RESULT_PERMIT = 1;
    private static final int RESULT_UNKNOWN = 0;
    private static final int RESULT_DENY = -1;
    private IProfileHelper profileHelper = ProfileUtils.getProfileHelper();
    private Collection<MergedArchitectureViewpoint> viewpoints;

    public static PolicyChecker getFor(EObject object) {
        if (object != null && object.eResource() != null) {
            return PolicyChecker.getFor(object.eResource());
        }
        return PolicyChecker.getFor(ArchitectureDomainManager.getInstance().getDefaultArchitectureContext());
    }

    public static PolicyChecker getFor(Resource resource) {
        if (resource != null && resource.getResourceSet() != null) {
            return PolicyChecker.getFor(resource.getResourceSet());
        }
        return PolicyChecker.getFor(ArchitectureDomainManager.getInstance().getDefaultArchitectureContext());
    }

    public static PolicyChecker getFor(ResourceSet resourceSet) {
        if (resourceSet instanceof ModelSet) {
            return PolicyChecker.getFor((ModelSet)resourceSet);
        }
        return PolicyChecker.getFor(ArchitectureDomainManager.getInstance().getDefaultArchitectureContext());
    }

    public static PolicyChecker getFor(ModelSet modelSet) {
        Collection viewpoints = new ArchitectureDescriptionUtils(modelSet).getArchitectureViewpoints();
        return PolicyChecker.getFor(viewpoints);
    }

    public static PolicyChecker getFor(MergedArchitectureContext context) {
        if (context == null) {
            return new PolicyChecker(Collections.emptyList());
        }
        return new PolicyChecker(context.getViewpoints());
    }

    public static PolicyChecker getFor(Collection<MergedArchitectureViewpoint> viewpoints) {
        return new PolicyChecker(viewpoints);
    }

    public Collection<MergedArchitectureViewpoint> getViewpoints() {
        return this.viewpoints;
    }

    private PolicyChecker(Collection<MergedArchitectureViewpoint> viewpoints) {
        this.viewpoints = viewpoints;
    }

    public boolean canHaveNewView(EObject element, EObject owner, ViewPrototype prototype) {
        if (prototype == null) {
            return false;
        }
        if (!this.matchesProfiles(prototype.representationKind, owner, this.profileHelper.getAppliedProfiles(owner))) {
            return false;
        }
        if (!this.matchesProfiles(prototype.representationKind, owner, this.profileHelper.getAppliedProfiles(element))) {
            return false;
        }
        return this.matchesCreationRoot(prototype.representationKind, element, this.profileHelper.getAppliedStereotypes(element), () -> prototype.getViewCountOn(element));
    }

    public ModelAddData getChildAddData(Diagram diagram, EObject parent, EObject child) {
        ViewPrototype prototype = ViewPrototype.get((EObject)diagram);
        if (prototype == null) {
            return new ModelAddData(false);
        }
        PapyrusDiagram config = (PapyrusDiagram)prototype.representationKind;
        Collection<EClass> stereotypes = this.profileHelper.getAppliedStereotypes(child);
        while (config != null) {
            for (ChildRule rule : config.getChildRules()) {
                int result = this.allows(rule, parent.eClass(), child.eClass(), stereotypes);
                if (result == 0) continue;
                return new ModelAddData(result == 1, (EList<PathElement>)rule.getInsertionPath());
            }
            config = (PapyrusDiagram)config.getParent();
        }
        return new ModelAddData(false);
    }

    public ModelAddData getChildAddData(Diagram diagram, EClass parentType, EClass childType) {
        ViewPrototype prototype = ViewPrototype.get((EObject)diagram);
        if (prototype == null) {
            return new ModelAddData(false);
        }
        PapyrusDiagram config = (PapyrusDiagram)prototype.representationKind;
        while (config != null) {
            for (ChildRule rule : config.getChildRules()) {
                int result = this.allows(rule, parentType, childType, new ArrayList<EClass>(0));
                if (result == 0) continue;
                return new ModelAddData(result == 1, (EList<PathElement>)rule.getInsertionPath());
            }
            config = (PapyrusDiagram)config.getParent();
        }
        return new ModelAddData(false);
    }

    public boolean isInPalette(Diagram diagram, String entryID) {
        ViewPrototype prototype = ViewPrototype.get((EObject)diagram);
        if (prototype == null) {
            return false;
        }
        PapyrusDiagram config = (PapyrusDiagram)prototype.representationKind;
        while (config != null) {
            for (PaletteRule rule : config.getPaletteRules()) {
                int result = this.allows(rule, entryID);
                if (result == 0) continue;
                return result == 1;
            }
            config = (PapyrusDiagram)config.getParent();
        }
        return true;
    }

    public boolean isInModelingAssistants(Diagram diagram, IElementType elementType) {
        ViewPrototype prototype = ViewPrototype.get((EObject)diagram);
        if (prototype == null) {
            return false;
        }
        PapyrusDiagram config = (PapyrusDiagram)prototype.representationKind;
        while (config != null) {
            for (AssistantRule rule : config.getAssistantRules()) {
                int result = this.allows(rule, elementType);
                if (result == 0) continue;
                return result == 1;
            }
            config = (PapyrusDiagram)config.getParent();
        }
        return true;
    }

    public boolean isInViewpoint(PapyrusRepresentationKind kind) {
        return kind != null && this.getViewpoints().stream().flatMap(viewpoint -> viewpoint.getRepresentationKinds().stream()).anyMatch(representationKinds -> representationKinds.getQualifiedName().equals(kind.getQualifiedName()));
    }

    public Collection<ViewPrototype> getAllPrototypes() {
        ArrayList<ViewPrototype> result = new ArrayList<ViewPrototype>();
        for (MergedArchitectureViewpoint viewpoint : this.getViewpoints()) {
            for (RepresentationKind kind : viewpoint.getRepresentationKinds()) {
                PapyrusRepresentationKind view = (PapyrusRepresentationKind)kind;
                ViewPrototype proto = ViewPrototype.get(view);
                if (proto == null || result.contains(proto)) continue;
                result.add(proto);
            }
        }
        return result;
    }

    public Collection<ViewPrototype> getPrototypesFor(EObject element) {
        LinkedHashSet<ViewPrototype> result = new LinkedHashSet<ViewPrototype>();
        Collection<EPackage> profiles = this.profileHelper.getAppliedProfiles(element);
        Collection<EClass> stereotypes = this.profileHelper.getAppliedStereotypes(element);
        for (MergedArchitectureViewpoint viewpoint : this.getViewpoints()) {
            for (RepresentationKind kind : viewpoint.getRepresentationKinds()) {
                Supplier<Integer> count;
                OwningRule rule;
                ViewPrototype proto;
                PapyrusRepresentationKind view = (PapyrusRepresentationKind)kind;
                if (!this.matchesProfiles(view, element, profiles) || (proto = ViewPrototype.get(view)) == null || (rule = this.matchesCreationOwner(view, element, stereotypes, count = () -> proto.getOwnedViewCount(element))) == null) continue;
                if (rule.getNewModelPath() != null && !rule.getNewModelPath().isEmpty()) {
                    result.add(proto);
                    continue;
                }
                if (rule.getSelectDiagramRoot() != null && !rule.getSelectDiagramRoot().isEmpty()) {
                    result.add(proto);
                    continue;
                }
                count = () -> proto.getViewCountOn(element);
                if (!this.matchesCreationRoot(view, element, stereotypes, count)) continue;
                result.add(proto);
            }
        }
        return result;
    }

    public OwningRule getOwningRuleFor(ViewPrototype prototype, EObject owner) {
        Collection<EClass> stereotypes = this.profileHelper.getAppliedStereotypes(owner);
        Supplier<Integer> count = () -> prototype.getOwnedViewCount(owner);
        return this.matchesCreationOwner(prototype.representationKind, owner, stereotypes, count);
    }

    protected PapyrusRepresentationKind getRepresentationKindFrom(String implem, EObject owner, EObject root) {
        for (MergedArchitectureViewpoint viewpoint : this.getViewpoints()) {
            for (RepresentationKind kind : viewpoint.getRepresentationKinds()) {
                PapyrusRepresentationKind view = (PapyrusRepresentationKind)kind;
                if (!this.matches(view, implem, owner, root)) continue;
                return view;
            }
        }
        return null;
    }

    private boolean matches(PapyrusRepresentationKind view, String implem, EObject owner, EObject root) {
        if (!view.getImplementationID().equals(implem)) {
            return false;
        }
        if (owner != null) {
            if (!this.matchesProfiles(view, owner, this.profileHelper.getAppliedProfiles(owner))) {
                return false;
            }
            if (!this.matchesExistingOwner(view, owner, this.profileHelper.getAppliedStereotypes(owner))) {
                return false;
            }
        }
        if (root != null) {
            if (!this.matchesProfiles(view, root, this.profileHelper.getAppliedProfiles(root))) {
                return false;
            }
            if (!this.matchesExistingRoot(view, root, this.profileHelper.getAppliedStereotypes(root))) {
                return false;
            }
        }
        return true;
    }

    private boolean matchesProfiles(PapyrusRepresentationKind view, EObject context, Collection<EPackage> profiles) {
        PapyrusRepresentationKind current = view;
        while (current != null) {
            for (EPackage profile : view.getLanguage().getProfiles()) {
                EPackage localProfile = this.resolveDynamicProfile(context, profile);
                if (profiles.contains(localProfile)) continue;
                return false;
            }
            current = current.getParent();
        }
        return true;
    }

    private EPackage resolveDynamicProfile(EObject context, EPackage profile) {
        return Optional.ofNullable(EMFHelper.getResourceSet((EObject)context)).map(rset -> rset.getPackageRegistry().getEPackage(profile.getNsURI())).orElse(profile);
    }

    private boolean matchesExistingOwner(PapyrusRepresentationKind view, EObject owner, Collection<EClass> stereotypes) {
        PapyrusRepresentationKind current = view;
        while (current != null) {
            for (OwningRule rule : current.getOwningRules()) {
                int result = this.allows(rule, owner, stereotypes);
                if (result == -1) {
                    return false;
                }
                if (result != 1) continue;
                return true;
            }
            current = current.getParent();
        }
        return false;
    }

    private OwningRule matchesCreationOwner(PapyrusRepresentationKind view, EObject owner, Collection<EClass> stereotypes, Supplier<Integer> count) {
        PapyrusRepresentationKind current = view;
        while (current != null) {
            for (OwningRule rule : current.getOwningRules()) {
                int multiplicity;
                int allow = this.allows(rule, owner, stereotypes);
                if (allow == -1) {
                    return null;
                }
                if (allow == 0 || (multiplicity = rule.getMultiplicity()) != -1 && count.get() >= multiplicity || !this.allows(rule, owner)) continue;
                return rule;
            }
            current = current.getParent();
        }
        return null;
    }

    private boolean matchesExistingRoot(PapyrusRepresentationKind view, EObject root, Collection<EClass> stereotypes) {
        PapyrusRepresentationKind current = view;
        while (current != null) {
            for (ModelRule rule : current.getModelRules()) {
                int result = this.allows(rule, root, stereotypes);
                if (result == -1) {
                    return false;
                }
                if (result != 1) continue;
                return true;
            }
            current = current.getParent();
        }
        return false;
    }

    private boolean matchesCreationRoot(PapyrusRepresentationKind view, EObject root, Collection<EClass> stereotypes, Supplier<Integer> count) {
        PapyrusRepresentationKind current = view;
        while (current != null) {
            for (ModelRule rule : current.getModelRules()) {
                int multiplicity;
                int allow = this.allows(rule, root, stereotypes);
                if (allow == -1) {
                    return false;
                }
                if (allow == 0 || (multiplicity = rule.getMultiplicity()) != -1 && count.get() >= multiplicity) continue;
                return true;
            }
            current = current.getParent();
        }
        return false;
    }

    private int allows(OwningRule rule, EObject owner, Collection<EClass> stereotypes) {
        EClass c = rule.getElement();
        if (c == null || c.isSuperTypeOf(owner.eClass())) {
            for (EClass stereotype : rule.getStereotypes()) {
                EClass localStereotype = this.resolveDynamicStereotype(owner, stereotype);
                if (stereotypes.contains(localStereotype)) continue;
                return 0;
            }
            return rule.isPermit() ? 1 : -1;
        }
        return 0;
    }

    private EClass resolveDynamicStereotype(EObject context, EClass stereotype) {
        return Optional.ofNullable(this.resolveDynamicProfile(context, stereotype.getEPackage()).getEClassifier(stereotype.getName())).filter(EClass.class::isInstance).map(EClass.class::cast).orElse(stereotype);
    }

    private boolean allows(OwningRule rule, EObject owner) {
        EList modelAutoCreateList = rule.getNewModelPath();
        if (modelAutoCreateList == null || modelAutoCreateList.isEmpty()) {
            return true;
        }
        EObject current = owner;
        for (ModelAutoCreate elem : modelAutoCreateList) {
            EReference ref = elem.getFeature();
            if (ref.isMany()) {
                return true;
            }
            Object e = current.eGet((EStructuralFeature)ref);
            if (e == null) {
                return true;
            }
            current = (EObject)e;
        }
        return false;
    }

    private int allows(ModelRule rule, EObject element, Collection<EClass> stereotypes) {
        EClass c = rule.getElement();
        if (c == null || c.isSuperTypeOf(element.eClass())) {
            for (EClass stereotype : rule.getStereotypes()) {
                EClass localStereotype = this.resolveDynamicStereotype(element, stereotype);
                if (stereotypes.contains(localStereotype)) continue;
                return 0;
            }
            boolean ruleMatches = RuleConstraintManager.getInstance().matchRule(rule, element);
            if (!ruleMatches) {
                return 0;
            }
            return rule.isPermit() ? 1 : -1;
        }
        return 0;
    }

    private int allows(ChildRule rule, EClass origin, EClass element, Collection<EClass> stereotypes) {
        EClass ce = rule.getElement();
        EClass co = rule.getOrigin();
        if ((ce == null || ce.isSuperTypeOf(element)) && (co == null || co.isSuperTypeOf(origin))) {
            for (EClass stereotype : rule.getStereotypes()) {
                EClass localStereotype = this.resolveDynamicStereotype((EObject)element, stereotype);
                if (stereotypes.contains(localStereotype)) continue;
                return 0;
            }
            return rule.isPermit() ? 1 : -1;
        }
        return 0;
    }

    private int allows(PaletteRule rule, String toolID) {
        String elem = rule.getElement();
        boolean applies = elem == null;
        applies = applies || elem.length() == 0;
        applies = applies || elem != null && elem.equals(toolID);
        boolean bl = applies = applies || elem != null && elem.endsWith("*") && toolID.startsWith(elem.substring(0, elem.length() - 1));
        if (applies) {
            return rule.isPermit() ? 1 : -1;
        }
        return 0;
    }

    private int allows(AssistantRule rule, IElementType elementType) {
        return rule.matches(elementType) ? (rule.isPermit() ? 1 : -1) : 0;
    }
}

