/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.canonical;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.canonical.strategy.ISemanticChildrenStrategy;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.EdgeWithNoSemanticElementRepresentationImpl;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;
import org.eclipse.papyrus.uml.tools.utils.UMLUtil;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DirectedRelationship;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Relationship;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class DefaultUMLSemanticChildrenStrategy
implements ISemanticChildrenStrategy {
    public List<? extends EObject> getCanonicalSemanticChildren(EObject semanticFromEditPart, View viewFromEditPart) {
        ArrayList result = null;
        if (semanticFromEditPart instanceof Element) {
            Element element = (Element)semanticFromEditPart;
            Object owned = element.getOwnedElements();
            owned = Iterables.filter((Iterable)owned, (Predicate)Predicates.not((Predicate)UMLUtil.isRelationship()));
            owned = Iterables.filter((Iterable)owned, (Predicate)Predicates.not((Predicate)Predicates.and((Predicate)UMLUtil.isAssociationEnd(), this.isPropertyTypeVisualized(viewFromEditPart))));
            result = Lists.newArrayList((Iterable)owned);
        }
        return result;
    }

    protected Predicate<Object> isPropertyTypeVisualized(View viewContext) {
        final Diagram diagram = viewContext.getDiagram();
        return new Predicate<Object>(){

            public boolean apply(Object input) {
                Type type;
                boolean result = false;
                if (input instanceof Property && (type = ((Property)input).getType()) != null) {
                    for (View view : DiagramEditPartsUtil.getEObjectViews((EObject)type)) {
                        if (view.getDiagram() != diagram) continue;
                        result = true;
                        break;
                    }
                }
                return result;
            }
        };
    }

    public List<? extends EObject> getCanonicalSemanticConnections(EObject semanticFromEditPart, View viewFromEditPart) {
        Object result = null;
        if (semanticFromEditPart instanceof Element) {
            Element element = (Element)semanticFromEditPart;
            result = Lists.newArrayList((Iterable)element.getRelationships());
            result = new CleanRelationshipsSwitch(viewFromEditPart, (List<EObject>)result).doSwitch((EObject)element);
            result = new ConnectionsSwitch(viewFromEditPart, (List<EObject>)result).doSwitch((EObject)element);
        }
        return result;
    }

    public Collection<? extends EObject> getCanonicalDependents(EObject semanticFromEditPart, View viewFromEditPart) {
        Package package_;
        List<Package> result = null;
        if (semanticFromEditPart instanceof NamedElement && (package_ = ((NamedElement)semanticFromEditPart).getNearestPackage()) != null) {
            result = Collections.singletonList(package_);
        }
        return result;
    }

    protected Property getExpectedPartWithPort(View possiblePortView) {
        View parentView;
        Property result = null;
        if (possiblePortView.getElement() instanceof Port && (parentView = (View)TypeUtils.as((Object)possiblePortView.eContainer(), View.class)) != null) {
            result = (Property)TypeUtils.as((Object)parentView.getElement(), Property.class);
        }
        return result;
    }

    public Object getSource(EObject connectionElement) {
        return ConnectionSourceSwitch.INSTANCE.doSwitch(connectionElement);
    }

    public Object getTarget(EObject connectionElement) {
        return ConnectionTargetSwitch.INSTANCE.doSwitch(connectionElement);
    }

    private class CleanRelationshipsSwitch
    extends UMLSwitch<List<EObject>> {
        private final View visualContext;
        private final List<EObject> result;

        CleanRelationshipsSwitch(View visualContext, List<EObject> result) {
            this.visualContext = visualContext;
            this.result = result;
        }

        public List<EObject> doSwitch(EObject eObject) {
            super.doSwitch(eObject);
            return this.result;
        }

        public List<EObject> caseProperty(Property object) {
            if (object.getAssociation() != null) {
                this.result.remove(object.getAssociation());
            }
            return (List)super.caseProperty(object);
        }
    }

    private static class ConnectionSourceSwitch
    extends UMLSwitch<Object> {
        static final ConnectionSourceSwitch INSTANCE = new ConnectionSourceSwitch();

        private ConnectionSourceSwitch() {
        }

        public Object caseDirectedRelationship(DirectedRelationship object) {
            EList sources = object.getSources();
            return sources.isEmpty() ? null : sources.get(0);
        }

        public Object caseRelationship(Relationship object) {
            EList related = object.getRelatedElements();
            return related.isEmpty() ? null : related.get(0);
        }

        public Object caseAssociation(Association object) {
            Property sourceEnd = ConnectionSourceSwitch.getSourceEnd(object);
            return sourceEnd == null ? null : sourceEnd.getOtherEnd().getType();
        }

        static Property getSourceEnd(Association association) {
            Property result;
            EList ends = association.getMemberEnds();
            if (ends.size() != 2) {
                result = null;
            } else {
                Property end1 = (Property)ends.get(0);
                Property end2 = (Property)ends.get(1);
                result = end1.getOwningAssociation() == null ? end1 : (end2.getOwningAssociation() == null ? end2 : (association.getNavigableOwnedEnds().contains((Object)end1) ? end1 : (association.getNavigableOwnedEnds().contains((Object)end2) ? end2 : end1)));
            }
            return result;
        }

        public Object caseConnector(Connector object) {
            ConnectorEnd source;
            ConnectableElement result = null;
            EList ends = object.getEnds();
            ConnectorEnd connectorEnd = source = ends.isEmpty() ? null : (ConnectorEnd)ends.get(0);
            if (source != null) {
                result = source.getPartWithPort() != null ? ISemanticChildrenStrategy.createVisualStack((EObject)source.getPartWithPort(), (EObject)source.getRole(), (EObject[])new EObject[0]) : source.getRole();
            }
            return result;
        }

        public Object caseTransition(Transition object) {
            return object.getSource();
        }

        public Object caseActivityEdge(ActivityEdge object) {
            return object.getSource();
        }

        public Object caseMessage(Message object) {
            return object.getSendEvent();
        }
    }

    private static class ConnectionTargetSwitch
    extends UMLSwitch<Object> {
        static final ConnectionTargetSwitch INSTANCE = new ConnectionTargetSwitch();

        private ConnectionTargetSwitch() {
        }

        public Object caseDirectedRelationship(DirectedRelationship object) {
            EList targets = object.getTargets();
            return targets.isEmpty() ? null : targets.get(0);
        }

        public Object caseRelationship(Relationship object) {
            EList related = object.getRelatedElements();
            return related.size() < 2 ? null : related.get(1);
        }

        public Object caseAssociation(Association object) {
            Property sourceEnd = ConnectionSourceSwitch.getSourceEnd(object);
            return sourceEnd == null ? null : sourceEnd.getType();
        }

        public Object caseConnector(Connector object) {
            ConnectorEnd source;
            ConnectableElement result = null;
            EList ends = object.getEnds();
            ConnectorEnd connectorEnd = source = ends.isEmpty() ? null : (ConnectorEnd)ends.get(1);
            if (source != null) {
                result = source.getPartWithPort() != null ? ISemanticChildrenStrategy.createVisualStack((EObject)source.getPartWithPort(), (EObject)source.getRole(), (EObject[])new EObject[0]) : source.getRole();
            }
            return result;
        }

        public Object caseTransition(Transition object) {
            return object.getTarget();
        }

        public Object caseActivityEdge(ActivityEdge object) {
            return object.getTarget();
        }

        public Object caseMessage(Message object) {
            return object.getReceiveEvent();
        }
    }

    private class ConnectionsSwitch
    extends UMLSwitch<List<EObject>> {
        private final View visualContext;
        private final List<EObject> result;

        ConnectionsSwitch(View visualContext, List<EObject> result) {
            this.visualContext = visualContext;
            this.result = result;
        }

        public List<EObject> doSwitch(EObject eObject) {
            super.doSwitch(eObject);
            return this.result;
        }

        public List<EObject> caseConnectableElement(ConnectableElement object) {
            Property expectedPartWithPort = DefaultUMLSemanticChildrenStrategy.this.getExpectedPartWithPort(this.visualContext);
            for (ConnectorEnd next : object.getEnds()) {
                if (next.getPartWithPort() != expectedPartWithPort) continue;
                this.result.add((EObject)next.getOwner());
            }
            return (List)super.caseConnectableElement(object);
        }

        public List<EObject> caseActivityNode(ActivityNode object) {
            UniqueEList outAndIn = new UniqueEList();
            outAndIn.addAll((Collection)object.getOutgoings());
            outAndIn.addAll((Collection)object.getIncomings());
            this.result.addAll((Collection<EObject>)outAndIn);
            return (List)super.caseActivityNode(object);
        }

        public List<EObject> caseVertex(Vertex object) {
            UniqueEList outAndIn = new UniqueEList();
            outAndIn.addAll((Collection)object.getOutgoings());
            outAndIn.addAll((Collection)object.getIncomings());
            this.result.addAll((Collection<EObject>)outAndIn);
            return (List)super.caseVertex(object);
        }

        public List<EObject> caseMessageEnd(MessageEnd object) {
            this.result.add((EObject)object.getMessage());
            return (List)super.caseMessageEnd(object);
        }

        public List<EObject> caseConstraint(Constraint object) {
            EList sourceEdges = this.visualContext.getSourceEdges();
            for (EObject nextEdge : sourceEdges) {
                if (!(nextEdge instanceof View) || ((View)nextEdge).getElement() != null) continue;
                this.result.add((EObject)new EdgeWithNoSemanticElementRepresentationImpl((EObject)object, object.eContainer(), ((View)nextEdge).getType()));
                break;
            }
            return (List)super.caseConstraint(object);
        }
    }
}

