/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.codegen.util;

import com.google.inject.Inject;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.codegen.merge.java.JMerger;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.gmf.common.codegen.OutputFormatterUtil;
import org.eclipse.papyrus.gmf.internal.common.codegen.DefaultTextMerger;
import org.eclipse.papyrus.gmf.internal.common.codegen.TextMerger;
import org.eclipse.xtext.generator.AbstractFileSystemAccess;
import org.eclipse.xtext.util.StringInputStream;
import org.eclipse.xtext.util.Strings;

public class MergeFileSystemAccess
extends AbstractFileSystemAccess {
    @Inject
    private IWorkspaceRoot root;

    public void generateFile(String fileName, String slot, CharSequence contents) {
        IFile file = this.getFile(fileName, slot);
        try {
            this.createFolder(file.getParent());
            String defaultCharset = file.getCharset();
            String newContentAsString = this.postProcess(fileName, slot, contents).toString();
            if (file.exists()) {
                StringInputStream newContent = null;
                try {
                    newContent = new StringInputStream(newContentAsString, defaultCharset);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                boolean contentChanged = this.hasChanged(file, (InputStream)newContent);
                if (contentChanged && this.isJava(file)) {
                    InputStream mergedContent = null;
                    try {
                        mergedContent = this.getMergedContent(file, newContentAsString, defaultCharset);
                        file.setContents(mergedContent, true, true, null);
                    }
                    finally {
                        if (mergedContent != null) {
                            try {
                                mergedContent.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            } else {
                file.create((InputStream)new StringInputStream(newContentAsString, defaultCharset), true, null);
            }
            file.setDerived(true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    public URI getURI(String fileName, String outputConfiguration) {
        IFile file = this.getFile(fileName, outputConfiguration);
        return URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
    }

    protected IFile getFile(String fileName, String slot) {
        String outletPath = (String)this.getPathes().get(slot);
        return this.root.getFile((IPath)new Path(String.valueOf(outletPath) + "/" + fileName));
    }

    protected void createFolder(IContainer parent) throws CoreException {
        if (!parent.exists()) {
            if (!(parent instanceof IFolder)) {
                throw new RuntimeException("IContainer " + Strings.notNull((Object)parent) + " does not exist");
            }
            this.createFolder(parent.getParent());
            ((IFolder)parent).create(true, false, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private boolean hasChanged(IFile file, InputStream newContent) {
        boolean contentChanged = false;
        BufferedInputStream oldContent = null;
        try {
            try {
                if (newContent != null) {
                    oldContent = new BufferedInputStream(file.getContents());
                    int newByte = newContent.read();
                    int oldByte = oldContent.read();
                    while (newByte != -1 && oldByte != -1 && newByte == oldByte) {
                        newByte = newContent.read();
                        oldByte = oldContent.read();
                    }
                    contentChanged = newByte != oldByte;
                }
            }
            catch (CoreException e) {
                contentChanged = true;
                if (oldContent != null) {
                    try {
                        oldContent.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                try {
                    newContent.reset();
                }
                catch (IOException iOException) {}
            }
            catch (IOException e) {
                block28: {
                    contentChanged = true;
                    if (oldContent == null) break block28;
                    try {
                        oldContent.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                try {
                    newContent.reset();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            if (oldContent != null) {
                try {
                    oldContent.close();
                }
                catch (IOException iOException) {}
            }
            try {
                newContent.reset();
            }
            catch (IOException iOException) {}
        }
        return contentChanged;
    }

    private boolean isJava(IFile file) {
        return file.getFileExtension().equals("java");
    }

    private String getStringContent(IFile file, String defaultCharset) {
        InputStream in;
        String oldContentAsString = null;
        try {
            in = file.getContents();
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        try {
            oldContentAsString = this.convertStreamToString(in, 2048, defaultCharset);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return oldContentAsString;
    }

    private InputStream getMergedContent(IFile file, String newContentAsString, String defaultCharset) {
        TextMerger textMerger = this.createMergeService(file);
        String oldContentAsString = this.getStringContent(file, defaultCharset);
        String mergedString = textMerger.mergeJava(oldContentAsString, newContentAsString);
        StringInputStream mergedContent = null;
        try {
            mergedContent = new StringInputStream(mergedString, defaultCharset);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return mergedContent;
    }

    protected TextMerger createMergeService(IFile file) {
        URL controlFile = this.getJMergeControlFile();
        if (controlFile != null) {
            JControlModel controlModel = new JControlModel();
            controlModel.initialize(CodeGenUtil.instantiateFacadeHelper((String)JMerger.DEFAULT_FACADE_HELPER_CLASS), controlFile.toString());
            if (!controlModel.canMerge()) {
                throw new IllegalStateException("Can not initialize JControlModel");
            }
            return new DefaultTextMerger(OutputFormatterUtil.getDefaultLineSeparator((IProject)file.getProject()), controlModel);
        }
        return null;
    }

    protected URL getJMergeControlFile() {
        return MergeFileSystemAccess.class.getResource("emf-merge.xml");
    }

    private String convertStreamToString(InputStream is, int bufferSize, String defaultCharset) {
        char[] buffer = new char[bufferSize];
        StringBuilder out = new StringBuilder();
        try (InputStreamReader in = new InputStreamReader(is, defaultCharset);){
            int rsz;
            while ((rsz = ((Reader)in).read(buffer, 0, buffer.length)) >= 0) {
                out.append(buffer, 0, rsz);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out.toString();
    }
}

