/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.profilemigration.internal.data.structure;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class StereotypeApplicationDescriptor {
    private Stereotype stereotype;
    private Element owner;
    private Map<Property, Object> mapPropertyToApplicationValue;

    public StereotypeApplicationDescriptor(Stereotype profiledModelStereotype, Element owner) {
        this.stereotype = profiledModelStereotype;
        this.owner = owner;
        this.initMapPropertyToApplicationValue();
    }

    private void initMapPropertyToApplicationValue() {
        this.mapPropertyToApplicationValue = new HashMap<Property, Object>();
        for (Property attribute : this.stereotype.getAllAttributes()) {
            if (!(attribute.getOwner() instanceof Stereotype)) continue;
            try {
                Object value = this.owner.getValue(this.stereotype, attribute.getName());
                this.mapPropertyToApplicationValue.put(attribute, value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public Stereotype getStereotype() {
        return this.stereotype;
    }

    public void setStereotype(Stereotype profiledModelStereotype) {
        this.stereotype = profiledModelStereotype;
    }

    public Element getOwner() {
        return this.owner;
    }

    public void setOwner(Element owner) {
        this.owner = owner;
    }

    public Map<Property, Object> getMapPropertyToApplicationValue() {
        return this.mapPropertyToApplicationValue;
    }
}

