/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.example.databinding.project.ui.rcp.views;

import org.eclipse.core.databinding.ObservablesManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.example.databinding.project.ui.rcp.Activator;
import org.eclipse.emf.example.databinding.project.ui.rcp.ResourceProvider;
import org.eclipse.emf.example.databinding.project.ui.rcp.databinding.EMFObservablesManager;
import org.eclipse.emf.example.databinding.project.ui.rcp.views.ProjectExplorerPart;
import org.eclipse.emf.example.databinding.project.ui.rcp.views.ProjectFormAreaPart;
import org.eclipse.emf.example.databinding.project.ui.rcp.views.RedoAction;
import org.eclipse.emf.example.databinding.project.ui.rcp.views.UndoAction;
import org.eclipse.emf.examples.databinding.project.core.IModelResource;
import org.eclipse.emf.examples.databinding.project.core.model.project.Project;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.ISourceProviderService;

public class ProjectAdminViewPart
extends ViewPart
implements ISaveablePart2 {
    public static final String ID = "org.eclipse.emf.example.databinding.project.ui.rcp.views.ProjectAdminViewPart";
    private SashForm sashForm;
    private FormToolkit toolkit;
    private float divider = 0.2f;
    private static final String DIVIDER_KEY = "org.eclipse.emf.examples.databinding.project.ui.rcp.divider";
    private ObservablesManager mgr;
    private ObservablesManager defaultMgr;
    private IModelResource resource;
    private ProjectExplorerPart projectExplorer;
    private ProjectFormAreaPart projectDataForm;
    private IPartListener2 listener;
    private UndoAction undoAction;
    private RedoAction redoAction;
    private IModelResource.Listener modelListener;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (memento != null && memento.getFloat(DIVIDER_KEY) != null) {
            this.divider = memento.getFloat(DIVIDER_KEY).floatValue();
        }
        this.listener = new PartListenerImpl(site);
        site.getPage().addPartListener(this.listener);
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        int total = this.sashForm.getWeights()[0] + this.sashForm.getWeights()[1];
        memento.putFloat(DIVIDER_KEY, (float)this.sashForm.getWeights()[0] * 1.0f / (float)total);
    }

    public void createPartControl(Composite parent) {
        String path = this.getViewSite().getSecondaryId().replaceAll("#_#", ":");
        this.resource = Activator.getDefault().loadResource(path);
        this.modelListener = new IModelResource.Listener(){

            public void dirtyStateChanged() {
                ProjectAdminViewPart.this.firePropertyChange(257);
            }

            public void commandStackChanged() {
            }
        };
        this.resource.addListener(this.modelListener);
        if (this.resource == null) {
            throw new RuntimeException("Could not load resource!");
        }
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.sashForm = new SashForm(parent, 256);
        this.mgr = new EMFObservablesManager();
        this.defaultMgr = new ObservablesManager();
        this.mgr.runAndCollect(new Runnable(){

            public void run() {
                ProjectAdminViewPart.this.projectExplorer = new ProjectExplorerPart(ProjectAdminViewPart.this.getViewSite(), (Composite)ProjectAdminViewPart.this.sashForm, ProjectAdminViewPart.this.toolkit, ProjectAdminViewPart.this.resource.getFoundation(), ProjectAdminViewPart.this.defaultMgr);
                ProjectAdminViewPart.this.projectDataForm = new ProjectFormAreaPart(ProjectAdminViewPart.this.getViewSite(), (Composite)ProjectAdminViewPart.this.sashForm, ProjectAdminViewPart.this.toolkit, ProjectAdminViewPart.this.resource, ProjectAdminViewPart.this.defaultMgr, ProjectAdminViewPart.this.projectExplorer.getProjectObservable());
            }
        });
        int left = (int)(100.0f * this.divider);
        this.sashForm.setWeights(new int[]{left, 100 - left});
        this.makeActions();
    }

    private void makeActions() {
        this.undoAction = new UndoAction(this.resource);
        this.redoAction = new RedoAction(this.resource);
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
    }

    public void setFocus() {
        this.projectExplorer.setFocus();
    }

    public void dispose() {
        if (this.undoAction != null) {
            this.undoAction.dispose();
        }
        if (this.redoAction != null) {
            this.redoAction.dispose();
        }
        if (this.modelListener != null && this.resource != null) {
            this.resource.removeListener(this.modelListener);
        }
        ISourceProviderService s = (ISourceProviderService)this.getSite().getService(ISourceProviderService.class);
        ResourceProvider p = (ResourceProvider)s.getSourceProvider("modelresource");
        p.setModelResource(null);
        this.getSite().getPage().removePartListener(this.listener);
        this.projectDataForm.dispose();
        this.projectExplorer.dispose();
        if (this.toolkit != null) {
            this.toolkit.dispose();
        }
        if (this.defaultMgr != null) {
            this.defaultMgr.dispose();
        }
        if (this.mgr != null) {
            this.mgr.dispose();
        }
        super.dispose();
    }

    public int promptToSaveOnClose() {
        return 3;
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.resource != null) {
            IStatus s = this.resource.save();
            if (!s.isOK()) {
                Activator.getDefault().getLog().log(s);
                throw new RuntimeException();
            }
            this.firePropertyChange(257);
        }
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.resource.isDirty();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    private class PartListenerImpl
    implements IPartListener2 {
        private IViewSite site;

        public PartListenerImpl(IViewSite site) {
            this.site = site;
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            ISourceProviderService s = (ISourceProviderService)this.site.getService(ISourceProviderService.class);
            ResourceProvider p = (ResourceProvider)s.getSourceProvider("modelresource");
            p.setModelResource(ProjectAdminViewPart.this.resource);
            p.setCommitter(ProjectAdminViewPart.this.projectExplorer.getCommitter());
            p.setProject((Project)ProjectAdminViewPart.this.projectExplorer.getProjectObservable().getValue());
        }
    }
}

