/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtp2qvts;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.AbstractEdge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.AbstractEdgeRole;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.BasicSimpleEdge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Edge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.EdgeRole;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Node;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Region;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Role;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SchedulerConstants;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SimpleEdge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SimpleNavigationEdge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SimpleNode;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SimpleRegion;

public class Edges {
    public static final @NonNull ArgumentEdgeRoleFactory ARGUMENT = new ArgumentEdgeRoleFactory();
    public static final @NonNull CastEdgeRoleFactory CAST = new CastEdgeRoleFactory(null);
    public static final @NonNull IteratedEdgeRoleFactory ITERATED = new IteratedEdgeRoleFactory();
    public static final @NonNull NavigationEdgeRoleFactory NAVIGABLE_NAVIGATION = new NavigationEdgeRoleFactory(true);
    public static final @NonNull NavigationEdgeRoleFactory NAVIGATION = new NavigationEdgeRoleFactory(null);
    public static final @NonNull EdgeRole.Recursion PRIMARY_RECURSION = new RecursionEdgeRole(true);
    public static final @NonNull EdgeRole.Navigation REALIZED = new RealizedNavigationEdgeRole();
    public static final @NonNull ResultEdgeRoleFactory RESULT = new ResultEdgeRoleFactory();
    public static final @NonNull EdgeRole.Recursion SECONDARY_RECURSION = new RecursionEdgeRole(false);
    public static final @NonNull CastEdgeRoleFactory UNNAVIGABLE_CAST = new CastEdgeRoleFactory(false);
    public static final @NonNull NavigationEdgeRoleFactory UNNAVIGABLE_NAVIGATION = new NavigationEdgeRoleFactory(false);

    protected static abstract class AbstractComputationEdgeRole
    extends AbstractEdgeRole
    implements EdgeRole.Simple {
        protected AbstractComputationEdgeRole( @NonNull Role.Phase phase) {
            super(phase);
        }

        @Override
        public @NonNull SimpleEdge createEdge(@NonNull SimpleRegion region, @NonNull SimpleNode sourceNode, @Nullable String name, @NonNull SimpleNode targetNode) {
            return new BasicSimpleEdge((EdgeRole)this, region, sourceNode, name, targetNode);
        }

        @Override
        public boolean isComputation() {
            return true;
        }

        @Override
        public boolean isMergeable() {
            return true;
        }
    }

    protected static abstract class AbstractNavigationEdgeRole
    extends AbstractEdgeRole
    implements EdgeRole.Navigation {
        private final boolean isNavigable;

        protected AbstractNavigationEdgeRole( @NonNull Role.Phase phase, boolean isNavigable) {
            super(phase);
            this.isNavigable = isNavigable;
        }

        @Override
        public @NonNull SimpleNavigationEdge createEdge(@NonNull SimpleRegion region, @NonNull SimpleNode sourceNode, @NonNull Property source2targetProperty, @NonNull SimpleNode targetNode) {
            return new SimpleNavigationEdge((EdgeRole.Navigation)this, region, sourceNode, source2targetProperty, targetNode);
        }

        @Override
        public @Nullable String getLabel(@NonNull Property source2targetProperty) {
            if (source2targetProperty.eContainer() != null) {
                return String.valueOf(this.getName(source2targetProperty)) + "\\n" + SchedulerConstants.getMultiplicity((TypedElement)source2targetProperty);
            }
            return this.getName(source2targetProperty);
        }

        public @NonNull String getName(@NonNull Property source2targetProperty) {
            return source2targetProperty.getName();
        }

        @Override
        public boolean isMergeable() {
            return true;
        }

        @Override
        public final boolean isNavigable() {
            return this.isNavigable;
        }

        @Override
        public final boolean isNavigation() {
            return true;
        }

        @Override
        public @NonNull EdgeRole merge(@NonNull EdgeRole edgeRole) {
            if (edgeRole instanceof AbstractNavigationEdgeRole && this.phase == ((AbstractNavigationEdgeRole)edgeRole).phase) {
                if (this.isNavigable) {
                    return this;
                }
                if (((AbstractNavigationEdgeRole)edgeRole).isNavigable) {
                    return edgeRole;
                }
            }
            return super.merge(edgeRole);
        }

        @Override
        public String toString() {
            return (Object)((Object)this.phase) + (this.isNavigable ? "-NAVIGABLE-" : "-UNNAVIGABLE-") + this.getClass().getSimpleName();
        }
    }

    public static final class ArgumentEdgeRoleFactory {
        private static final @NonNull ArgumentEdgeRole CONSTANT_ARGUMENT = new ArgumentEdgeRole(Role.Phase.CONSTANT);
        private static final @NonNull ArgumentEdgeRole LOADED_ARGUMENT = new ArgumentEdgeRole(Role.Phase.LOADED);
        private static final @NonNull ArgumentEdgeRole PREDICATED_ARGUMENT = new ArgumentEdgeRole(Role.Phase.PREDICATED);
        public static final @NonNull ArgumentEdgeRole REALIZED_ARGUMENT = new ArgumentEdgeRole(Role.Phase.REALIZED);

        public @NonNull SimpleEdge createSimpleEdge(@NonNull SimpleRegion region, @NonNull SimpleNode sourceNode, @Nullable String name, @NonNull SimpleNode targetNode) {
            if (sourceNode.isConstant()) {
                return new BasicSimpleEdge((EdgeRole)CONSTANT_ARGUMENT, region, sourceNode, name, targetNode);
            }
            if (sourceNode.isLoaded()) {
                return new BasicSimpleEdge((EdgeRole)LOADED_ARGUMENT, region, sourceNode, name, targetNode);
            }
            if (sourceNode.isPredicated()) {
                return new BasicSimpleEdge((EdgeRole)PREDICATED_ARGUMENT, region, sourceNode, name, targetNode);
            }
            if (sourceNode.isRealized()) {
                return new BasicSimpleEdge((EdgeRole)REALIZED_ARGUMENT, region, sourceNode, name, targetNode);
            }
            throw new UnsupportedOperationException();
        }

        public static class ArgumentEdgeRole
        extends AbstractComputationEdgeRole {
            protected ArgumentEdgeRole( @NonNull Role.Phase phase) {
                super(phase);
            }

            @Override
            public boolean isArgument() {
                return true;
            }

            @Override
            public boolean isMergeable() {
                return true;
            }
        }
    }

    public static final class CastEdgeRoleFactory {
        private final @NonNull EdgeRole.Navigation LOADED_NAVIGABLE_CAST = new CastEdgeRole(Role.Phase.LOADED, true);
        private final @NonNull EdgeRole.Navigation LOADED_UNNAVIGABLE_CAST = new CastEdgeRole(Role.Phase.LOADED, false);
        private final @NonNull EdgeRole.Navigation PREDICATED_NAVIGABLE_CAST = new CastEdgeRole(Role.Phase.PREDICATED, true);
        private final @NonNull EdgeRole.Navigation PREDICATED_UNNAVIGABLE_CAST = new CastEdgeRole(Role.Phase.PREDICATED, false);
        private final @Nullable Boolean isNavigable;

        public CastEdgeRoleFactory(@Nullable Boolean isNavigable) {
            this.isNavigable = isNavigable;
        }

        public @NonNull SimpleEdge createSimpleEdge(@NonNull SimpleRegion region, @NonNull SimpleNode sourceNode, @NonNull Property source2targetProperty, @NonNull SimpleNode targetNode) {
            boolean resolvedNavigation;
            boolean bl = resolvedNavigation = this.isNavigable != null ? this.isNavigable.booleanValue() : sourceNode.isNavigable();
            if (sourceNode.isLoaded() && targetNode.isLoaded()) {
                return new SimpleNavigationEdge(resolvedNavigation ? this.LOADED_NAVIGABLE_CAST : this.LOADED_UNNAVIGABLE_CAST, region, sourceNode, source2targetProperty, targetNode);
            }
            if (sourceNode.isPredicated() || targetNode.isPredicated()) {
                return new SimpleNavigationEdge(resolvedNavigation ? this.PREDICATED_NAVIGABLE_CAST : this.PREDICATED_UNNAVIGABLE_CAST, region, sourceNode, source2targetProperty, targetNode);
            }
            throw new UnsupportedOperationException();
        }

        private static class CastEdgeRole
        extends AbstractNavigationEdgeRole {
            protected CastEdgeRole( @NonNull Role.Phase phase, boolean isNavigable) {
                super(phase, isNavigable);
            }

            @Override
            public boolean isCast() {
                return true;
            }
        }
    }

    public static final class IteratedEdgeRoleFactory {
        private static final @NonNull IteratedEdgeRole CONSTANT_ITERATED = new IteratedEdgeRole(Role.Phase.CONSTANT);
        private static final @NonNull IteratedEdgeRole LOADED_ITERATED = new IteratedEdgeRole(Role.Phase.LOADED);
        private static final @NonNull IteratedEdgeRole PREDICATED_ITERATED = new IteratedEdgeRole(Role.Phase.PREDICATED);
        private static final @NonNull IteratedEdgeRole REALIZED_ITERATED = new IteratedEdgeRole(Role.Phase.REALIZED);

        public @NonNull SimpleEdge createSimpleEdge(@NonNull SimpleRegion region, @NonNull SimpleNode sourceNode, @NonNull SimpleNode targetNode) {
            if (sourceNode.isRealized() || targetNode.isRealized()) {
                return new BasicSimpleEdge((EdgeRole)REALIZED_ITERATED, region, sourceNode, null, targetNode);
            }
            if (sourceNode.isPredicated() || targetNode.isPredicated()) {
                return new BasicSimpleEdge((EdgeRole)PREDICATED_ITERATED, region, sourceNode, null, targetNode);
            }
            if (sourceNode.isLoaded() || targetNode.isLoaded()) {
                return new BasicSimpleEdge((EdgeRole)LOADED_ITERATED, region, sourceNode, null, targetNode);
            }
            if (sourceNode.isConstant() || targetNode.isConstant()) {
                return new BasicSimpleEdge((EdgeRole)CONSTANT_ITERATED, region, sourceNode, null, targetNode);
            }
            throw new UnsupportedOperationException();
        }

        private static class IteratedEdgeRole
        extends AbstractComputationEdgeRole {
            protected IteratedEdgeRole( @NonNull Role.Phase phase) {
                super(phase);
            }
        }
    }

    public static final class NavigationEdgeRoleFactory {
        private static final @NonNull NavigationEdgeRole CONSTANT_NAVIGABLE_NAVIGATION = new NavigationEdgeRole(Role.Phase.CONSTANT, true);
        private static final @NonNull NavigationEdgeRole CONSTANT_UNNAVIGABLE_NAVIGATION = new NavigationEdgeRole(Role.Phase.CONSTANT, false);
        private static final @NonNull NavigationEdgeRole LOADED_NAVIGABLE_NAVIGATION = new NavigationEdgeRole(Role.Phase.LOADED, true);
        private static final @NonNull NavigationEdgeRole LOADED_UNNAVIGABLE_NAVIGATION = new NavigationEdgeRole(Role.Phase.LOADED, false);
        private static final @NonNull NavigationEdgeRole PREDICATED_NAVIGABLE_NAVIGATION = new PredicatedNavigationEdgeRole(true);
        private static final @NonNull NavigationEdgeRole PREDICATED_UNNAVIGABLE_NAVIGATION = new PredicatedNavigationEdgeRole(false);
        private final @Nullable Boolean isNavigable;

        public NavigationEdgeRoleFactory(@Nullable Boolean isNavigable) {
            this.isNavigable = isNavigable;
        }

        public @NonNull SimpleEdge createSimpleEdge(@NonNull SimpleRegion region, @NonNull SimpleNode sourceNode, @NonNull Property source2targetProperty, @NonNull SimpleNode targetNode) {
            boolean resolvedNavigation;
            boolean bl = resolvedNavigation = this.isNavigable != null ? this.isNavigable.booleanValue() : sourceNode.isNavigable();
            if (sourceNode.isRealized() || targetNode.isRealized()) {
                return new SimpleNavigationEdge(REALIZED, region, sourceNode, source2targetProperty, targetNode);
            }
            if (sourceNode.isPredicated() || targetNode.isPredicated()) {
                return new SimpleNavigationEdge((EdgeRole.Navigation)(resolvedNavigation ? PREDICATED_NAVIGABLE_NAVIGATION : PREDICATED_UNNAVIGABLE_NAVIGATION), region, sourceNode, source2targetProperty, targetNode);
            }
            if (sourceNode.isLoaded() || targetNode.isLoaded()) {
                return new SimpleNavigationEdge((EdgeRole.Navigation)(resolvedNavigation ? LOADED_NAVIGABLE_NAVIGATION : LOADED_UNNAVIGABLE_NAVIGATION), region, sourceNode, source2targetProperty, targetNode);
            }
            if (sourceNode.isConstant() || targetNode.isConstant()) {
                return new SimpleNavigationEdge((EdgeRole.Navigation)(resolvedNavigation ? CONSTANT_NAVIGABLE_NAVIGATION : CONSTANT_UNNAVIGABLE_NAVIGATION), region, sourceNode, source2targetProperty, targetNode);
            }
            throw new UnsupportedOperationException();
        }

        private static class NavigationEdgeRole
        extends AbstractNavigationEdgeRole {
            protected NavigationEdgeRole( @NonNull Role.Phase phase, boolean isNavigable) {
                super(phase, isNavigable);
            }
        }

        private static final class PredicatedNavigationEdgeRole
        extends NavigationEdgeRole {
            protected PredicatedNavigationEdgeRole(boolean isNavigable) {
                super(Role.Phase.PREDICATED, isNavigable);
            }

            @Override
            public @NonNull EdgeRole merge(@NonNull EdgeRole edgeRole) {
                if (edgeRole == REALIZED) {
                    return edgeRole;
                }
                return super.merge(edgeRole);
            }
        }
    }

    private static final class RealizedNavigationEdgeRole
    extends AbstractNavigationEdgeRole {
        protected RealizedNavigationEdgeRole() {
            super(Role.Phase.REALIZED, true);
        }

        @Override
        public @NonNull EdgeRole merge(@NonNull EdgeRole edgeRole) {
            if (edgeRole == NavigationEdgeRoleFactory.PREDICATED_NAVIGABLE_NAVIGATION) {
                return this;
            }
            return super.merge(edgeRole);
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    private static final class RecursionEdgeRole
    extends AbstractEdgeRole
    implements EdgeRole.Recursion {
        private boolean isPrimary;

        protected RecursionEdgeRole(boolean isPrimary) {
            super(Role.Phase.OTHER);
            this.isPrimary = isPrimary;
        }

        @Override
        public @NonNull Edge createEdge(@NonNull Region region, @NonNull Node sourceNode, @NonNull Node targetNode) {
            return new AbstractEdge(this, region, sourceNode, null, targetNode){

                @Override
                public @NonNull Iterable<@NonNull SimpleEdge> getSimpleEdges() {
                    return SchedulerConstants.EMPTY_SIMPLE_EDGE_LIST;
                }
            };
        }

        @Override
        public @NonNull String getColor() {
            return "brown";
        }

        @Override
        public @Nullable String getStyle() {
            return this.isPrimary ? super.getStyle() : "dashed";
        }

        @Override
        public boolean isRecursion() {
            return true;
        }

        @Override
        public String toString() {
            return String.valueOf(this.isPrimary ? "Primary=" : "Secondary-") + this.getClass().getSimpleName();
        }
    }

    public static final class ResultEdgeRoleFactory {
        private static final @NonNull EdgeRole CONSTANT_RESULT = new ResultEdgeRole(Role.Phase.CONSTANT);
        private static final @NonNull EdgeRole LOADED_RESULT = new ResultEdgeRole(Role.Phase.LOADED);
        private static final @NonNull EdgeRole PREDICATED_RESULT = new ResultEdgeRole(Role.Phase.PREDICATED);
        private static final @NonNull EdgeRole REALIZED_RESULT = new ResultEdgeRole(Role.Phase.REALIZED);

        public @NonNull SimpleEdge createSimpleEdge(@NonNull SimpleRegion region, @NonNull SimpleNode sourceNode, @Nullable String name, @NonNull SimpleNode targetNode) {
            if (targetNode.isConstant()) {
                return new BasicSimpleEdge(CONSTANT_RESULT, region, sourceNode, name, targetNode);
            }
            if (targetNode.isLoaded()) {
                return new BasicSimpleEdge(LOADED_RESULT, region, sourceNode, name, targetNode);
            }
            if (targetNode.isPredicated()) {
                return new BasicSimpleEdge(PREDICATED_RESULT, region, sourceNode, name, targetNode);
            }
            if (targetNode.isRealized()) {
                return new BasicSimpleEdge(REALIZED_RESULT, region, sourceNode, name, targetNode);
            }
            throw new UnsupportedOperationException();
        }

        protected static class ResultEdgeRole
        extends AbstractComputationEdgeRole {
            protected ResultEdgeRole( @NonNull Role.Phase phase) {
                super(phase);
            }

            @Override
            public boolean isMergeable() {
                return true;
            }

            @Override
            public boolean isResult() {
                return true;
            }
        }
    }
}

