/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtp2qvts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.DatumConnection;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Region;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Region2Depth;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.RootScheduledRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ScheduledRegion;

public abstract class ScheduleCache
extends Region2Depth {
    protected final @NonNull RootScheduledRegion rootScheduledRegion;
    protected final @NonNull List<@NonNull Region> callableRegions;
    private final @NonNull Map<@NonNull Region, @NonNull List<@NonNull DatumConnection>> region2incomingConnections = new HashMap<Region, List<DatumConnection>>();
    private final @NonNull Map<@NonNull Region, @NonNull List<@NonNull DatumConnection>> region2loopingConnections = new HashMap<Region, List<DatumConnection>>();
    private final @NonNull Map<@NonNull Region, @NonNull List<@NonNull DatumConnection>> region2outgoingConnections = new HashMap<Region, List<DatumConnection>>();
    private final @NonNull Map<@NonNull DatumConnection, @NonNull List<@NonNull Region>> connection2sourceRegions = new HashMap<DatumConnection, List<Region>>();
    private final @NonNull Map<@NonNull DatumConnection, @NonNull List<@NonNull Region>> connection2targetRegions = new HashMap<DatumConnection, List<Region>>();
    private final @NonNull Set<@NonNull Region> unpassedRegions = new HashSet<Region>();

    protected ScheduleCache(@NonNull RootScheduledRegion rootScheduledRegion) {
        this.rootScheduledRegion = rootScheduledRegion;
        this.callableRegions = this.analyzeRegions(rootScheduledRegion, new ArrayList<Region>());
        Collections.sort(this.callableRegions, NameUtil.NAMEABLE_COMPARATOR);
        for (Region region : this.callableRegions) {
            this.getRegionDepth(region);
        }
        for (Region region : this.callableRegions) {
            this.analyzeConnections(region);
        }
        for (Region region : this.callableRegions) {
            this.analyzeSourcesAndTargets(region);
        }
    }

    private void analyzeConnections(@NonNull Region region) {
        ArrayList<@NonNull DatumConnection> incomingConnections = new ArrayList<DatumConnection>();
        ArrayList<@NonNull DatumConnection> loopingConnections = new ArrayList<DatumConnection>();
        ArrayList<@NonNull DatumConnection> outgoingConnections = new ArrayList<DatumConnection>();
        for (DatumConnection connection : region.getIncomingConnections()) {
            for (Region sourceRegion : connection.getSourceRegions()) {
                if (region == sourceRegion) {
                    if (loopingConnections.contains(connection)) continue;
                    loopingConnections.add(connection);
                    continue;
                }
                if (incomingConnections.contains(connection)) continue;
                incomingConnections.add(connection);
            }
        }
        for (DatumConnection connection : region.getNextConnections()) {
            for (Region targetRegion : connection.getTargetRegions()) {
                if (region == targetRegion) {
                    assert (loopingConnections.contains(connection));
                    loopingConnections.add(connection);
                    continue;
                }
                if (outgoingConnections.contains(connection)) continue;
                outgoingConnections.add(connection);
            }
        }
        if (outgoingConnections.size() > 1) {
            Collections.sort(outgoingConnections, NameUtil.NAMEABLE_COMPARATOR);
        }
        this.region2incomingConnections.put(region, incomingConnections);
        this.region2loopingConnections.put(region, loopingConnections);
        this.region2outgoingConnections.put(region, outgoingConnections);
    }

    private @NonNull List<@NonNull Region> analyzeRegions(@NonNull ScheduledRegion outerScheduledRegion, @NonNull List<@NonNull Region> allCallableRegions) {
        for (Region region : outerScheduledRegion.getCallableRegions()) {
            assert (!region.isOperationRegion());
            assert (!allCallableRegions.contains(region));
            allCallableRegions.add(region);
            if (!(region instanceof ScheduledRegion)) continue;
            ScheduledRegion innerScheduledRegion = (ScheduledRegion)region;
            this.analyzeRegions(innerScheduledRegion, allCallableRegions);
        }
        return allCallableRegions;
    }

    private void analyzeSourcesAndTargets(@NonNull Region region) {
        boolean hasPassedConnection = false;
        for (DatumConnection connection : this.getOutgoingConnections(region)) {
            if (!connection.isPassed()) continue;
            hasPassedConnection = true;
            break;
        }
        if (!hasPassedConnection) {
            this.unpassedRegions.add(region);
        }
        for (DatumConnection connection : this.getIncomingConnections(region)) {
            List<Region> targetRegions;
            List<@NonNull Region> sourceRegions = this.connection2sourceRegions.get(connection);
            if (sourceRegions == null) {
                sourceRegions = new ArrayList<Region>();
                for (Region sourceRegion : connection.getSourceRegions()) {
                    if (sourceRegions.contains(sourceRegion)) continue;
                    sourceRegions.add(sourceRegion);
                }
                this.connection2sourceRegions.put(connection, sourceRegions);
            }
            if ((targetRegions = this.connection2targetRegions.get(connection)) != null) continue;
            targetRegions = new ArrayList<Region>();
            for (Region targetRegion : connection.getTargetRegions()) {
                if (targetRegions.contains(targetRegion)) continue;
                targetRegions.add(targetRegion);
            }
            this.connection2targetRegions.put(connection, targetRegions);
        }
    }

    protected @NonNull Iterable<? extends @NonNull DatumConnection> getConnections() {
        return this.connection2targetRegions.keySet();
    }

    protected @NonNull Iterable<@NonNull DatumConnection> getIncomingConnections(@NonNull Region region) {
        List<@NonNull DatumConnection> incomingConnections = this.region2incomingConnections.get(region);
        assert (incomingConnections != null);
        return incomingConnections;
    }

    protected @NonNull Iterable<@NonNull DatumConnection> getLoopingConnections(@NonNull Region region) {
        List<@NonNull DatumConnection> loopingConnections = this.region2loopingConnections.get(region);
        assert (loopingConnections != null);
        return loopingConnections;
    }

    protected @NonNull Iterable<@NonNull DatumConnection> getOutgoingConnections(@NonNull Region region) {
        List<@NonNull DatumConnection> outgoingConnections = this.region2outgoingConnections.get(region);
        assert (outgoingConnections != null);
        return outgoingConnections;
    }

    protected @NonNull Iterable<@NonNull Region> getSourceRegions(@NonNull DatumConnection connection) {
        List<@NonNull Region> sourceRegions = this.connection2sourceRegions.get(connection);
        assert (sourceRegions != null);
        return sourceRegions;
    }

    protected @NonNull Iterable<@NonNull Region> getTargetRegions(@NonNull DatumConnection connection) {
        List<@NonNull Region> targetRegions = this.connection2targetRegions.get(connection);
        assert (targetRegions != null);
        return targetRegions;
    }

    protected boolean isPassed(@NonNull Region region) {
        return !this.unpassedRegions.contains(region);
    }
}

