/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.xtext.qvtrelation.tests;

import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.internal.library.ImplementationManager;
import org.eclipse.ocl.pivot.internal.resource.EnvironmentFactoryAdapter;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.xtext.base.services.BaseLinkingService;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbase;
import org.eclipse.qvtd.xtext.qvtbase.tests.LoadTestCase;
import org.eclipse.qvtd.xtext.qvtbase.tests.utilities.XtextCompilerUtil;

public class QVTrLoadTests
extends LoadTestCase {
    public void doLoad_ModelMorf(@NonNull String stem, @NonNull String @NonNull [] messages) throws Exception {
        URI inputURI = URI.createPlatformResourceURI((String)("/org.eclipse.qvtd.examples.qvtrelation.modelmorf/models/" + stem + ".qvtr"), (boolean)true);
        URI pivotURI = this.getTestURI(String.valueOf(stem) + ".qvtras");
        this.doLoad_Concrete(inputURI, pivotURI, messages);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void doLoad_Concrete(@NonNull URI inputURI, @NonNull URI pivotURI, @NonNull String @NonNull [] messages) throws Exception {
        ClassLoader cl0 = ((Object)((Object)this)).getClass().getClassLoader();
        assert (cl0 != null);
        OCL ocl = OCL.newInstance((ProjectManager)this.getTestProjectManager());
        EnvironmentFactoryAdapter environmentFactoryAdapter = EnvironmentFactoryAdapter.find((Notifier)ocl.getResourceSet());
        assert (environmentFactoryAdapter != null);
        ImplementationManager implementationManager = environmentFactoryAdapter.getMetamodelManager().getImplementationManager();
        @NonNull @NonNull List classLoaders = implementationManager.getClassLoaders();
        if (!classLoaders.contains(cl0)) {
            implementationManager.addClassLoader(cl0);
        }
        this.doLoad_Concrete(ocl, inputURI, pivotURI, messages);
        ocl.dispose();
    }

    public void doLoad_Concrete(@NonNull URI inputURI, @NonNull String @Nullable [] messages) throws Exception {
        OCLInternal ocl = QVTbase.newInstance((ProjectManager)this.getTestProjectManager(), null);
        URI pivotURI = this.getTestURIWithExtension(inputURI, "qvtras");
        this.doLoad_Concrete((OCL)ocl, inputURI, pivotURI, messages);
        ocl.dispose();
    }

    protected void setUp() throws Exception {
        BaseLinkingService.DEBUG_RETRY.setState(true);
        XtextCompilerUtil.doQVTrelationSetup();
        super.setUp();
    }

    public void testQVTrLoad_AbstractToConcrete_qvtr() throws Exception {
        this.doLoad_ModelMorf("AbstractToConcrete/AbstractToConcrete", new String[]{"The 'Key::IdentifiesIsNotAbstract' constraint is violated for 'key ClassMM::Type {ClassMM::Type::name}'"});
    }

    public void testQVTrLoad_ClassModelToClassModel_qvtr() throws Exception {
        this.doLoad_ModelMorf("ClassModelToClassModel/ClassModelToClassModel", new String[]{"The 'RelationCallExp::WhereInvocationIsANonTopRelation' constraint is violated for 'classToClass(c1, c2)'"});
    }

    public void testQVTrLoad_DNF_bbox_qvtr() throws Exception {
        this.doLoad_ModelMorf("DNF_bbox/DNF_bbox", NO_MESSAGES);
    }

    public void testQVTrLoad_DNF_qvtr() throws Exception {
        this.doLoad_ModelMorf("DNF/DNF", NO_MESSAGES);
    }

    public void testQVTrLoad_HstmToStm_qvtr() throws Exception {
        this.doLoad_ModelMorf("HstmToStm/hstmtostm", NO_MESSAGES);
    }

    public void testQVTrLoad_Import_qvtr() throws Exception {
        this.doLoad_ModelMorf("Import/UmlToRdbms_1", NO_MESSAGES);
    }

    public void testQVTrLoad_Keys_qvtr() throws Exception {
        this.doLoad_Concrete(this.getModelsURI("misc/Keys.qvtr"), new String[]{"The 'Key::IdentifiesIsUnique' constraint is violated for 'key QVTRelation::Key {QVTRelation::Key::identifies}'", "The 'Key::IdentifiesIsUnique' constraint is violated for 'key QVTRelation::Key {QVTRelation::Key::identifies, QVTRelation::Key::part}'", "The 'Key::NoSuperKeys' constraint is violated for 'key EMOF::Class {EMOF::NamedElement::name}'", "The 'Key::IdentifiesIsNotAbstract' constraint is violated for 'key EMOF::NamedElement {EMOF::NamedElement::name}'"});
    }

    public void testQVTrLoad_MiToSiSimple_qvtr() throws Exception {
        this.doLoad_Concrete(this.getModelsURI("mitosi/MiToSiSimple.qvtr"), NO_MESSAGES);
    }

    public void testQVTrLoad_Packages_qvtr() throws Exception {
        this.doLoad_Concrete(this.getModelsURI("misc/Packages.qvtr"), NO_MESSAGES);
    }

    public void testQVTrLoad_ATL2QVTr_qvtr() throws Exception {
        URI inputURI = URI.createPlatformResourceURI((String)"/org.eclipse.qvtd.atl/model/ATL2QVTr.qvtr", (boolean)true);
        URI pivotURI = this.getTestURI("ATL2QVTr.qvtras");
        this.doLoad_Concrete(inputURI, pivotURI, new String[0]);
    }

    public void testQVTrLoad_RelToCore_qvtr() throws Exception {
        URI inputURI = URI.createPlatformResourceURI((String)"/org.eclipse.qvtd.examples.qvtrelation.reltocore/model/RelToCore.qvtr", (boolean)true);
        URI pivotURI = this.getTestURI("RelToCore.qvtras");
        this.doLoad_Concrete(inputURI, pivotURI, new String[]{"The 'Key::IdentifiesIsNotAbstract' constraint is violated for 'key EMOF::Type {EMOF::NamedElement::name}'", "The 'Key::NoSuperKeys' constraint is violated for 'key EMOF::Class {EMOF::NamedElement::name}'", "The 'Key::NoSuperKeys' constraint is violated for 'key QVTBase::Transformation {EMOF::NamedElement::name}'", "The 'RelationCallExp::WhereInvocationIsANonTopRelation' constraint is violated for 'RelationalTransformationToMappingTransformation(rt, mt)'"});
    }

    public void testQVTrLoad_SimplerRelToCore_qvtr() throws Exception {
        URI inputURI = URI.createPlatformResourceURI((String)"/org.eclipse.qvtd.examples.qvtrelation.reltocore/model/SimplerRelToCore.qvtr", (boolean)true);
        URI pivotURI = this.getTestURI("SimplerRelToCore.qvtras");
        this.doLoad_Concrete(inputURI, pivotURI, new String[]{"The 'Key::IdentifiesIsNotAbstract' constraint is violated for 'key EMOF::Type {EMOF::NamedElement::name}'", "The 'Key::NoSuperKeys' constraint is violated for 'key EMOF::Class {EMOF::NamedElement::name}'", "The 'Key::NoSuperKeys' constraint is violated for 'key QVTBase::Transformation {EMOF::NamedElement::name}'", "The 'RelationCallExp::WhereInvocationIsANonTopRelation' constraint is violated for 'RelationalTransformationToMappingTransformation(rt, mt)'"});
    }

    public void testQVTrLoad_SeqToStm_qvtr() throws Exception {
        this.doLoad_ModelMorf("SeqToStm/SeqToStm", NO_MESSAGES);
    }

    public void testQVTrLoad_SeqToStmc_CT_qvtr() throws Exception {
        this.doLoad_ModelMorf("SeqToStmc_CT/SeqToStmc", NO_MESSAGES);
    }

    public void testQVTrLoad_UmlToRdbms_qvtr() throws Exception {
        this.doLoad_ModelMorf("UmlToRdbms/UmlToRdbms", NO_MESSAGES);
    }

    public void testQVTrLoad_UmlToRel_qvtr() throws Exception {
        this.doLoad_ModelMorf("UmlToRel/UmlToRel", NO_MESSAGES);
    }
}

