/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.RegionHelper;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractPartialPartition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.MappingPartitioner;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitioningVisitor;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.utilities.ReachabilityForest;
import org.eclipse.qvtd.pivot.qvtschedule.BooleanLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.MicroMappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.SuccessNode;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

class SpeculatedPartition
extends AbstractPartialPartition {
    private final @NonNull Node traceNode;
    private final @NonNull Set<@NonNull Node> tracedInputNodes = new HashSet<Node>();

    public SpeculatedPartition(@NonNull MappingPartitioner partitioner, @NonNull ReachabilityForest reachabilityForest) {
        super(partitioner, reachabilityForest, "\u00abspeculated\u00bb");
        this.traceNode = partitioner.getTraceNode();
        this.resolveTraceNodes();
        this.resolveRealizedOutputNodes();
        this.resolveRealizedEdges();
        this.resolvePrecedingNodes();
        this.resolveDisambiguations();
        this.resolveEdges();
    }

    @Override
    public @NonNull MappingRegion createMicroMappingRegion(int partitionNumber) {
        return this.createMicroMappingRegion("\u00abspeculated\u00bb", "_p" + partitionNumber);
    }

    @Override
    protected @NonNull PartitioningVisitor createPartitioningVisitor(@NonNull MicroMappingRegion partialRegion) {
        return new PartitioningVisitor(new RegionHelper<MicroMappingRegion>(this.scheduleManager, partialRegion), this){

            public @Nullable Element visitSuccessNode(@NonNull SuccessNode node) {
                if (node == SpeculatedPartition.this.partitioner.basicGetGlobalSuccessNode(SpeculatedPartition.this.traceNode)) {
                    BooleanLiteralNode partialNode = this.regionHelper.createBooleanLiteralNode(true);
                    this.addNode((Node)node, (Node)partialNode);
                    return partialNode;
                }
                if (node == SpeculatedPartition.this.partitioner.basicGetLocalSuccessNode(SpeculatedPartition.this.traceNode)) {
                    BooleanLiteralNode partialNode = this.regionHelper.createBooleanLiteralNode(true);
                    this.addNode((Node)node, (Node)partialNode);
                    return partialNode;
                }
                return (Element)super.visitSuccessNode(node);
            }
        };
    }

    @Override
    protected @Nullable Iterable<@NonNull Node> getPreferredHeadNodes() {
        return Collections.singleton(this.traceNode);
    }

    @Override
    protected @Nullable Role resolveEdgeRole(@NonNull Role sourceNodeRole, @NonNull Edge edge, @NonNull Role targetNodeRole) {
        Object edgeRole = QVTscheduleUtil.getEdgeRole((Edge)edge);
        if (edgeRole == Role.REALIZED && this.partitioner.hasRealizedEdge(edge)) {
            edgeRole = edge.isSuccess() ? Role.PREDICATED : (edge.getEdgeTarget().isConstant() ? null : Role.PREDICATED);
        }
        return edgeRole;
    }

    protected void resolveRealizedEdges() {
        for (NavigableEdge edge : this.partitioner.getRealizedEdges()) {
            Node targetNode;
            Node sourceNode;
            if (this.partitioner.hasRealizedEdge((Edge)edge) || this.partitioner.getCorollaryOf(edge) != null || (sourceNode = edge.getEdgeSource()).isPredicated() && !this.partitioner.hasPredicatedNode(sourceNode) || (targetNode = edge.getEdgeTarget()).isPredicated() && !this.partitioner.hasPredicatedNode(targetNode)) continue;
            if (!this.hasNode(sourceNode)) {
                this.addNode(sourceNode, QVTscheduleUtil.getNodeRole((Node)sourceNode));
            }
            if (this.hasNode(targetNode)) continue;
            this.addNode(targetNode, QVTscheduleUtil.getNodeRole((Node)targetNode));
        }
    }

    protected void resolveRealizedOutputNodes() {
        for (Node node : this.regionAnalysis.getCorollaryNodes()) {
            if (this.hasNode(node) || node.isSuccess()) continue;
            this.addNode(node);
        }
    }

    protected void resolveTraceNodes() {
        assert (this.traceNode.isMatched() && this.traceNode.isClass() && this.traceNode.isPattern());
        this.addNode(this.traceNode, Role.PREDICATED);
        if (this.scheduleManager.useActivators()) {
            Node localSuccessNode = this.partitioner.basicGetLocalSuccessNode(this.traceNode);
            if (localSuccessNode != null) {
                this.addNode(localSuccessNode, Role.PREDICATED);
            }
            Node globalSuccessNode = this.partitioner.getGlobalSuccessNode(this.traceNode);
            this.addNode(globalSuccessNode, Role.PREDICATED);
        }
        for (NavigableEdge edge : this.traceNode.getNavigableEdges()) {
            if (!this.partitioner.hasRealizedEdge((Edge)edge)) continue;
            this.tracedInputNodes.add(edge.getEdgeTarget());
        }
    }
}

